/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.gui.DefTreeNode;
import com.sap.engine.services.jmsconnector.gui.LibraryTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LibraryPanel
extends JPanel {
    protected JTree libTree;
    private LibTreeModel treeModel;

    public LibraryPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Server Libraries"));
        this.setLayout(new BorderLayout());
        this.initLibrariesTree();
        this.add((Component)new JScrollPane(this.libTree), "Center");
    }

    protected void initLibrariesTree() {
        this.treeModel = new LibTreeModel();
        this.libTree = new JTree(this.treeModel);
        this.libTree.getSelectionModel().setSelectionMode(1);
        this.libTree.putClientProperty("JTree.lineStyle", "Angled");
        LibraryTreeCellRenderer renderer = new LibraryTreeCellRenderer(this.treeModel.root);
        this.libTree.setCellRenderer(renderer);
    }

    public void refreshLibraies(Hashtable serverLibs) {
        this.treeModel.refreshLibraies(serverLibs);
    }

    static class LibTreeModel
    implements TreeModel {
        protected DefTreeNode root = new DefTreeNode("All", false, 0);
        ArrayList modelListeners = new ArrayList();

        public void addTreeModelListener(TreeModelListener l) {
            this.modelListeners.add(l);
        }

        public Object getChild(Object parent, int index) {
            return ((DefTreeNode)parent).getChild(index);
        }

        public int getChildCount(Object parent) {
            return ((DefTreeNode)parent).getChildCount();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((DefTreeNode)parent).getIndexOfChild(child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((DefTreeNode)node).isLeaf();
        }

        public void removeTreeModelListener(TreeModelListener l) {
            ((AbstractCollection)this.modelListeners).remove(l);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        private void sendRemoveEvent(TreeModelEvent e) {
            Iterator i = ((AbstractList)this.modelListeners).iterator();
            while (i.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)i.next();
                treeModelListener.treeNodesRemoved(e);
            }
        }

        private void sendInsertEvent(TreeModelEvent e) {
            Iterator i = ((AbstractList)this.modelListeners).iterator();
            while (i.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)i.next();
                treeModelListener.treeNodesInserted(e);
            }
        }

        public void removeNode(DefTreeNode node) {
            DefTreeNode parent = node.getParent();
            int pos = parent.removeChild(node);
            TreeModelEvent event = new TreeModelEvent((Object)this, this.getPath(parent), new int[]{pos}, new Object[]{node});
            this.sendRemoveEvent(event);
        }

        private void addNode(DefTreeNode parent, DefTreeNode node) {
            int pos = parent.addChildSorted(node);
            TreeModelEvent event = new TreeModelEvent((Object)this, this.getPath(parent), new int[]{pos}, new Object[]{node});
            this.sendInsertEvent(event);
        }

        private Object[] getPath(DefTreeNode node) {
            DefTreeNode temp = node;
            int len = 0;
            while (temp != null) {
                temp = temp.getParent();
                ++len;
            }
            temp = node;
            Object[] path = new Object[len];
            while (temp != null) {
                path[--len] = temp;
                temp = temp.getParent();
            }
            return path;
        }

        public void refreshLibraies(Hashtable serverLibs) {
            ArrayList childs = this.root.getChilds();
            while (childs.size() != 0) {
                this.removeNode((DefTreeNode)childs.get(childs.size() - 1));
            }
            Enumeration en = serverLibs.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                DefTreeNode libNode = new DefTreeNode(key, false, 7);
                this.addNode(this.root, libNode);
                String[] jars = (String[])serverLibs.get(key);
                int j = 0;
                while (j < jars.length) {
                    int ind = jars[j].lastIndexOf(File.separatorChar);
                    if (ind != -1) {
                        jars[j] = jars[j].substring(ind + 1);
                    }
                    this.addNode(libNode, new DefTreeNode(jars[j], true, 8));
                    ++j;
                }
            }
        }
    }
}

