/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.gui.JMSManagementTreeModel;
import com.sap.engine.services.jmsconnector.gui.JMSTreeCellRenderer;
import com.sap.engine.services.jmsconnector.gui.LibraryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public abstract class JMSManagementView
extends JPanel
implements TreeSelectionListener,
ActionListener,
ChangeListener {
    private static final String IMAGES = "images/";
    protected Frame frame;
    protected JTree tree;
    protected JMSManagementTreeModel treeModel;
    protected LibraryPanel libraryPanel;
    protected JTabbedPane factortyPanel;
    protected JSplitPane splitPane;
    protected JFileChooser fileChooser;
    protected FileFilter xmlFilter;
    protected FileFilter jarZipFilter;
    protected JButton[] runtimeButtons;
    protected JButton importBtn;
    protected JButton exportBtn;
    protected JButton refreshBtn;
    protected JButton newBtn;
    protected JButton removeBtn;
    protected JButton startBtn;
    protected JButton stopBtn;
    protected JButton saveBtn;
    protected JButton copyBtn;
    protected JButton pasteBtn;
    protected JButton defineBtn;
    protected JButton undefineBtn;
    protected JPanel emptyPanel;

    public JMSManagementView() {
        this.initRuntimeButtons();
        this.initView();
    }

    protected void initView() {
        this.emptyPanel = new JPanel();
        this.initTree();
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1, true, new JScrollPane(this.tree), this.emptyPanel);
        this.add((Component)this.splitPane, "Center");
        this.disableAllButtons();
        this.libraryPanel = new LibraryPanel();
        this.libraryPanel.libTree.addTreeSelectionListener(this);
    }

    protected void disableAllButtons() {
        int i = 0;
        while (i < this.runtimeButtons.length) {
            this.runtimeButtons[i].setEnabled(false);
            ++i;
        }
        this.refreshBtn.setEnabled(true);
        this.importBtn.setEnabled(true);
    }

    public void initRuntimeButtons() {
        this.runtimeButtons = new JButton[12];
        this.importBtn = new JButton(new ImageIcon(this.getClass().getResource("images/import.gif")));
        this.importBtn.setToolTipText("Import Factory from XML");
        this.importBtn.addActionListener(this);
        this.runtimeButtons[0] = this.importBtn;
        this.exportBtn = new JButton(new ImageIcon(this.getClass().getResource("images/export.gif")));
        this.exportBtn.setToolTipText("Export this Factory to XML");
        this.exportBtn.addActionListener(this);
        this.runtimeButtons[1] = this.exportBtn;
        this.newBtn = new JButton(new ImageIcon(this.getClass().getResource("images/add.gif")));
        this.newBtn.setToolTipText("New");
        this.newBtn.addActionListener(this);
        this.runtimeButtons[2] = this.newBtn;
        this.removeBtn = new JButton(new ImageIcon(this.getClass().getResource("images/remove.gif")));
        this.removeBtn.setToolTipText("Remove");
        this.removeBtn.addActionListener(this);
        this.runtimeButtons[3] = this.removeBtn;
        this.saveBtn = new JButton(new ImageIcon(this.getClass().getResource("images/save.gif")));
        this.saveBtn.setToolTipText("Save changes");
        this.saveBtn.addActionListener(this);
        this.runtimeButtons[4] = this.saveBtn;
        this.refreshBtn = new JButton(new ImageIcon(this.getClass().getResource("images/reload.gif")));
        this.refreshBtn.setToolTipText("Refresh");
        this.refreshBtn.addActionListener(this);
        this.runtimeButtons[5] = this.refreshBtn;
        this.startBtn = new JButton(new ImageIcon(this.getClass().getResource("images/start1.gif")));
        this.startBtn.setToolTipText("Start");
        this.startBtn.addActionListener(this);
        this.runtimeButtons[6] = this.startBtn;
        this.stopBtn = new JButton(new ImageIcon(this.getClass().getResource("images/stop.gif")));
        this.stopBtn.setToolTipText("Stop");
        this.stopBtn.addActionListener(this);
        this.runtimeButtons[7] = this.stopBtn;
        this.undefineBtn = new JButton(new ImageIcon(this.getClass().getResource("images/undefine.gif")));
        this.undefineBtn.setToolTipText("Undefine");
        this.undefineBtn.addActionListener(this);
        this.runtimeButtons[8] = this.undefineBtn;
        this.defineBtn = new JButton(new ImageIcon(this.getClass().getResource("images/define.gif")));
        this.defineBtn.setToolTipText("Define");
        this.defineBtn.addActionListener(this);
        this.runtimeButtons[9] = this.defineBtn;
        this.copyBtn = new JButton(new ImageIcon(this.getClass().getResource("images/copy.gif")));
        this.copyBtn.setToolTipText("Copy");
        this.copyBtn.addActionListener(this);
        this.runtimeButtons[10] = this.copyBtn;
        this.pasteBtn = new JButton(new ImageIcon(this.getClass().getResource("images/paste.gif")));
        this.pasteBtn.setToolTipText("Paste");
        this.pasteBtn.addActionListener(this);
        this.runtimeButtons[11] = this.pasteBtn;
        this.fileChooser = new JFileChooser();
        this.xmlFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "XML (*.xml)";
            }
        };
        this.jarZipFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(".jar") || fileName.endsWith(".zip");
            }

            public String getDescription() {
                return "ZIP (*.zip), JAR (*.jar)";
            }
        };
    }

    private void initTree() {
        this.treeModel = new JMSManagementTreeModel();
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new JMSTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void stateChanged(ChangeEvent var1);
}

