/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.deploy.ApplicationInfo;
import com.sap.engine.services.jmsconnector.deploy.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.gui.DefTreeNode;
import com.sap.engine.services.jmsconnector.gui.FactoryTabbedPane;
import com.sap.engine.services.jmsconnector.gui.ResourcePanel;
import java.io.File;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JMSManagementTreeModel
implements TreeModel {
    protected DefTreeNode root = new DefTreeNode("Resources", false, 0);
    protected DefTreeNode factories = new DefTreeNode("Factories", false, 1);
    protected DefTreeNode destinations = new DefTreeNode("Destinations", false, 2);
    protected DefTreeNode libraries = new DefTreeNode("JMS Libraries", false, 3);
    protected TreePath libPath = new TreePath(new Object[]{this.root, this.libraries});
    private ArrayList modelListeners;

    public JMSManagementTreeModel() {
        this.root.addChild(this.factories);
        this.root.addChild(this.destinations);
        this.root.addChild(this.libraries);
        this.modelListeners = new ArrayList();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.modelListeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        return ((DefTreeNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        return ((DefTreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((DefTreeNode)parent).getIndexOfChild(child);
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return ((DefTreeNode)node).isLeaf();
    }

    public void removeTreeModelListener(TreeModelListener l) {
        ((AbstractCollection)this.modelListeners).remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private void sendRemoveEvent(TreeModelEvent e) {
        Iterator i = ((AbstractList)this.modelListeners).iterator();
        while (i.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)i.next();
            treeModelListener.treeNodesRemoved(e);
        }
    }

    private void sendInsertEvent(TreeModelEvent e) {
        Iterator i = ((AbstractList)this.modelListeners).iterator();
        while (i.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)i.next();
            treeModelListener.treeNodesInserted(e);
        }
    }

    public void addApplication(ApplicationInfo applicationInfo) {
        Iterator i;
        if (applicationInfo.destinationsDescriptors != null) {
            DefTreeNode appDestinations = new DefTreeNode(applicationInfo, false, 4);
            this.addNode(this.destinations, appDestinations);
            i = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
            while (i.hasNext()) {
                this.addNode(appDestinations, new DefTreeNode(i.next(), true, 6));
            }
        }
        if (applicationInfo.factoryDescriptors != null) {
            DefTreeNode appFactories = new DefTreeNode(applicationInfo, false, 4);
            this.addNode(this.factories, appFactories);
            i = ((AbstractList)applicationInfo.factoryDescriptors).iterator();
            while (i.hasNext()) {
                this.addNode(appFactories, new DefTreeNode(i.next(), true, 5));
            }
        }
    }

    public void refreshApplications(ArrayList allApplications, ArrayList jmsLibs) {
        ApplicationInfo newApplicationInfo;
        ApplicationInfo newApplicationInfo2;
        ArrayList treeApps = this.factories.getChilds();
        int i = 0;
        while (i < treeApps.size()) {
            DefTreeNode node = (DefTreeNode)treeApps.get(i);
            ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
            boolean isHere = false;
            int j = 0;
            while (j < allApplications.size()) {
                newApplicationInfo2 = (ApplicationInfo)allApplications.get(j);
                if (newApplicationInfo2.applicationName.equals(applicationInfo.applicationName)) {
                    if (newApplicationInfo2.factoryDescriptors == null) break;
                    isHere = true;
                    break;
                }
                ++j;
            }
            if (!isHere) {
                this.removeNode(node);
                continue;
            }
            ++i;
        }
        treeApps = this.destinations.getChilds();
        int i2 = 0;
        while (i2 < treeApps.size()) {
            DefTreeNode node = (DefTreeNode)treeApps.get(i2);
            ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
            boolean isHere = false;
            int j = 0;
            while (j < allApplications.size()) {
                newApplicationInfo = (ApplicationInfo)allApplications.get(j);
                if (newApplicationInfo.applicationName.equals(applicationInfo.applicationName)) {
                    if (newApplicationInfo.destinationsDescriptors == null) break;
                    isHere = true;
                    break;
                }
                ++j;
            }
            if (!isHere) {
                this.removeNode(node);
                continue;
            }
            ++i2;
        }
        treeApps = this.factories.getChilds();
        int i3 = 0;
        while (i3 < treeApps.size()) {
            DefTreeNode node = (DefTreeNode)treeApps.get(i3);
            ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
            int j = 0;
            while (j < allApplications.size()) {
                newApplicationInfo = (ApplicationInfo)allApplications.get(j);
                if (newApplicationInfo.applicationName.equals(applicationInfo.applicationName)) {
                    this.updateComponents(node, newApplicationInfo.factoryDescriptors, jmsLibs);
                    node.setObject(newApplicationInfo);
                    break;
                }
                ++j;
            }
            ++i3;
        }
        treeApps = this.destinations.getChilds();
        int i4 = 0;
        while (i4 < treeApps.size()) {
            DefTreeNode node = (DefTreeNode)treeApps.get(i4);
            ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
            int j = 0;
            while (j < allApplications.size()) {
                ApplicationInfo newApplicationInfo3 = (ApplicationInfo)allApplications.get(j);
                if (newApplicationInfo3.applicationName.equals(applicationInfo.applicationName)) {
                    this.updateComponents(node, newApplicationInfo3.destinationsDescriptors, jmsLibs);
                    node.setObject(newApplicationInfo3);
                    break;
                }
                ++j;
            }
            ++i4;
        }
        treeApps = this.factories.getChilds();
        int j = 0;
        while (j < allApplications.size()) {
            newApplicationInfo2 = (ApplicationInfo)allApplications.get(j);
            boolean isHere = false;
            int i5 = 0;
            while (i5 < treeApps.size()) {
                DefTreeNode node = (DefTreeNode)treeApps.get(i5);
                ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
                if (newApplicationInfo2.applicationName.equals(applicationInfo.applicationName)) {
                    isHere = true;
                    break;
                }
                ++i5;
            }
            if (!isHere && newApplicationInfo2.factoryDescriptors != null) {
                DefTreeNode appNode = new DefTreeNode(newApplicationInfo2, false, 4);
                this.addNode(this.factories, appNode);
                Iterator iterator = ((AbstractList)newApplicationInfo2.factoryDescriptors).iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    this.addNode(appNode, new DefTreeNode(o, true, 5));
                }
            }
            ++j;
        }
        treeApps = this.destinations.getChilds();
        int j2 = 0;
        while (j2 < allApplications.size()) {
            ApplicationInfo newApplicationInfo4 = (ApplicationInfo)allApplications.get(j2);
            boolean isHere = false;
            int i6 = 0;
            while (i6 < treeApps.size()) {
                DefTreeNode node = (DefTreeNode)treeApps.get(i6);
                ApplicationInfo applicationInfo = (ApplicationInfo)node.getObject();
                if (newApplicationInfo4.applicationName.equals(applicationInfo.applicationName)) {
                    isHere = true;
                    break;
                }
                ++i6;
            }
            if (!isHere && newApplicationInfo4.destinationsDescriptors != null) {
                DefTreeNode appNode = new DefTreeNode(newApplicationInfo4, false, 4);
                this.addNode(this.destinations, appNode);
                Iterator iterator = ((AbstractList)newApplicationInfo4.destinationsDescriptors).iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    this.addNode(appNode, new DefTreeNode(o, true, 6));
                }
            }
            ++j2;
        }
    }

    private void updateComponents(DefTreeNode appNode, ArrayList newDescriptors, ArrayList jmsLibs) {
        Object newDescriptor;
        int j;
        ArrayList treeNodes = appNode.getChilds();
        int i = 0;
        while (i < treeNodes.size()) {
            DefTreeNode node = (DefTreeNode)treeNodes.get(i);
            Object descriptor = node.getObject();
            boolean isHere = false;
            j = 0;
            while (j < newDescriptors.size()) {
                newDescriptor = newDescriptors.get(j);
                if (newDescriptor.toString().equals(descriptor.toString())) {
                    isHere = true;
                    break;
                }
                ++j;
            }
            if (!isHere) {
                this.removeNode(node);
                continue;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < treeNodes.size()) {
            DefTreeNode node = (DefTreeNode)treeNodes.get(i2);
            Object descriptor = node.getObject();
            j = 0;
            while (j < newDescriptors.size()) {
                newDescriptor = newDescriptors.get(j);
                if (newDescriptor.toString().equals(descriptor.toString())) {
                    node.setObject(newDescriptor);
                    JComponent panel = node.getPanel();
                    if (panel == null) break;
                    ((ResourcePanel)((Object)panel)).setDescriptor(newDescriptor, jmsLibs);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < newDescriptors.size()) {
            Object newDescriptor2 = newDescriptors.get(i3);
            boolean isHere = false;
            int j2 = 0;
            while (j2 < treeNodes.size()) {
                DefTreeNode node = (DefTreeNode)treeNodes.get(j2);
                Object descriptor = node.getObject();
                if (newDescriptor2.toString().equals(descriptor.toString())) {
                    isHere = true;
                    break;
                }
                ++j2;
            }
            if (!isHere) {
                int type = newDescriptor2 instanceof DestinationDescriptor ? 6 : 5;
                this.addNode(appNode, new DefTreeNode(newDescriptor2, true, type));
            }
            ++i3;
        }
    }

    public void removeNode(DefTreeNode node) {
        DefTreeNode parent = node.getParent();
        int pos = parent.removeChild(node);
        TreeModelEvent event = new TreeModelEvent((Object)this, this.getPath(parent), new int[]{pos}, new Object[]{node});
        this.sendRemoveEvent(event);
    }

    private void addNode(DefTreeNode parent, DefTreeNode node) {
        int pos = parent.addChildSorted(node);
        TreeModelEvent event = new TreeModelEvent((Object)this, this.getPath(parent), new int[]{pos}, new Object[]{node});
        this.sendInsertEvent(event);
    }

    private Object[] getPath(DefTreeNode node) {
        DefTreeNode temp = node;
        int len = 0;
        while (temp != null) {
            temp = temp.getParent();
            ++len;
        }
        temp = node;
        Object[] path = new Object[len];
        while (temp != null) {
            path[--len] = temp;
            temp = temp.getParent();
        }
        return path;
    }

    public void refreshLibraies(Hashtable jmsLibsHash, ArrayList jmsLibs) {
        this.updateLibSubTree(jmsLibsHash);
        this.updateLibComboBoxes(jmsLibs);
    }

    private void updateLibComboBoxes(ArrayList jmsLibs) {
        FactoryTabbedPane panel = (FactoryTabbedPane)this.factories.getPanel();
        if (panel != null) {
            panel.updateLibComboBox(jmsLibs);
        }
        ArrayList apps = this.factories.getChilds();
        int i = 0;
        while (i < apps.size()) {
            DefTreeNode app = (DefTreeNode)apps.get(i);
            panel = (FactoryTabbedPane)app.getPanel();
            if (panel != null) {
                panel.updateLibComboBox(jmsLibs);
            }
            ArrayList factories = app.getChilds();
            int j = 0;
            while (j < factories.size()) {
                panel = (FactoryTabbedPane)((DefTreeNode)factories.get(j)).getPanel();
                if (panel != null) {
                    panel.updateLibComboBox(jmsLibs);
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateLibSubTree(Hashtable jmsLibs) {
        ArrayList childs = this.libraries.getChilds();
        while (childs.size() != 0) {
            this.removeNode((DefTreeNode)childs.get(childs.size() - 1));
        }
        Enumeration en = jmsLibs.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            DefTreeNode libNode = new DefTreeNode(key, false, 7);
            this.addNode(this.libraries, libNode);
            String[] jars = (String[])jmsLibs.get(key);
            int j = 0;
            while (j < jars.length) {
                int ind = jars[j].lastIndexOf(File.separatorChar);
                if (ind != -1) {
                    jars[j] = jars[j].substring(ind + 1);
                }
                this.addNode(libNode, new DefTreeNode(jars[j], true, 8));
                ++j;
            }
        }
    }
}

