/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.jmsconnector.deploy.ApplicationInfo;
import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.deploy.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.deploy.JmsManager;
import com.sap.engine.services.jmsconnector.deploy.XMLParser;
import com.sap.engine.services.jmsconnector.gui.DefTreeNode;
import com.sap.engine.services.jmsconnector.gui.DestinationPanel;
import com.sap.engine.services.jmsconnector.gui.ErrorDialog;
import com.sap.engine.services.jmsconnector.gui.FactoryTabbedPane;
import com.sap.engine.services.jmsconnector.gui.JMSManagementView;
import com.sap.engine.services.jmsconnector.gui.ResourcePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class JMSManagementLogic
extends JMSManagementView
implements VisualRuntimeControl {
    private JmsManager jmsManager;
    private DestinationDescriptor destClipboard;
    private ConnectionFactoryDescriptor facClipboard;
    private ArrayList jmsLibs;

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return this.runtimeButtons;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public void show(ManagementInterface ri) {
        this.jmsManager = (JmsManager)ri;
        this.refresh();
    }

    public void freeResources() {
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() == this.tree) {
            DefTreeNode node;
            DefTreeNode lastNode;
            this.libraryPanel.libTree.removeTreeSelectionListener(this);
            this.libraryPanel.libTree.setSelectionPath(null);
            this.libraryPanel.libTree.addTreeSelectionListener(this);
            final TreePath path = e.getOldLeadSelectionPath();
            if (this.saveBtn.isEnabled() && ((lastNode = (DefTreeNode)path.getLastPathComponent()).getType() == 5 || lastNode.getType() == 6)) {
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to save changes?", "Question", 1);
                if (result == 0) {
                    ApplicationInfo appInfo = (ApplicationInfo)lastNode.getParent().getObject();
                    Object descr = ((ResourcePanel)((Object)lastNode.getPanel())).loadDescriptor();
                    try {
                        this.jmsManager.updateComponent(appInfo, descr);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(this.frame, ex.getMessage(), ex);
                    }
                    this.refresh();
                } else if (result == 1) {
                    ResourcePanel panel = (ResourcePanel)((Object)lastNode.getPanel());
                    panel.resetFields(this.jmsLibs);
                } else {
                    this.tree.removeTreeSelectionListener(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JMSManagementLogic.this.tree.setSelectionPath(path);
                            JMSManagementLogic.this.tree.addTreeSelectionListener(JMSManagementLogic.this);
                        }
                    });
                    return;
                }
            }
            if ((node = (DefTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
                this.disableAllButtons();
                this.setRightPanel(this.emptyPanel);
                return;
            }
            switch (node.getType()) {
                case 0: {
                    this.rootSelected();
                    break;
                }
                case 1: {
                    this.factoriesSelected(node);
                    break;
                }
                case 2: {
                    this.destinationsSelected(node);
                    break;
                }
                case 3: {
                    this.librariesSelected();
                    break;
                }
                case 4: {
                    this.applicationSelected(node);
                    break;
                }
                case 5: {
                    this.factorySelected(node);
                    break;
                }
                case 6: {
                    this.destinationSelected(node);
                    break;
                }
                case 7: {
                    this.librarySelected();
                    break;
                }
                case 8: {
                    this.jarSelected();
                }
            }
        } else if (e.getSource() == this.libraryPanel.libTree) {
            this.disableAllButtons();
            this.tree.removeTreeSelectionListener(this);
            this.tree.setSelectionPath(null);
            this.tree.addTreeSelectionListener(this);
            DefTreeNode node = (DefTreeNode)this.libraryPanel.libTree.getLastSelectedPathComponent();
            this.defineBtn.setEnabled(node != null && node.getType() == 7);
        }
    }

    private void jarSelected() {
        this.disableAllButtons();
        DefTreeNode node = (DefTreeNode)this.libraryPanel.libTree.getLastSelectedPathComponent();
        if (node != null && node.getType() == 7) {
            this.defineBtn.setEnabled(true);
        }
        this.setRightPanel(this.libraryPanel);
    }

    private void librarySelected() {
        this.disableAllButtons();
        this.removeBtn.setEnabled(true);
        this.undefineBtn.setEnabled(true);
        DefTreeNode node = (DefTreeNode)this.libraryPanel.libTree.getLastSelectedPathComponent();
        if (node != null && node.getType() == 7) {
            this.defineBtn.setEnabled(true);
        }
        this.setRightPanel(this.libraryPanel);
    }

    private void destinationSelected(DefTreeNode node) {
        DestinationPanel nodePanel;
        this.disableAllButtons();
        this.copyBtn.setEnabled(true);
        this.exportBtn.setEnabled(true);
        this.removeBtn.setEnabled(true);
        if (this.destClipboard != null) {
            this.pasteBtn.setEnabled(true);
        }
        if ((nodePanel = (DestinationPanel)node.getPanel()) == null) {
            nodePanel = new DestinationPanel(((ApplicationInfo)node.getParent().getObject()).applicationName, (DestinationDescriptor)node.getObject());
            nodePanel.setChangeListener(this);
            node.setPanel(nodePanel);
        }
        this.setRightPanel(nodePanel);
    }

    private void factorySelected(DefTreeNode node) {
        FactoryTabbedPane nodePanel;
        this.disableAllButtons();
        this.copyBtn.setEnabled(true);
        this.exportBtn.setEnabled(true);
        this.removeBtn.setEnabled(true);
        if (this.facClipboard != null) {
            this.pasteBtn.setEnabled(true);
        }
        if ((nodePanel = (FactoryTabbedPane)node.getPanel()) == null) {
            nodePanel = new FactoryTabbedPane(((ApplicationInfo)node.getParent().getObject()).applicationName, (ConnectionFactoryDescriptor)node.getObject(), this.jmsLibs);
            nodePanel.setChangeListener(this);
            node.setPanel(nodePanel);
        }
        this.setRightPanel(nodePanel);
    }

    private void applicationSelected(DefTreeNode node) {
        this.disableAllButtons();
        ApplicationInfo app = (ApplicationInfo)node.getObject();
        if (app.isStandAlone) {
            this.exportBtn.setEnabled(true);
            if (app.status == 1) {
                this.stopBtn.setEnabled(true);
            }
            if (app.status == 0) {
                this.startBtn.setEnabled(true);
            }
            this.removeBtn.setEnabled(true);
        }
        JComponent nodePanel = node.getPanel();
        this.newBtn.setEnabled(true);
        if (nodePanel == null) {
            this.setRightPanel(this.emptyPanel);
        } else {
            this.setRightPanel(nodePanel);
            this.saveBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            if (node.getParent().getType() == 2) {
                if (this.destClipboard != null) {
                    this.pasteBtn.setEnabled(true);
                }
            } else if (this.facClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        }
    }

    private void librariesSelected() {
        this.disableAllButtons();
        this.newBtn.setEnabled(true);
        this.setRightPanel(this.libraryPanel);
        DefTreeNode node = (DefTreeNode)this.libraryPanel.libTree.getLastSelectedPathComponent();
        if (node != null && node.getType() == 7) {
            this.defineBtn.setEnabled(true);
        }
    }

    private void destinationsSelected(DefTreeNode node) {
        this.disableAllButtons();
        JComponent nodePanel = node.getPanel();
        this.newBtn.setEnabled(true);
        if (nodePanel == null) {
            this.setRightPanel(this.emptyPanel);
        } else {
            this.setRightPanel(nodePanel);
            this.saveBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            if (this.destClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        }
    }

    private void factoriesSelected(DefTreeNode node) {
        this.disableAllButtons();
        JComponent nodePanel = node.getPanel();
        this.newBtn.setEnabled(true);
        if (nodePanel == null) {
            this.setRightPanel(this.emptyPanel);
        } else {
            this.setRightPanel(nodePanel);
            this.saveBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            if (this.facClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        }
    }

    private void rootSelected() {
        this.disableAllButtons();
        this.setRightPanel(this.emptyPanel);
    }

    private void setRightPanel(JComponent panel) {
        int i = this.splitPane.getDividerLocation();
        this.splitPane.setRightComponent(panel);
        this.splitPane.setDividerLocation(i);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.importBtn) {
            this.importXML();
            return;
        }
        if (source == this.exportBtn) {
            this.exportXML();
            return;
        }
        if (source == this.refreshBtn) {
            this.disableAllButtons();
            this.refresh();
            return;
        }
        if (source == this.newBtn) {
            this.newApp();
            return;
        }
        if (source == this.removeBtn) {
            this.removeApp();
            return;
        }
        if (source == this.startBtn) {
            this.startApp();
            return;
        }
        if (source == this.stopBtn) {
            this.stopApp();
            return;
        }
        if (source == this.copyBtn) {
            this.copyInClipboard();
            return;
        }
        if (source == this.pasteBtn) {
            this.pasteFromClipboard();
            return;
        }
        if (source == this.saveBtn) {
            this.saveComponent();
            return;
        }
        if (source == this.defineBtn) {
            this.defineLibrary();
            return;
        }
        if (source == this.undefineBtn) {
            this.undefineLibrary();
            return;
        }
    }

    private void undefineLibrary() {
        try {
            this.jmsManager.undefineJmsLibrary(this.tree.getLastSelectedPathComponent().toString());
        }
        catch (Exception e) {
            ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
        }
        this.refresh();
        this.tree.setSelectionPath(this.treeModel.libPath);
    }

    private void defineLibrary() {
        try {
            this.jmsManager.defineJmsLibrary(this.libraryPanel.libTree.getLastSelectedPathComponent().toString());
        }
        catch (Exception e) {
            ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
        }
        this.refresh();
        this.tree.setSelectionPath(this.treeModel.libPath);
    }

    private void saveComponent() {
        DefTreeNode node = (DefTreeNode)this.tree.getLastSelectedPathComponent();
        switch (node.getType()) {
            case 1: 
            case 2: {
                ResourcePanel panel = (ResourcePanel)((Object)node.getPanel());
                try {
                    this.jmsManager.deployComponent(panel.getAppliactionName(), panel.loadDescriptor());
                    node.setPanel(null);
                }
                catch (Exception e) {
                    if (e instanceof WarningException) break;
                    ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
                }
                break;
            }
            case 5: 
            case 6: {
                ApplicationInfo appInfo = (ApplicationInfo)node.getParent().getObject();
                Object descr = ((ResourcePanel)((Object)node.getPanel())).loadDescriptor();
                try {
                    this.jmsManager.updateComponent(appInfo, descr);
                }
                catch (Exception e) {
                    ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
                }
                break;
            }
            case 4: {
                ApplicationInfo appInfo = (ApplicationInfo)node.getObject();
                Object descr = ((ResourcePanel)((Object)node.getPanel())).loadDescriptor();
                try {
                    this.jmsManager.addComponent(appInfo, descr);
                    node.setPanel(null);
                    break;
                }
                catch (Exception e) {
                    ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
                }
            }
        }
        this.disableAllButtons();
        this.refresh();
    }

    private void pasteFromClipboard() {
        JComponent comp = ((DefTreeNode)this.tree.getLastSelectedPathComponent()).getPanel();
        if (comp instanceof FactoryTabbedPane) {
            ((FactoryTabbedPane)comp).saveFields(this.facClipboard, this.jmsLibs);
        } else {
            ((DestinationPanel)comp).saveFields(this.destClipboard);
        }
    }

    private void copyInClipboard() {
        JComponent comp = ((DefTreeNode)this.tree.getLastSelectedPathComponent()).getPanel();
        if (comp instanceof FactoryTabbedPane) {
            this.facClipboard = (ConnectionFactoryDescriptor)((FactoryTabbedPane)comp).loadDescriptor();
        } else {
            this.destClipboard = (DestinationDescriptor)((DestinationPanel)comp).loadDescriptor();
        }
        this.pasteBtn.setEnabled(true);
    }

    private void stopApp() {
        block4: {
            try {
                ApplicationInfo appInfo = (ApplicationInfo)((DefTreeNode)this.tree.getLastSelectedPathComponent()).getObject();
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to stop this application on all servers in cluster?\n(If you choose yes, the application will stop in entire cluster,\nif you choose no it will stop only on this server)", "Question", 1);
                if (result == 0) {
                    this.jmsManager.stopApplication(appInfo.applicationName, true);
                    break block4;
                }
                if (result == 1) {
                    this.jmsManager.stopApplication(appInfo.applicationName, false);
                    break block4;
                }
                return;
            }
            catch (RemoteException e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
        this.refresh();
    }

    private void startApp() {
        block4: {
            try {
                ApplicationInfo appInfo = (ApplicationInfo)((DefTreeNode)this.tree.getLastSelectedPathComponent()).getObject();
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to start this application on all servers in cluster?\n(If you choose yes, the application will start in entire cluster,\nif you choose no it will start only on this server)", "Question", 1);
                if (result == 0) {
                    this.jmsManager.startApplication(appInfo.applicationName, true);
                    break block4;
                }
                if (result == 1) {
                    this.jmsManager.startApplication(appInfo.applicationName, false);
                    break block4;
                }
                return;
            }
            catch (RemoteException e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
        this.refresh();
    }

    private void newApp() {
        DefTreeNode node = (DefTreeNode)this.tree.getLastSelectedPathComponent();
        JComponent panel = null;
        if (node == this.treeModel.factories) {
            panel = new FactoryTabbedPane(this.jmsLibs);
            if (this.facClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        } else if (node.getParent() == this.treeModel.factories) {
            panel = new FactoryTabbedPane(((ApplicationInfo)node.getObject()).applicationName, this.jmsLibs);
            if (this.facClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        } else if (node == this.treeModel.destinations) {
            panel = new DestinationPanel();
            if (this.destClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        } else if (node.getParent() == this.treeModel.destinations) {
            panel = new DestinationPanel(((ApplicationInfo)node.getObject()).applicationName);
            if (this.destClipboard != null) {
                this.pasteBtn.setEnabled(true);
            }
        } else {
            this.deployNewLibrary();
            return;
        }
        node.setPanel(panel);
        this.setRightPanel(panel);
        this.saveBtn.setEnabled(true);
        this.copyBtn.setEnabled(true);
    }

    private void deployNewLibrary() {
        this.fileChooser.setFileFilter(this.jarZipFilter);
        String libName = JOptionPane.showInputDialog(this.frame, (Object)"Enter Library Name");
        if (libName == null) {
            return;
        }
        if ((libName = libName.trim()).length() == 0) {
            return;
        }
        HashSet<File> set = new HashSet<File>();
        this.fileChooser.setDialogTitle("Choose library file 1");
        while (this.fileChooser.showOpenDialog(this.frame) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this.frame, "File " + file.getName() + " not exists.", "Error", 0);
            } else if (!set.add(file)) {
                JOptionPane.showMessageDialog(this.frame, "File " + file.getName() + " is already choosen.", "Error", 0);
            }
            this.fileChooser.setDialogTitle("Choose library file " + (set.size() + 1));
        }
        this.fileChooser.setDialogTitle(null);
        if (JOptionPane.showConfirmDialog(this.frame, "Do you want to deploy library " + libName + " which contains " + set.size() + " files?", "Confirm", 0) != 0) {
            return;
        }
        SerializableFile[] allFiles = new SerializableFile[set.size()];
        int count = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            allFiles[count++] = new SerializableFile((File)iterator.next());
        }
        try {
            this.jmsManager.deployJmsLibrary(libName, allFiles);
            this.jmsManager.defineJmsLibrary(libName);
        }
        catch (Exception e) {
            ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
        }
        this.refresh();
    }

    private void removeApp() {
        DefTreeNode node = (DefTreeNode)this.tree.getLastSelectedPathComponent();
        Object object = node.getObject();
        if (node.getType() == 4) {
            String appName = ((ApplicationInfo)object).applicationName;
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure that you want to remove the application " + appName + " from the cluster?", "Confirm", 0) != 0) {
                return;
            }
            try {
                this.jmsManager.undeployJmsResource(appName);
            }
            catch (RemoteException e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        } else {
            if (node.getType() == 7) {
                if (JOptionPane.showConfirmDialog(this.frame, "Are you sure that you want to undeploy library " + object + " from server?", "Confirm", 0) != 0) {
                    return;
                }
                try {
                    this.jmsManager.undeployJmsLibrary((String)object);
                }
                catch (Exception e) {
                    ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
                }
                this.refresh();
                this.tree.setSelectionPath(this.treeModel.libPath);
                return;
            }
            ApplicationInfo appInfo = (ApplicationInfo)node.getParent().getObject();
            String appName = appInfo.applicationName;
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure that you want to remove the component " + object + " from the application " + appName + "?", "Confirm", 0) != 0) {
                return;
            }
            try {
                this.jmsManager.removeComponent(appInfo, ((ResourcePanel)((Object)node.getPanel())).getDescriptor());
            }
            catch (Exception e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
        this.refresh();
    }

    private void refresh() {
        try {
            ArrayList allApplications = this.jmsManager.getAllApplications();
            Hashtable serverLibs = this.jmsManager.getServerLibraries();
            this.jmsLibs = this.jmsManager.getAllJmsLibraries();
            Hashtable jmsLibsHash = new Hashtable();
            int i = 0;
            while (i < this.jmsLibs.size()) {
                jmsLibsHash.put(this.jmsLibs.get(i), serverLibs.remove(this.jmsLibs.get(i)));
                ++i;
            }
            this.treeModel.refreshApplications(allApplications, this.jmsLibs);
            this.treeModel.refreshLibraies(jmsLibsHash, this.jmsLibs);
            this.libraryPanel.refreshLibraies(serverLibs);
            this.tree.repaint();
            this.valueChanged(new TreeSelectionEvent((Object)this.tree, null, false, null, null));
        }
        catch (Exception e) {
            ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
        }
    }

    private void importXML() {
        this.fileChooser.setFileFilter(this.xmlFilter);
        if (this.fileChooser.showOpenDialog(this.frame) == 0) {
            block3: {
                File file = this.fileChooser.getSelectedFile();
                try {
                    this.jmsManager.deployJmsResource(new SerializableFile(file));
                }
                catch (Exception e) {
                    if (e instanceof WarningException) break block3;
                    ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
                }
            }
            this.refresh();
        }
    }

    private void exportXML() {
        this.fileChooser.setFileFilter(this.xmlFilter);
        if (this.fileChooser.showSaveDialog(this.frame) == 0) {
            String fileName;
            File file = this.fileChooser.getSelectedFile();
            DefTreeNode node = (DefTreeNode)this.tree.getLastSelectedPathComponent();
            if (file.exists()) {
                if (JOptionPane.showConfirmDialog(this.frame, "The file exists. Overwrite?", "Confirm", 0) != 0) {
                    return;
                }
                fileName = file.getAbsolutePath();
            } else {
                fileName = file.getName().indexOf(46) != -1 ? file.getAbsolutePath() : file.getAbsolutePath() + ".xml";
            }
            try {
                if (node.getType() == 4) {
                    ApplicationInfo app = (ApplicationInfo)node.getObject();
                    if (node.getParent() == this.treeModel.factories) {
                        XMLParser.generatePublicFactoryXML(app.applicationName, app.factoryDescriptors, fileName);
                    } else {
                        XMLParser.generatePublicDestinationXML(app.applicationName, app.destinationsDescriptors, fileName);
                    }
                } else {
                    ApplicationInfo app = (ApplicationInfo)node.getParent().getObject();
                    ArrayList<Object> descr = new ArrayList<Object>();
                    descr.add(node.getObject());
                    if (node.getParent().getParent() == this.treeModel.factories) {
                        XMLParser.generatePublicFactoryXML(app.applicationName, descr, fileName);
                    } else {
                        XMLParser.generatePublicDestinationXML(app.applicationName, descr, fileName);
                    }
                }
            }
            catch (Exception e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("StandAlone");
        JMSManagementLogic panel = new JMSManagementLogic();
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.destinationsDescriptors = new ArrayList();
        applicationInfo.isStandAlone = true;
        applicationInfo.applicationName = "kaval";
        applicationInfo.status = 1;
        applicationInfo.destinationsDescriptors.add(new DestinationDescriptor("Chuk", "Facotry", "user", "pass", "descr"));
        panel.treeModel.addApplication(applicationInfo);
        applicationInfo = new ApplicationInfo();
        applicationInfo.factoryDescriptors = new ArrayList();
        applicationInfo.isStandAlone = true;
        applicationInfo.applicationName = "ianko";
        ConnectionFactoryDescriptor descr = new ConnectionFactoryDescriptor();
        descr.setFactoryName("MyFavouriteFactory");
        applicationInfo.factoryDescriptors.add(descr);
        descr = new ConnectionFactoryDescriptor();
        descr.setFactoryName("zMyFavouriteFactory");
        applicationInfo.factoryDescriptors.add(descr);
        descr = new ConnectionFactoryDescriptor();
        descr.setFactoryName("aMyFavouriteFactory");
        applicationInfo.factoryDescriptors.add(descr);
        panel.treeModel.addApplication(applicationInfo);
        applicationInfo = new ApplicationInfo();
        applicationInfo.factoryDescriptors = new ArrayList();
        applicationInfo.destinationsDescriptors = new ArrayList();
        applicationInfo.isStandAlone = false;
        applicationInfo.applicationName = "mdb";
        applicationInfo.status = 1;
        descr = new ConnectionFactoryDescriptor();
        descr.setFactoryName("Case2QueueFactory");
        applicationInfo.factoryDescriptors.add(descr);
        applicationInfo.destinationsDescriptors.add(new DestinationDescriptor("jaz", "Facotry", "user", "pass", "descr"));
        applicationInfo.destinationsDescriptors.add(new DestinationDescriptor("zjaz", "Facotry", "user", "pass", "descr"));
        applicationInfo.destinationsDescriptors.add(new DestinationDescriptor("ajaz", "Facotry", "user", "pass", "descr"));
        panel.treeModel.addApplication(applicationInfo);
        JFrame toolframe = new JFrame();
        JButton[] buts = panel.getRuntimeButtons();
        Container con = toolframe.getContentPane();
        con.setLayout(new FlowLayout());
        int i = 0;
        while (i < buts.length) {
            con.add(buts[i]);
            ++i;
        }
        ((Component)toolframe).setLocation(100, 10);
        toolframe.pack();
        toolframe.show();
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Close");
                System.exit(666);
            }
        });
        ((Component)frame).setLocation(100, 100);
        ((Component)frame).setSize(630, 450);
        frame.getContentPane().add(panel);
        panel.setFrame(frame);
        frame.show();
    }

    public void stateChanged(ChangeEvent e) {
        this.saveBtn.setEnabled(((ResourcePanel)e.getSource()).isChanged());
    }
}

