/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.gui.Constants;
import com.sap.engine.services.jmsconnector.gui.FactoryPanelContext;
import com.sap.engine.services.jmsconnector.gui.FactoryPanelGeneral;
import com.sap.engine.services.jmsconnector.gui.FactoryPanelObjectFactory;
import com.sap.engine.services.jmsconnector.gui.ResourcePanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FactoryTabbedPane
extends JTabbedPane
implements Constants,
ItemListener,
DocumentListener,
ChangeListener,
ResourcePanel {
    private FactoryPanelGeneral factoryPanelGeneral = new FactoryPanelGeneral();
    private FactoryPanelContext factoryPanelContext = new FactoryPanelContext();
    private FactoryPanelObjectFactory factoryPanelObjectFactory = new FactoryPanelObjectFactory();
    private ConnectionFactoryDescriptor descr;
    private ChangeListener listener;
    private boolean isChanging;

    public FactoryTabbedPane(ArrayList jmsLibs) {
        this.add((Component)this.factoryPanelGeneral, "General");
        this.add((Component)new JPanel(), "Provider");
        this.setEnabledAt(1, false);
        this.factoryPanelGeneral.factoryNameField.getDocument().addDocumentListener(this);
        this.factoryPanelGeneral.factoryClientIdField.getDocument().addDocumentListener(this);
        this.factoryPanelGeneral.factoryUserField.getDocument().addDocumentListener(this);
        this.factoryPanelGeneral.factoryPassField.getDocument().addDocumentListener(this);
        this.factoryPanelGeneral.factoryDescriptionField.getDocument().addDocumentListener(this);
        this.factoryPanelGeneral.factoryProviderTypeCombo.addItemListener(this);
        this.factoryPanelGeneral.factoryLibraryCombo.addItemListener(this);
        this.factoryPanelGeneral.factoryAliasesPanel.setChangeListener(this);
        this.factoryPanelContext.linkFactoryName.getDocument().addDocumentListener(this);
        this.factoryPanelContext.initContFactory.getDocument().addDocumentListener(this);
        this.factoryPanelContext.providerURL.getDocument().addDocumentListener(this);
        this.factoryPanelContext.securityPrincipal.getDocument().addDocumentListener(this);
        this.factoryPanelContext.securityCredentials.getDocument().addDocumentListener(this);
        this.factoryPanelContext.additionalProperties.setChangeListener(this);
        this.factoryPanelObjectFactory.objectFactoryName.getDocument().addDocumentListener(this);
        this.factoryPanelObjectFactory.className.getDocument().addDocumentListener(this);
        this.factoryPanelObjectFactory.propertiesEditor.setChangeListener(this);
        this.saveFields(new ConnectionFactoryDescriptor(), jmsLibs);
    }

    public FactoryTabbedPane(String appName, ConnectionFactoryDescriptor descr, ArrayList jmsLibs) {
        this(jmsLibs);
        this.setDescriptor(descr, jmsLibs);
        this.factoryPanelGeneral.applicationNameField.setText(appName);
        this.factoryPanelGeneral.applicationNameField.setEditable(false);
        this.factoryPanelGeneral.factoryNameField.setText(descr.getFactoryName());
        this.factoryPanelGeneral.factoryNameField.setEditable(false);
    }

    public FactoryTabbedPane(String appName, ArrayList jmsLibs) {
        this(jmsLibs);
        this.factoryPanelGeneral.applicationNameField.setText(appName);
        this.factoryPanelGeneral.applicationNameField.setEditable(false);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.factoryPanelGeneral.factoryProviderTypeCombo) {
            if (e.getStateChange() == 1) {
                this.setEnabledAt(1, true);
                if (e.getItem().equals(Constants.PROVIDER_TYPES[0])) {
                    this.setComponentAt(1, this.factoryPanelContext);
                } else {
                    this.setComponentAt(1, this.factoryPanelObjectFactory);
                }
            } else {
                this.setEnabledAt(1, false);
            }
        }
        this.dataChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void stateChanged(ChangeEvent e) {
        this.dataChanged();
    }

    private void dataChanged() {
        if (this.listener != null && !this.isChanging) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean isChanged() {
        return !this.descr.equals(this.loadDescriptor());
    }

    public Object loadDescriptor() {
        ConnectionFactoryDescriptor descr = new ConnectionFactoryDescriptor();
        if (!this.factoryPanelGeneral.loadDescriptor(descr)) {
            return descr;
        }
        if (descr.hasNaming()) {
            this.factoryPanelContext.loadDescriptor(descr);
        } else {
            this.factoryPanelObjectFactory.loadDescriptor(descr);
        }
        return descr;
    }

    public Object getDescriptor() {
        return this.descr;
    }

    public void setDescriptor(Object descr, ArrayList jmsLibs) {
        this.descr = (ConnectionFactoryDescriptor)descr;
        this.isChanging = true;
        this.factoryPanelGeneral.setFileds(this.descr, jmsLibs);
        if (this.descr.hasNaming()) {
            this.factoryPanelContext.setFileds(this.descr);
        } else {
            this.factoryPanelObjectFactory.setFileds(this.descr);
        }
        this.isChanging = false;
    }

    public void saveFields(ConnectionFactoryDescriptor descr, ArrayList jmsLibs) {
        this.isChanging = true;
        this.factoryPanelGeneral.setFileds(descr, jmsLibs);
        if (descr.hasNaming()) {
            this.factoryPanelContext.setFileds(descr);
        } else {
            this.factoryPanelObjectFactory.setFileds(descr);
        }
        this.isChanging = false;
        this.dataChanged();
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public String getAppliactionName() {
        return this.factoryPanelGeneral.applicationNameField.getText().trim();
    }

    public void resetFields(ArrayList jmsLibs) {
        this.saveFields(this.descr, jmsLibs);
    }

    public void updateLibComboBox(ArrayList jmsLibs) {
        JComboBox combo = this.factoryPanelGeneral.factoryLibraryCombo;
        Object selected = combo.getSelectedItem();
        combo.removeAllItems();
        ArrayList all = (ArrayList)jmsLibs.clone();
        all.add("");
        if (selected != null && !all.contains(selected)) {
            all.add(selected);
        }
        Collections.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
        });
        int i = 0;
        while (i < all.size()) {
            combo.addItem(all.get(i));
            ++i;
        }
        combo.setSelectedItem(selected);
    }
}

