/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.gui.Constants;
import com.sap.engine.services.jmsconnector.gui.SimpleListPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class FactoryPanelGeneral
extends JPanel
implements Constants {
    protected JTextField applicationNameField;
    protected JTextField factoryNameField;
    protected JTextField factoryClientIdField;
    protected JTextField factoryUserField;
    protected JPasswordField factoryPassField;
    protected JTextField factoryDescriptionField;
    protected JTextField factoryTypeField;
    protected JComboBox factoryProviderTypeCombo;
    protected JComboBox factoryLibraryCombo;
    protected SimpleListPanel factoryAliasesPanel;

    public FactoryPanelGeneral() {
        this.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.setLayout(new GridBagLayout());
        this.applicationNameField = new JTextField();
        this.add((Component)new JLabel("Application Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.applicationNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryNameField = new JTextField();
        this.add((Component)new JLabel("Factory Name:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryClientIdField = new JTextField();
        this.add((Component)new JLabel("Client ID:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryClientIdField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryUserField = new JTextField();
        this.add((Component)new JLabel("User:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryUserField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryPassField = new JPasswordField();
        this.add((Component)new JLabel("Password:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryPassField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryDescriptionField = new JTextField();
        this.add((Component)new JLabel("Description:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryDescriptionField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryTypeField = new JTextField();
        this.factoryTypeField.setEditable(false);
        this.add((Component)new JLabel("Factory Type:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryTypeField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryProviderTypeCombo = new JComboBox<String>(Constants.PROVIDER_TYPES);
        this.factoryProviderTypeCombo.setSelectedIndex(-1);
        this.add((Component)new JLabel("Provider Type:"), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryProviderTypeCombo, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryLibraryCombo = new JComboBox();
        this.factoryLibraryCombo.addItem("");
        this.add((Component)new JLabel("Library:"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryLibraryCombo, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryAliasesPanel = new SimpleListPanel("", "Enter alias:", "Edit alias:");
        this.factoryAliasesPanel.setBorder(BorderFactory.createTitledBorder("Aliases"));
        this.add((Component)this.factoryAliasesPanel, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void setFileds(ConnectionFactoryDescriptor descr, ArrayList jmsLibs) {
        this.factoryClientIdField.setText(descr.getClientID());
        this.factoryUserField.setText(descr.getUserName());
        ((JTextComponent)this.factoryPassField).setText(descr.getPassword());
        this.factoryDescriptionField.setText(descr.getDescription());
        this.factoryTypeField.setText(descr.getFactoryTypeString());
        this.initLibComboBox(descr.getLibraryName(), jmsLibs);
        if (descr.hasNaming()) {
            this.factoryProviderTypeCombo.setSelectedIndex(0);
        } else {
            this.factoryProviderTypeCombo.setSelectedIndex(1);
        }
        this.factoryAliasesPanel.initList(descr.getAliases());
    }

    private void initLibComboBox(String libraryName, ArrayList jmsLibs) {
        jmsLibs = (ArrayList)jmsLibs.clone();
        this.factoryLibraryCombo.removeAllItems();
        jmsLibs.add("");
        if (!jmsLibs.contains(libraryName)) {
            jmsLibs.add(libraryName);
        }
        Collections.sort(jmsLibs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
        });
        int i = 0;
        while (i < jmsLibs.size()) {
            this.factoryLibraryCombo.addItem(jmsLibs.get(i));
            ++i;
        }
        this.factoryLibraryCombo.setSelectedItem(libraryName);
    }

    public static void main(String[] args) {
        System.out.println("StandAloneFactoryPanelGeneral");
        FactoryPanelGeneral panel = new FactoryPanelGeneral();
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Close");
                System.exit(0);
            }
        });
        ((Component)frame).setLocation(100, 100);
        ((Component)frame).setSize(630, 450);
        frame.getContentPane().add(panel);
        frame.show();
    }

    public boolean loadDescriptor(ConnectionFactoryDescriptor descr) {
        descr.setFactoryName(this.factoryNameField.getText().trim());
        descr.setClientID(this.factoryClientIdField.getText().trim());
        descr.setUserName(this.factoryUserField.getText().trim());
        descr.setPassword(this.factoryPassField.getText().trim());
        descr.setDescription(this.factoryDescriptionField.getText().trim());
        descr.setAliases(this.factoryAliasesPanel.getListDataArray());
        String lib = (String)this.factoryLibraryCombo.getSelectedItem();
        if (lib == null) {
            lib = "";
        }
        descr.setLibraryName(lib);
        int provider = this.factoryProviderTypeCombo.getSelectedIndex();
        if (provider == -1) {
            return false;
        }
        descr.setNaming(provider == 0);
        return true;
    }
}

