/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.gui.PropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class FactoryPanelContext
extends JPanel {
    protected JTextField linkFactoryName;
    protected JTextField initContFactory;
    protected JTextField providerURL;
    protected JTextField securityPrincipal;
    protected JPasswordField securityCredentials;
    protected PropertyEditor additionalProperties;

    public FactoryPanelContext() {
        this.setBorder(BorderFactory.createTitledBorder("JNDI Settings"));
        this.setLayout(new GridBagLayout());
        JPanel propsPanel = new JPanel();
        propsPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        propsPanel.setLayout(new GridBagLayout());
        this.linkFactoryName = new JTextField();
        this.add((Component)new JLabel("JNDI Path:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.linkFactoryName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.initContFactory = new JTextField();
        propsPanel.add((Component)new JLabel("Initial Context Factory:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        propsPanel.add((Component)this.initContFactory, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.providerURL = new JTextField();
        propsPanel.add((Component)new JLabel("Provider URL:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        propsPanel.add((Component)this.providerURL, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.securityPrincipal = new JTextField();
        propsPanel.add((Component)new JLabel("Security Principal:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        propsPanel.add((Component)this.securityPrincipal, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.securityCredentials = new JPasswordField();
        propsPanel.add((Component)new JLabel("Security Credentials:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        propsPanel.add((Component)this.securityCredentials, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("Additional"));
        this.additionalProperties = new PropertyEditor("Property", "Value");
        result.add(this.additionalProperties);
        propsPanel.add((Component)result, new GridBagConstraints(0, 4, 2, 1, 0.1, 0.1, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)propsPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public static void main(String[] args) {
        System.out.println("StandAloneFactoryPanelContext");
        FactoryPanelContext panel = new FactoryPanelContext();
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Close");
                System.exit(0);
            }
        });
        ((Component)frame).setLocation(100, 100);
        ((Component)frame).setSize(630, 450);
        frame.getContentPane().add(panel);
        frame.show();
    }

    public void setFileds(ConnectionFactoryDescriptor descr) {
        Properties additional = (Properties)((Hashtable)descr.getContextProperties()).clone();
        this.linkFactoryName.setText(descr.getLinkFactoryName());
        this.initContFactory.setText((String)((Hashtable)additional).remove("java.naming.factory.initial"));
        this.providerURL.setText((String)((Hashtable)additional).remove("java.naming.provider.url"));
        this.securityPrincipal.setText((String)((Hashtable)additional).remove("java.naming.security.principal"));
        ((JTextComponent)this.securityCredentials).setText((String)((Hashtable)additional).remove("java.naming.security.credentials"));
        this.additionalProperties.initProperties(additional);
    }

    public void loadDescriptor(ConnectionFactoryDescriptor descr) {
        Properties props = this.additionalProperties.getProps();
        props.setProperty("java.naming.factory.initial", this.initContFactory.getText().trim());
        props.setProperty("java.naming.provider.url", this.providerURL.getText().trim());
        props.setProperty("java.naming.security.principal", this.securityPrincipal.getText().trim());
        props.setProperty("java.naming.security.credentials", this.securityCredentials.getText().trim());
        descr.setLinkFactoryName(this.linkFactoryName.getText().trim());
        descr.setContextProperties(props);
    }
}

