/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import com.sap.engine.services.jmsconnector.deploy.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.gui.ResourcePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class DestinationPanel
extends JPanel
implements ResourcePanel,
DocumentListener {
    private JTextField applicationNameField;
    private JTextField factoryNameField;
    private JTextField destinationNameField;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private JTextField descriptionField;
    private DestinationDescriptor descr;
    private ChangeListener listener;
    private boolean isChanging;

    public DestinationPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.setLayout(new GridBagLayout());
        this.applicationNameField = new JTextField();
        this.add((Component)new JLabel("Application Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.applicationNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.destinationNameField = new JTextField();
        this.destinationNameField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Destination Name:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.destinationNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryNameField = new JTextField();
        this.factoryNameField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Factory Name:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.factoryNameField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.descriptionField = new JTextField();
        this.descriptionField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Description:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.descriptionField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.userNameField = new JTextField();
        this.userNameField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("User:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.userNameField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.passwordField = new JPasswordField();
        this.passwordField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("Password:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.passwordField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public DestinationPanel(String appName, DestinationDescriptor descr) {
        this();
        this.applicationNameField.setEditable(false);
        this.applicationNameField.setText(appName);
        this.destinationNameField.setEditable(false);
        this.destinationNameField.setText(descr.getDestinationName());
        this.setDescriptor(descr, null);
    }

    public DestinationPanel(String appName) {
        this();
        this.applicationNameField.setEditable(false);
        this.applicationNameField.setText(appName);
    }

    public Object loadDescriptor() {
        DestinationDescriptor descr = new DestinationDescriptor();
        descr.setConnectionFactory(this.factoryNameField.getText().trim());
        descr.setDestinationName(this.destinationNameField.getText().trim());
        descr.setDescription(this.descriptionField.getText().trim());
        descr.setUserName(this.userNameField.getText().trim());
        descr.setPassword(this.passwordField.getText().trim());
        return descr;
    }

    public Object getDescriptor() {
        return this.descr;
    }

    public void setDescriptor(Object descr, ArrayList list) {
        this.descr = (DestinationDescriptor)descr;
        this.isChanging = true;
        this.factoryNameField.setText(this.descr.getConnectionFactory());
        this.descriptionField.setText(this.descr.getDescription());
        this.userNameField.setText(this.descr.getUserName());
        ((JTextComponent)this.passwordField).setText(this.descr.getPassword());
        this.isChanging = false;
    }

    public void saveFields(DestinationDescriptor descr) {
        this.isChanging = true;
        this.factoryNameField.setText(descr.getConnectionFactory());
        this.descriptionField.setText(descr.getDescription());
        this.userNameField.setText(descr.getUserName());
        ((JTextComponent)this.passwordField).setText(descr.getPassword());
        this.isChanging = false;
        this.dataChanged();
    }

    public boolean isChanged() {
        return !this.descr.equals(this.loadDescriptor());
    }

    public void insertUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    private void dataChanged() {
        if (this.listener != null && !this.isChanging) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public String getAppliactionName() {
        return this.applicationNameField.getText().trim();
    }

    public void resetFields(ArrayList list) {
        this.saveFields(this.descr);
    }
}

