/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.gui;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;

public class DefTreeNode
implements Comparable {
    public static final int ROOT = 0;
    public static final int FACTORIES = 1;
    public static final int DESTINATIONS = 2;
    public static final int LIBRARIES = 3;
    public static final int APPLICATION = 4;
    public static final int FACTORY = 5;
    public static final int DESTINATION = 6;
    public static final int LIBRARY = 7;
    public static final int JAR = 8;
    private ArrayList childs;
    private Object object;
    private boolean isLeaf;
    private int type;
    private JComponent panel;
    private DefTreeNode parent;

    protected DefTreeNode(Object object, boolean isLeaf, int type) {
        this.object = object;
        this.isLeaf = isLeaf;
        this.type = type;
        this.childs = new ArrayList();
    }

    public Object getChild(int index) {
        return this.childs.get(index);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public int getIndexOfChild(Object child) {
        return this.childs.indexOf(child);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public String toString() {
        return this.object.toString();
    }

    public void addChild(DefTreeNode child) {
        child.setParent(this);
        this.childs.add(child);
    }

    public int addChildSorted(DefTreeNode child) {
        child.setParent(this);
        int index = Collections.binarySearch(this.childs, child);
        if (index < 0) {
            index = -index - 1;
        }
        this.childs.add(index, child);
        return index;
    }

    public DefTreeNode getParent() {
        return this.parent;
    }

    private void setParent(DefTreeNode defTreeNode) {
        this.parent = defTreeNode;
    }

    public int getType() {
        return this.type;
    }

    public Object getObject() {
        return this.object;
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public void setPanel(JComponent panel) {
        this.panel = panel;
    }

    public int compareTo(Object o) {
        return this.object.toString().compareToIgnoreCase(((DefTreeNode)o).object.toString());
    }

    public int removeChild(DefTreeNode node) {
        int res = this.childs.indexOf(node);
        ((AbstractCollection)this.childs).remove(node);
        return res;
    }

    public ArrayList getChilds() {
        return this.childs;
    }

    public void setObject(Object object) {
        this.object = object;
    }
}

