/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.jmsconnector.descriptor.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.gui.JMSFactoriesPanel;
import com.sap.engine.services.jmsconnector.descriptor.gui.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class JMSFactoriesPanelLogical
extends JMSFactoriesPanel {
    protected HashMap factories = new HashMap();
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    private boolean performingShow = false;

    public JMSFactoriesPanelLogical(Frame frame, int madeFromConstant) {
        this.setFrame(frame);
        this.init(madeFromConstant);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.aliasesPanel.setFrame(frame);
    }

    public void setFactories(ConnectionFactoryDescriptor[] facts) {
        this.factories = new HashMap();
        this.factoriesModel.clear();
        this.clearFields();
        this.lastSelected = -1;
        if (facts != null) {
            int i = 0;
            while (i < facts.length) {
                if (facts[i] != null && facts[i].getFactoryName() != null && !facts[i].getFactoryName().equals("")) {
                    this.factories.put(facts[i].getFactoryName(), facts[i]);
                    this.factoriesModel.add(new ListValues(facts[i], 1));
                }
                ++i;
            }
        }
    }

    public ConnectionFactoryDescriptor[] getFactories() {
        if (this.factories == null || this.factories.isEmpty()) {
            return null;
        }
        Collection all = this.factories.values();
        return all.toArray(new ConnectionFactoryDescriptor[0]);
    }

    public void setDescriptor(JMSConnectorDescriptor jms) {
        ConnectionFactoryDescriptor[] descriptors = null;
        if (jms != null) {
            descriptors = jms.getFactories();
        }
        this.setFactories(descriptors);
    }

    public JMSConnectorDescriptor getDescriptor() {
        JMSConnectorDescriptor jms = new JMSConnectorDescriptor();
        jms.setFactories(this.getFactories());
        return jms;
    }

    private ConnectionFactoryDescriptor loadDescriptor() {
        ConnectionFactoryDescriptor descr = new ConnectionFactoryDescriptor();
        descr.setFactoryName(this.nameField.getText().trim());
        descr.setClientID(this.clientIdField.getText().trim());
        descr.setUserName(this.userField.getText().trim());
        descr.setPassword(this.passField.getText().trim());
        descr.setDescription(this.descriptionField.getText().trim());
        descr.setAliases(this.aliasesPanel.getListDataArray());
        descr.setLibraryName(((JTextField)this.libraryBox.getEditor().getEditorComponent()).getText().trim());
        int provider = this.providerType.getSelectedIndex();
        if (provider == -1) {
            return null;
        }
        if (provider == 0) {
            descr.setNaming(true);
            descr.setLinkFactoryName(this.linkFactoryName.getText().trim());
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", this.initContFactory.getText().trim());
            props.setProperty("java.naming.provider.url", this.providerURL.getText().trim());
            props.setProperty("java.naming.security.principal", this.securityPrincipal.getText().trim());
            props.setProperty("java.naming.security.credentials", this.securityCredentials.getText().trim());
            ((Hashtable)props).putAll(this.additionalProperties.getProps());
            descr.setContextProperties(props);
        } else {
            descr.setNaming(false);
            descr.setObjectFactoryName(this.objectFactoryName.getText().trim());
            descr.setClassName(this.className.getText().trim());
            descr.setCreateFactoryProperties(this.propertiesEditor.getProps());
        }
        if (this.pooledRadio.isSelected()) {
            descr.setMode(1);
            descr.setExpireTimeout(this.expireField.getValue());
            descr.setMinConnections(this.minConField.getValue());
            descr.setMaxConnections(this.maxConField.getValue());
            descr.setTimeToWait(this.timeField.getValue());
        } else if (this.sharedRadio.isSelected()) {
            descr.setMode(2);
            descr.setExpireTimeout(this.expireField.getValue());
        } else {
            descr.setMode(0);
        }
        return descr;
    }

    protected void addFactory() {
        ConnectionFactoryDescriptor descr = this.loadDescriptor();
        if (descr == null) {
            JOptionPane.showMessageDialog(this.frame, "Please select JMS provider type.", "Error", 0);
            return;
        }
        this.factoriesModel.add(new ListValues(descr, 1));
        this.factories.put(descr.getFactoryName(), descr);
    }

    protected void removeFactory() {
        this.factories.remove(((ListValues)this.factoriesList.getSelectedValue()).getName());
        this.factoriesModel.remove(this.factoriesList.getSelectedIndex());
    }

    private void changeFactory() {
        ConnectionFactoryDescriptor descr = this.loadDescriptor();
        if (descr == null) {
            JOptionPane.showMessageDialog(this.frame, "Please select JMS provider type.", "Error", 0);
            return;
        }
        ((ListValues)this.factoriesList.getSelectedValue()).setFactory(descr);
        this.factories.put(descr.getFactoryName(), descr);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addFacBtn) {
            this.addFactory();
            this.factoriesList.clearSelection();
            this.clearFields();
            return;
        }
        if (source == this.removeFacBtn) {
            this.removeFactory();
            this.clearFields();
            return;
        }
        if (source == this.changeFacBtn) {
            this.changeFactory();
            this.factoriesList.clearSelection();
            this.clearFields();
            return;
        }
        if (source == this.clearBtn) {
            this.factoriesList.clearSelection();
            this.clearFields();
            return;
        }
        if (source == this.pooledRadio) {
            this.expireField.setEnabled(true);
            this.minConField.setEnabled(true);
            this.maxConField.setEnabled(true);
            this.timeField.setEnabled(true);
            this.dataChanged();
            return;
        }
        if (source == this.sharedRadio) {
            this.expireField.setEnabled(true);
            this.minConField.setEnabled(false);
            this.maxConField.setEnabled(false);
            this.timeField.setEnabled(false);
            this.minConField.setValue(0);
            this.maxConField.setValue(0);
            this.timeField.setValue(0);
            this.dataChanged();
            return;
        }
        if (source == this.noneRadio) {
            this.expireField.setEnabled(false);
            this.minConField.setEnabled(false);
            this.maxConField.setEnabled(false);
            this.timeField.setEnabled(false);
            this.expireField.setValue(0);
            this.minConField.setValue(0);
            this.maxConField.setValue(0);
            this.timeField.setValue(0);
            this.dataChanged();
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        this.dataChanged();
    }

    private void showFactory(ListValues fact) {
        if (fact == null || fact.getFactory() == null || fact.getFactory().getFactoryName() == null || fact.getFactory().getFactoryName().equals("")) {
            return;
        }
        this.performingShow = true;
        ConnectionFactoryDescriptor descr = fact.getFactory();
        this.nameField.setText(descr.getFactoryName());
        this.clientIdField.setText(descr.getClientID());
        this.userField.setText(descr.getUserName());
        ((JTextComponent)this.passField).setText(descr.getPassword());
        this.aliasesPanel.initList(descr.getAliases());
        this.descriptionField.setText(descr.getDescription());
        ((JTextField)this.libraryBox.getEditor().getEditorComponent()).setText(descr.getLibraryName());
        if (descr.hasNaming()) {
            this.providerType.setSelectedIndex(0);
            Properties props = descr.getContextProperties();
            this.linkFactoryName.setText(descr.getLinkFactoryName());
            this.initContFactory.setText(props.getProperty("java.naming.factory.initial"));
            this.providerURL.setText(props.getProperty("java.naming.provider.url"));
            this.securityPrincipal.setText(props.getProperty("java.naming.security.principal"));
            ((JTextComponent)this.securityCredentials).setText(props.getProperty("java.naming.security.credentials"));
            Properties tempProps = new Properties();
            ((Hashtable)tempProps).putAll(props);
            ((Hashtable)tempProps).remove("java.naming.factory.initial");
            ((Hashtable)tempProps).remove("java.naming.provider.url");
            ((Hashtable)tempProps).remove("java.naming.security.principal");
            ((Hashtable)tempProps).remove("java.naming.security.credentials");
            if (!((Hashtable)tempProps).isEmpty()) {
                this.additionalProperties.initProperties(tempProps);
            }
        } else {
            this.providerType.setSelectedIndex(1);
            this.objectFactoryName.setText(descr.getObjectFactoryName());
            this.className.setText(descr.getClassName());
            this.propertiesEditor.initProperties(descr.getCreateFactoryProperties());
        }
        if (descr.getMode() == 1) {
            this.pooledRadio.setSelected(true);
            this.expireField.setEnabled(true);
            this.minConField.setEnabled(true);
            this.maxConField.setEnabled(true);
            this.timeField.setEnabled(true);
            this.expireField.setValue((int)descr.getExpireTimeout());
            this.minConField.setValue(descr.getMinConnections());
            this.maxConField.setValue(descr.getMaxConnections());
            this.timeField.setValue(descr.getTimeToWait());
        } else if (descr.getMode() == 2) {
            this.sharedRadio.setSelected(true);
            this.expireField.setEnabled(true);
            this.expireField.setValue((int)descr.getExpireTimeout());
        } else {
            this.noneRadio.setSelected(true);
        }
        this.performingShow = false;
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        int selected = -1;
        if (this.factoriesModel.size() != 0) {
            this.clearFields();
            this.addFacBtn.setEnabled(false);
            this.changeFacBtn.setEnabled(false);
            this.removeFacBtn.setEnabled(false);
            this.clearBtn.setEnabled(false);
            if (!this.factoriesList.isSelectionEmpty()) {
                selected = this.factoriesList.getSelectedIndex();
                this.showFactory((ListValues)this.factoriesModel.get(selected));
                this.removeFacBtn.setEnabled(true);
            }
            this.lastSelected = selected;
        }
    }

    public void nameChanged() {
        String name = this.nameField.getText().trim();
        if (name.length() == 0) {
            this.addFacBtn.setEnabled(false);
            return;
        }
        if (this.factories.get(name) != null) {
            this.addFacBtn.setEnabled(false);
            this.dataChanged();
        } else {
            this.addFacBtn.setEnabled(true);
        }
        this.clearBtn.setEnabled(true);
    }

    public void dataChanged() {
        if (this.performingShow) {
            return;
        }
        String name = this.nameField.getText().trim();
        ConnectionFactoryDescriptor descr = (ConnectionFactoryDescriptor)this.factories.get(name);
        if (this.nameField.getText().trim().equals("") && this.clientIdField.getText().trim().equals("") && this.userField.getText().trim().equals("") && this.passField.getText().trim().equals("") && this.descriptionField.getText().trim().equals("") && this.providerType.getSelectedIndex() == -1 && this.linkFactoryName.getText().trim().equals("") && this.initContFactory.getText().trim().equals("") && this.providerURL.getText().trim().equals("") && this.securityPrincipal.getText().trim().equals("") && this.securityCredentials.getText().trim().equals("") && ((Hashtable)this.additionalProperties.getProps()).isEmpty() && this.objectFactoryName.getText().trim().equals("") && this.className.getText().trim().equals("") && ((Hashtable)this.propertiesEditor.getProps()).isEmpty() && this.aliasesPanel.getListData().isEmpty() && ((JTextField)this.libraryBox.getEditor().getEditorComponent()).getText().trim().equals("") && this.noneRadio.isSelected() && this.expireField.getValue() == 0 && this.minConField.getValue() == 0 && this.maxConField.getValue() == 0 && this.timeField.getValue() == 0 && this.factoriesList.isSelectionEmpty()) {
            this.clearBtn.setEnabled(false);
        } else {
            this.clearBtn.setEnabled(true);
        }
        if (descr == null) {
            this.changeFacBtn.setEnabled(false);
            return;
        }
        ConnectionFactoryDescriptor temp = this.loadDescriptor();
        if (descr.equals(temp)) {
            this.changeFacBtn.setEnabled(false);
        } else {
            this.changeFacBtn.setEnabled(true);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.dataChanged();
    }

    public void changedUpdate(DocumentEvent de) {
        if (de.getDocument() == this.nameField.getDocument()) {
            this.nameChanged();
        } else {
            this.dataChanged();
        }
    }

    public void insertUpdate(DocumentEvent de) {
        if (de.getDocument() == this.nameField.getDocument()) {
            this.nameChanged();
        } else {
            this.dataChanged();
        }
    }

    public void removeUpdate(DocumentEvent de) {
        if (de.getDocument() == this.nameField.getDocument()) {
            this.nameChanged();
        } else {
            this.dataChanged();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.providerType) {
            if (ie.getStateChange() == 1) {
                this.tabPane.setEnabledAt(1, true);
                if (ie.getItem().equals(JMSFactoriesPanel.PROVIDER_TYPES[0])) {
                    this.objectFactoryName.setText("");
                    this.className.setText("");
                    this.propertiesEditor.initProperties(new Properties());
                    this.tabPane.setComponentAt(1, this.providerContPanel);
                } else {
                    this.linkFactoryName.setText("");
                    this.initContFactory.setText("");
                    this.providerURL.setText("");
                    this.securityPrincipal.setText("");
                    ((JTextComponent)this.securityCredentials).setText("");
                    this.additionalProperties.initProperties(new Properties());
                    this.tabPane.setComponentAt(1, this.providerObjectPanel);
                }
            } else {
                this.objectFactoryName.setText("");
                this.className.setText("");
                this.linkFactoryName.setText("");
                this.initContFactory.setText("");
                this.providerURL.setText("");
                this.securityPrincipal.setText("");
                ((JTextComponent)this.securityCredentials).setText("");
                this.propertiesEditor.initProperties(new Properties());
                this.additionalProperties.initProperties(new Properties());
                this.tabPane.setEnabledAt(1, false);
            }
        }
        this.dataChanged();
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.factoriesModel.clear();
        this.factories = new HashMap();
        this.clearFields();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

