/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.jmsconnector.descriptor.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.gui.JMSDestinationsPanel;
import com.sap.engine.services.jmsconnector.descriptor.gui.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class JMSDestinationsPanelLogical
extends JMSDestinationsPanel {
    private DestinationDescriptor[] destinations = null;
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public JMSDestinationsPanelLogical(Frame frame, int madeFromConstant) {
        this.setFrame(frame);
        this.init(this.madeFrom);
    }

    private void initList(DestinationDescriptor[] values) {
        this.model.clear();
        this.lastSelected = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.addElement(new ListValues(values[i], 0));
                ++i;
            }
        }
    }

    private void addDest(String name, String factory, String user, String password, String description) {
        if (name == null || name.equals("")) {
            return;
        }
        ListValues listValue = null;
        DestinationDescriptor dest = null;
        DestinationDescriptor temp = new DestinationDescriptor(name, factory, user, password, description);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            dest = listValue.getDestination();
            if (!name.equals(dest.getDestinationName())) continue;
            if (temp.equals(dest)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "JMS Destination <" + name + "> already exists.\n Would you like to save the changes and modify this Destination?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyDest(listValue, factory, user, password, description);
            }
            this.clearFields();
            return;
        }
        this.model.addElement(new ListValues(temp, 0));
    }

    private void modifyDest(ListValues dest, String factory, String user, String password, String description) {
        if (dest == null) {
            return;
        }
        dest.getDestination().setConnectionFactory(factory);
        dest.getDestination().setUserName(user);
        dest.getDestination().setPassword(password);
        dest.getDestination().setDescription(description);
    }

    private void removeDest(ListValues dest) {
        if (dest == null) {
            return;
        }
        this.model.removeElement(dest);
    }

    public void setDestinations(DestinationDescriptor[] dests) {
        this.destinations = dests;
        this.clearFields();
        this.initList(this.destinations);
    }

    public DestinationDescriptor[] getDestinations() {
        return this.destinations;
    }

    private void showDest(ListValues dest) {
        if (dest == null || dest.getDestination() == null || dest.getDestination().getDestinationName() == null || dest.getDestination().getDestinationName().equals("")) {
            return;
        }
        DestinationDescriptor destination = dest.getDestination();
        this.nameTextField.setText(destination.getDestinationName());
        if (destination.getConnectionFactory() == null) {
            ((JTextField)this.factoryCombo.getEditor().getEditorComponent()).setText("");
        } else {
            ((JTextField)this.factoryCombo.getEditor().getEditorComponent()).setText(destination.getConnectionFactory());
        }
        if (destination.getUserName() == null) {
            this.userTextField.setText("");
        } else {
            this.userTextField.setText(destination.getUserName());
        }
        if (destination.getPassword() == null) {
            ((JTextComponent)this.passwordField).setText("");
        } else {
            ((JTextComponent)this.passwordField).setText(destination.getPassword());
        }
        if (destination.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(destination.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.destinationsList.isSelectionEmpty()) {
                selected = this.destinationsList.getSelectedIndex();
                this.showDest((ListValues)this.model.get(selected));
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            this.lastSelected = selected;
        }
    }

    private void checkPanel() {
        String name = null;
        String factory = null;
        String user = null;
        String password = null;
        String description = null;
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        if (!((JTextField)this.factoryCombo.getEditor().getEditorComponent()).getText().trim().equals("")) {
            factory = ((JTextField)this.factoryCombo.getEditor().getEditorComponent()).getText().trim();
        }
        if (!this.userTextField.getText().trim().equals("")) {
            user = this.userTextField.getText().trim();
        }
        if (!this.passwordField.getText().trim().equals("")) {
            password = this.passwordField.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            description = this.descrPanel.getText().trim();
        }
        if (name == null) {
            return;
        }
        ListValues listValue = null;
        DestinationDescriptor dest = null;
        DestinationDescriptor temp = new DestinationDescriptor(name, factory, user, password, description);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            dest = listValue.getDestination();
            if (!name.equals(dest.getDestinationName())) continue;
            if (temp.equals(dest)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for JMS Destination <" + name + "> was changed.\n Would you like to save the changes and modify this Destination?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyDest(listValue, factory, user, password, description);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this JMS Destiantion?", "Warning", 0, 2);
        if (answer == 0) {
            this.addDest(name, factory, user, password, description);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String name = null;
        String factory = null;
        String user = null;
        String password = null;
        String description = null;
        String cmd = e.getActionCommand();
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        if (!((JTextField)this.factoryCombo.getEditor().getEditorComponent()).getText().trim().equals("")) {
            factory = ((JTextField)this.factoryCombo.getEditor().getEditorComponent()).getText().trim();
        }
        if (!this.userTextField.getText().trim().equals("")) {
            user = this.userTextField.getText().trim();
        }
        if (!this.passwordField.getText().trim().equals("")) {
            password = this.passwordField.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            description = this.descrPanel.getText().trim();
        }
        if (cmd.equals("ADD_CMD")) {
            this.addDest(name, factory, user, password, description);
            this.destinationsList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyDest((ListValues)this.destinationsList.getSelectedValue(), factory, user, password, description);
            this.destinationsList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeDest((ListValues)this.destinationsList.getSelectedValue());
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.destinationsList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        String name = this.nameTextField.getText().trim();
        String factory = ((JTextField)this.factoryCombo.getEditor().getEditorComponent()).getText().trim();
        String user = this.userTextField.getText().trim();
        String password = this.passwordField.getText().trim();
        String description = this.descrPanel.getText().trim();
        if (name.equals("") && factory.equals("") && user.equals("") && password.equals("") && description.equals("") && this.destinationsList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
        }
        if (name.equals("")) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.model.clear();
        this.destinations = null;
        this.clearFields();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.destinations = new DestinationDescriptor[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            this.destinations[i] = ((ListValues)this.model.get(i)).getDestination();
            ++i;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

