/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.jmsconnector.descriptor.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLParser {
    public static final String dtd = "<!DOCTYPE jms-factories SYSTEM 'jms-factories.dtd'>";
    static /* synthetic */ Class class$com$sap$engine$services$jmsconnector$descriptor$XMLParser;

    public static Document loadDocumentFromDescriptor(JMSConnectorDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        boolean hasElements = false;
        ConnectionFactoryDescriptor[] factories = descriptor.getFactories();
        if (factories == null || factories.length == 0) {
            return null;
        }
        Document mainDocument = null;
        Element all = null;
        ConnectionFactoryDescriptor descr = null;
        Element facElem = null;
        String temp = null;
        String[] aliases = null;
        Element typeEl = null;
        Properties props = null;
        Element propsElement = null;
        Element propEl = null;
        Enumeration enumeration = null;
        try {
            ClassLoader previousLoader = null;
            try {
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$jmsconnector$descriptor$XMLParser == null ? (class$com$sap$engine$services$jmsconnector$descriptor$XMLParser = XMLParser.class$("com.sap.engine.services.jmsconnector.descriptor.XMLParser")) : class$com$sap$engine$services$jmsconnector$descriptor$XMLParser).getClassLoader());
                mainDocument = StandardDOMParser.createDocument();
                Object var16_16 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
                throw throwable;
            }
            all = mainDocument.createElement("jms-factories");
            if (descriptor.getApplicationName() != null && !descriptor.getApplicationName().equals("")) {
                XMLParser.load(mainDocument, all, descriptor.getApplicationName(), "application-name");
            }
            int i = 0;
            while (i < factories.length) {
                descr = factories[i];
                facElem = mainDocument.createElement("connection-factory");
                all.appendChild(facElem);
                temp = descr.getDescription();
                if (temp != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, temp, "description");
                }
                if ((temp = descr.getLibraryName()) != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, temp, "library-name");
                }
                aliases = descr.getAliases();
                int j = 0;
                while (j < aliases.length) {
                    XMLParser.load(mainDocument, facElem, aliases[j], "alias");
                    ++j;
                }
                temp = descr.getFactoryName();
                if (temp != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, descr.getFactoryName(), "factory-name");
                    hasElements = true;
                }
                if (descr.hasNaming()) {
                    typeEl = mainDocument.createElement("context-factory-type");
                    facElem.appendChild(typeEl);
                    temp = descr.getLinkFactoryName();
                    if (temp != null && temp.length() != 0) {
                        XMLParser.load(mainDocument, typeEl, temp, "link-factory-name");
                    }
                    props = descr.getContextProperties();
                    XMLParser.load(mainDocument, typeEl, props.getProperty("java.naming.factory.initial"), "initial-context-factory");
                    XMLParser.load(mainDocument, typeEl, props.getProperty("java.naming.provider.url"), "provider-url");
                    XMLParser.load(mainDocument, typeEl, props.getProperty("java.naming.security.principal"), "security-principal");
                    XMLParser.load(mainDocument, typeEl, props.getProperty("java.naming.security.credentials"), "security-credentials");
                    Properties tempProps = new Properties();
                    ((Hashtable)tempProps).putAll(props);
                    ((Hashtable)tempProps).remove("java.naming.factory.initial");
                    ((Hashtable)tempProps).remove("java.naming.provider.url");
                    ((Hashtable)tempProps).remove("java.naming.security.principal");
                    ((Hashtable)tempProps).remove("java.naming.security.credentials");
                    if (!((Hashtable)tempProps).isEmpty()) {
                        propsElement = mainDocument.createElement("properties");
                        enumeration = ((Hashtable)props).keys();
                        while (enumeration.hasMoreElements()) {
                            temp = (String)enumeration.nextElement();
                            propEl = mainDocument.createElement("property");
                            XMLParser.load(mainDocument, propEl, temp, "property-name");
                            XMLParser.load(mainDocument, propEl, props.getProperty(temp), "property-value");
                            propsElement.appendChild(propEl);
                        }
                        typeEl.appendChild(propsElement);
                    }
                } else {
                    typeEl = mainDocument.createElement("object-factory-type");
                    facElem.appendChild(typeEl);
                    temp = descr.getObjectFactoryName();
                    if (temp != null && temp.length() != 0) {
                        XMLParser.load(mainDocument, typeEl, temp, "object-factory-name");
                    }
                    if ((temp = descr.getClassName()) != null && temp.length() != 0) {
                        XMLParser.load(mainDocument, typeEl, temp, "class-name");
                    }
                    if ((props = descr.getCreateFactoryProperties()) != null && ((Hashtable)props).size() != 0) {
                        propsElement = mainDocument.createElement("properties");
                        typeEl.appendChild(propsElement);
                        Enumeration<?> e = props.propertyNames();
                        while (e.hasMoreElements()) {
                            temp = (String)e.nextElement();
                            propEl = mainDocument.createElement("property");
                            propsElement.appendChild(propEl);
                            XMLParser.load(mainDocument, propEl, temp, "property-name");
                            XMLParser.load(mainDocument, propEl, props.getProperty(temp), "property-value");
                        }
                    }
                }
                temp = descr.getClientID();
                if (temp != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, temp, "client-id");
                }
                if ((temp = descr.getUserName()) != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, temp, "user-name");
                }
                if ((temp = descr.getPassword()) != null && temp.length() != 0) {
                    XMLParser.load(mainDocument, facElem, temp, "password");
                }
                if (descr.getMode() == 1) {
                    typeEl = mainDocument.createElement("pooled");
                    facElem.appendChild(typeEl);
                    if (descr.getExpireTimeout() != 0L) {
                        temp = Long.toString(descr.getExpireTimeout());
                        XMLParser.load(mainDocument, typeEl, temp, "expire-timeout");
                    }
                    if (descr.getMinConnections() != 0) {
                        temp = Integer.toString(descr.getMinConnections());
                        XMLParser.load(mainDocument, typeEl, temp, "min-connections");
                    }
                    if (descr.getMaxConnections() != 0) {
                        temp = Integer.toString(descr.getMaxConnections());
                        XMLParser.load(mainDocument, typeEl, temp, "max-connections");
                    }
                    if (descr.getTimeToWait() != 0) {
                        temp = Integer.toString(descr.getTimeToWait());
                        XMLParser.load(mainDocument, typeEl, temp, "time-to-wait");
                    }
                } else if (descr.getMode() == 2) {
                    typeEl = mainDocument.createElement("shared");
                    facElem.appendChild(typeEl);
                    if (descr.getExpireTimeout() != 0L) {
                        temp = Long.toString(descr.getExpireTimeout());
                        XMLParser.load(mainDocument, typeEl, temp, "expire-timeout");
                    }
                }
                ++i;
            }
            mainDocument.appendChild(all);
        }
        catch (DOMException ex) {
            XMLParser.log(ex);
        }
        if (!hasElements) {
            return null;
        }
        return mainDocument;
    }

    public static JMSConnectorDescriptor loadDescriptorFromDocument(Document doc, JMSConnectorDescriptor descr) throws IllegalArgumentException, WrongStructureException {
        if (descr == null) {
            descr = new JMSConnectorDescriptor();
        }
        Element elem = doc.getDocumentElement();
        NodeList factoriesList = elem.getChildNodes();
        ConnectionFactoryDescriptor descriptor = null;
        ArrayList<String> aliases = new ArrayList<String>();
        Properties properties = null;
        NodeList connList = null;
        NodeList typeList = null;
        Element typeEl = null;
        Element el = null;
        String tempTag = null;
        String tag = null;
        String value = null;
        String toParse = null;
        long number = 0L;
        int number1 = 0;
        int j = 0;
        while (j < factoriesList.getLength()) {
            if (factoriesList.item(j).getNodeType() == 1) {
                el = (Element)factoriesList.item(j);
                tempTag = el.getTagName();
                if (tempTag.equals("application-name")) {
                    descr.setApplicationName(XMLParser.getTextValue(el));
                } else if (tempTag.equals("connection-factory")) {
                    descriptor = new ConnectionFactoryDescriptor();
                    aliases = new ArrayList();
                    connList = el.getChildNodes();
                    int i = 0;
                    while (i < connList.getLength()) {
                        if (connList.item(i).getNodeType() == 1) {
                            int c;
                            el = (Element)connList.item(i);
                            tag = el.getNodeName();
                            if (tag.equals("description")) {
                                descriptor.setDescription(XMLParser.getTextValue(el));
                            } else if (tag.equals("library-name")) {
                                descriptor.setLibraryName(XMLParser.getTextValue(el));
                            } else if (tag.equals("alias")) {
                                aliases.add(XMLParser.getTextValue(el));
                            } else if (tag.equals("factory-name")) {
                                descriptor.setFactoryName(XMLParser.getTextValue(el));
                            } else if (tag.equals("context-factory-type")) {
                                descriptor.setNaming(true);
                                properties = new Properties();
                                typeList = el.getChildNodes();
                                c = 0;
                                while (c < typeList.getLength()) {
                                    if (typeList.item(c).getNodeType() == 1) {
                                        typeEl = (Element)typeList.item(c);
                                        value = typeEl.getNodeName();
                                        if (value.equals("link-factory-name")) {
                                            descriptor.setLinkFactoryName(XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("initial-context-factory")) {
                                            ((Hashtable)properties).put("java.naming.factory.initial", XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("provider-url")) {
                                            ((Hashtable)properties).put("java.naming.provider.url", XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("security-principal")) {
                                            ((Hashtable)properties).put("java.naming.security.principal", XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("security-credentials")) {
                                            ((Hashtable)properties).put("java.naming.security.credentials", XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("properties")) {
                                            XMLParser.processProperties(typeEl, properties);
                                        } else {
                                            throw new WrongStructureException("Unknown Tag : " + value);
                                        }
                                    }
                                    ++c;
                                }
                                descriptor.setContextProperties(properties);
                            } else if (tag.equals("object-factory-type")) {
                                descriptor.setNaming(false);
                                properties = new Properties();
                                typeList = el.getChildNodes();
                                c = 0;
                                while (c < typeList.getLength()) {
                                    if (typeList.item(c).getNodeType() == 1) {
                                        typeEl = (Element)typeList.item(c);
                                        value = typeEl.getNodeName();
                                        if (value.equals("object-factory-name")) {
                                            descriptor.setObjectFactoryName(XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("class-name")) {
                                            descriptor.setClassName(XMLParser.getTextValue(typeEl));
                                        } else if (value.equals("properties")) {
                                            XMLParser.processProperties(typeEl, properties);
                                        } else {
                                            throw new WrongStructureException("Unknown Tag : " + value);
                                        }
                                    }
                                    ++c;
                                }
                                descriptor.setCreateFactoryProperties(properties);
                            } else if (tag.equals("client-id")) {
                                descriptor.setClientID(XMLParser.getTextValue(el));
                            } else if (tag.equals("user-name")) {
                                descriptor.setUserName(XMLParser.getTextValue(el));
                            } else if (tag.equals("password")) {
                                descriptor.setPassword(XMLParser.getTextValue(el));
                            } else if (tag.equals("pooled")) {
                                descriptor.setMode(1);
                                typeList = el.getChildNodes();
                                c = 0;
                                while (c < typeList.getLength()) {
                                    if (typeList.item(c).getNodeType() == 1) {
                                        typeEl = (Element)typeList.item(c);
                                        value = typeEl.getNodeName();
                                        if (value.equals("expire-timeout")) {
                                            toParse = XMLParser.getTextValue(typeEl);
                                            try {
                                                number = Long.parseLong(toParse);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new IllegalArgumentException("Provided value for expire-timeout: " + toParse + " can not be parsed to a long number.");
                                            }
                                            if (number < 0L) {
                                                throw new IllegalArgumentException("Provided value for expire-timeout: " + toParse + " is incorrect. It should be a non negative number.");
                                            }
                                            descriptor.setExpireTimeout(number);
                                        } else if (value.equals("min-connections")) {
                                            toParse = XMLParser.getTextValue(typeEl);
                                            try {
                                                number1 = Integer.parseInt(toParse);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new IllegalArgumentException("Provided value for min-connections: " + toParse + " can not be parsed to an integer.");
                                            }
                                            if (number1 < 0) {
                                                throw new IllegalArgumentException("Provided value for min-connections: " + toParse + " is incorrect. It should be a non negative number.");
                                            }
                                            descriptor.setMinConnections(number1);
                                        } else if (value.equals("max-connections")) {
                                            toParse = XMLParser.getTextValue(typeEl);
                                            try {
                                                number1 = Integer.parseInt(toParse);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new IllegalArgumentException("Provided value for max-connections: " + toParse + " can not be parsed to an integer.");
                                            }
                                            if (number1 < 0) {
                                                throw new IllegalArgumentException("Provided value for max-connections: " + toParse + " is incorrect. It should be a non negative number.");
                                            }
                                            descriptor.setMaxConnections(number1);
                                        } else if (value.equals("time-to-wait")) {
                                            toParse = XMLParser.getTextValue(typeEl);
                                            try {
                                                number1 = Integer.parseInt(toParse);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new IllegalArgumentException("Provided value for time-to-wait: " + toParse + " can not be parsed to an integer.");
                                            }
                                            if (number1 < 0) {
                                                throw new IllegalArgumentException("Provided value for time-to-wait: " + toParse + " is incorrect. It should be a non negative number.");
                                            }
                                            descriptor.setTimeToWait(number1);
                                        } else {
                                            throw new WrongStructureException("Unknown Tag : " + value);
                                        }
                                    }
                                    ++c;
                                }
                            } else if (tag.equals("shared")) {
                                descriptor.setMode(2);
                                typeList = el.getChildNodes();
                                c = 0;
                                while (c < typeList.getLength()) {
                                    if (typeList.item(c).getNodeType() == 1) {
                                        typeEl = (Element)typeList.item(c);
                                        value = typeEl.getNodeName();
                                        if (value.equals("expire-timeout")) {
                                            toParse = XMLParser.getTextValue(typeEl);
                                            try {
                                                number = Long.parseLong(toParse);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new IllegalArgumentException("Provided value for expire-timeout: " + toParse + " can not be parsed to a long number.");
                                            }
                                            if (number < 0L) {
                                                throw new IllegalArgumentException("Provided value for expire-timeout: " + toParse + " is incorrect. It should be a non negative number.");
                                            }
                                            descriptor.setExpireTimeout(number);
                                        } else {
                                            throw new WrongStructureException("Unknown Tag : " + value);
                                        }
                                    }
                                    ++c;
                                }
                            } else if (!tag.equals("connection-factory-type")) {
                                throw new WrongStructureException("Unknown Tag : " + tag);
                            }
                        }
                        ++i;
                    }
                    descriptor.setAliases(aliases.toArray(new String[aliases.size()]));
                    descr.addFactory(descriptor);
                } else {
                    throw new WrongStructureException("Unknown Tag : " + tempTag);
                }
            }
            ++j;
        }
        return descr;
    }

    private static final void processProperties(Element propElement, Properties properties) {
        NodeList propertyList = propElement.getChildNodes();
        int i = 0;
        while (i < propertyList.getLength()) {
            Element el;
            String tag;
            if (propertyList.item(i).getNodeType() == 1 && (tag = (el = (Element)propertyList.item(i)).getNodeName()).equals("property")) {
                NodeList entList = el.getChildNodes();
                String propertyName = null;
                String propertyValue = null;
                int j = 0;
                while (j < entList.getLength()) {
                    if (entList.item(j).getNodeType() == 1) {
                        Element nextEl = (Element)entList.item(j);
                        String nextTag = nextEl.getNodeName();
                        if (nextTag.equals("property-name")) {
                            propertyName = XMLParser.getTextValue(nextEl);
                        } else if (nextTag.equals("property-value")) {
                            propertyValue = XMLParser.getTextValue(nextEl);
                        }
                    }
                    ++j;
                }
                if (propertyName != null && propertyValue != null) {
                    properties.setProperty(propertyName, propertyValue);
                }
            }
            ++i;
        }
    }

    private static Element load(Document mainDocument, Element el, String value, String tagName) {
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private static final String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    private static void log(Exception exc) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

