/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.jmsconnector.descriptor.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.DestinationDescriptor;
import java.io.Serializable;

public class JMSConnectorDescriptor
implements Serializable {
    static final long serialVersionUID = 3919232871049387800L;
    private String applicationName = null;
    private ConnectionFactoryDescriptor[] factories = null;
    private DestinationDescriptor[] destinations = null;

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setFactories(ConnectionFactoryDescriptor[] conFactories) {
        this.factories = conFactories;
    }

    public ConnectionFactoryDescriptor[] getFactories() {
        return this.factories;
    }

    public void addFactory(ConnectionFactoryDescriptor newFact) {
        if (newFact == null || newFact.getFactoryName() == null) {
            return;
        }
        if (this.factories == null || this.factories.length == 0) {
            this.factories = new ConnectionFactoryDescriptor[1];
            this.factories[0] = newFact;
        } else {
            int i = 0;
            while (i < this.factories.length) {
                if (this.factories[i] != null && this.factories[i].getFactoryName().equals(newFact.getFactoryName())) {
                    this.factories[i] = newFact;
                    return;
                }
                ++i;
            }
            ConnectionFactoryDescriptor[] newArray = new ConnectionFactoryDescriptor[this.factories.length + 1];
            System.arraycopy(this.factories, 0, newArray, 0, this.factories.length);
            newArray[this.factories.length] = newFact;
            this.factories = newArray;
        }
    }

    public void setDestinations(DestinationDescriptor[] jmsDestinations) {
        this.destinations = jmsDestinations;
    }

    public DestinationDescriptor[] getDestinations() {
        return this.destinations;
    }

    public void addDestination(DestinationDescriptor newDest) {
        if (newDest == null || newDest.getDestinationName() == null) {
            return;
        }
        if (this.destinations == null || this.destinations.length == 0) {
            this.destinations = new DestinationDescriptor[1];
            this.destinations[0] = newDest;
        } else {
            int i = 0;
            while (i < this.destinations.length) {
                if (this.destinations[i] != null && this.destinations[i].getDestinationName().equals(newDest.getDestinationName())) {
                    this.destinations[i] = newDest;
                    return;
                }
                ++i;
            }
            DestinationDescriptor[] newArray = new DestinationDescriptor[this.destinations.length + 1];
            System.arraycopy(this.destinations, 0, newArray, 0, this.destinations.length);
            newArray[this.destinations.length] = newDest;
            this.destinations = newArray;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JMSConnectorDescriptor)) {
            return false;
        }
        JMSConnectorDescriptor descr = (JMSConnectorDescriptor)obj;
        if (descr.applicationName != null ? !descr.applicationName.equals(this.applicationName) : this.applicationName != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(descr.factories, this.factories)) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays(descr.destinations, this.destinations);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        int i;
        JMSConnectorDescriptor cloning = new JMSConnectorDescriptor();
        String string = cloning.applicationName = this.applicationName == null ? null : new String(this.applicationName);
        if (this.factories == null) {
            cloning.factories = null;
        } else {
            cloning.factories = new ConnectionFactoryDescriptor[this.factories.length];
            i = 0;
            while (i < this.factories.length) {
                cloning.factories[i] = this.factories[i] == null ? null : (ConnectionFactoryDescriptor)this.factories[i].clone();
                ++i;
            }
        }
        if (this.destinations == null) {
            cloning.destinations = null;
        } else {
            cloning.destinations = new DestinationDescriptor[this.destinations.length];
            i = 0;
            while (i < this.destinations.length) {
                cloning.destinations[i] = this.destinations[i] == null ? null : (DestinationDescriptor)this.destinations[i].clone();
                ++i;
            }
        }
        return cloning;
    }
}

