/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.jmsconnector.descriptor.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DestinationsDescriptorDocument {
    public static final String dtd = "<!DOCTYPE jms-destinations SYSTEM 'jms-destinations.dtd'>";
    private Document mainDocument;
    private boolean hasElements = false;

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document document) {
        this.mainDocument = document;
    }

    public boolean needsLoad() {
        return this.hasElements;
    }

    public Document loadDocumentFromDescriptor(JMSConnectorDescriptor descr) {
        if (descr == null) {
            return null;
        }
        try {
            ClassLoader previousLoader = null;
            try {
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.mainDocument = StandardDOMParser.createDocument();
                Object var4_4 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
                throw throwable;
            }
            this.mainDocument.appendChild(this.loadDocumentElement(descr));
        }
        catch (DOMException ex) {
            this.log(ex);
        }
        return this.mainDocument;
    }

    private Element loadDocumentElement(JMSConnectorDescriptor descr) {
        Element docElement = null;
        try {
            docElement = this.mainDocument.createElement("jms-destinations");
            this.loadDestinations(docElement, descr.getDestinations());
        }
        catch (Exception e) {
            this.log(e);
        }
        return docElement;
    }

    private void loadDestinations(Element docEl, DestinationDescriptor[] destinations) {
        if (destinations == null || destinations.length == 0) {
            return;
        }
        Element tempEl = null;
        try {
            int i = 0;
            while (i < destinations.length) {
                if (destinations[i] != null && destinations[i].getDestinationName() != null && !destinations[i].getDestinationName().equals("")) {
                    tempEl = this.mainDocument.createElement("destination");
                    if (destinations[i].getConnectionFactory() != null && !destinations[i].getConnectionFactory().equals("")) {
                        this.load(tempEl, destinations[i].getConnectionFactory(), "connection-factory");
                    }
                    this.load(tempEl, destinations[i].getDestinationName(), "destination-name");
                    this.hasElements = true;
                    if (destinations[i].getUserName() != null && !destinations[i].getUserName().equals("")) {
                        this.load(tempEl, destinations[i].getUserName(), "user-name");
                    }
                    if (destinations[i].getPassword() != null && !destinations[i].getPassword().equals("")) {
                        this.load(tempEl, destinations[i].getPassword(), "password");
                    }
                    if (destinations[i].getDescription() != null && !destinations[i].getDescription().equals("")) {
                        this.load(tempEl, destinations[i].getDescription(), "description");
                    }
                    docEl.appendChild(tempEl);
                }
                ++i;
            }
        }
        catch (Exception exc) {
            this.log(exc);
        }
    }

    private void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    public JMSConnectorDescriptor loadDescriptorFromDocument(Document doc, JMSConnectorDescriptor descr) throws IllegalArgumentException {
        Element elm = doc.getDocumentElement();
        if (descr == null) {
            descr = new JMSConnectorDescriptor();
        }
        return this.loadDescriptorFromElement(elm, descr);
    }

    private JMSConnectorDescriptor loadDescriptorFromElement(Element elem, JMSConnectorDescriptor descr) throws IllegalArgumentException {
        NodeList list = elem.getChildNodes();
        Element element = null;
        String tag = null;
        Object value = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()).equals("destination")) {
                this.processDestination(element, descr);
            }
            ++i;
        }
        return descr;
    }

    private void processDestination(Element destEl, JMSConnectorDescriptor descr) throws IllegalArgumentException {
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = destEl.getChildNodes();
        DestinationDescriptor destination = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("destination-name")) {
                    value = this.getTextValue(element);
                    if (value == null || value.equals("")) {
                        throw new IllegalArgumentException("Incorect destination name for jms destination.");
                    }
                    if (destination == null) {
                        destination = new DestinationDescriptor();
                    }
                    destination.setDestinationName(value);
                } else if (tag.equals("connection-factory")) {
                    value = this.getTextValue(element);
                    if (value == null || value.equals("")) {
                        throw new IllegalArgumentException("Incorect connection factory for jms destination.");
                    }
                    if (destination == null) {
                        destination = new DestinationDescriptor();
                    }
                    destination.setConnectionFactory(value);
                } else if (tag.equals("user-name")) {
                    destination.setUserName(this.getTextValue(element));
                } else if (tag.equals("password")) {
                    destination.setPassword(this.getTextValue(element));
                } else if (tag.equals("description")) {
                    destination.setDescription(this.getTextValue(element));
                }
            }
            ++i;
        }
        if (destination != null) {
            descr.addDestination(destination);
        }
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String obj = node.getNodeValue();
            if (obj == null) {
                return null;
            }
            String value = obj;
            if (value.trim().equals("")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    private void log(Exception exc) {
    }
}

