/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.deploy;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.jmsconnector.deploy.ApplicationInfo;
import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.deploy.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.exceptions.ParseXMLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLParser {
    private static final String EMPTY_PASSWORD = "**********";
    static /* synthetic */ Class class$com$sap$engine$services$jmsconnector$deploy$XMLParser;

    public static void generateDestinationXML(String applicationName, ArrayList descriptors, OutputStream out) throws IOException, ParserConfigurationException {
        XMLParser.generateDestinationXML(applicationName, descriptors, null, out, true);
    }

    public static void generateDestinationXML(String applicationName, ArrayList descriptors, String xmlFileName) throws IOException, ParserConfigurationException {
        XMLParser.generateDestinationXML(applicationName, descriptors, xmlFileName, null, true);
    }

    public static void generatePublicDestinationXML(String applicationName, ArrayList descriptors, String xmlFileName) throws IOException, ParserConfigurationException {
        XMLParser.generateDestinationXML(applicationName, descriptors, xmlFileName, null, false);
    }

    private static void generateDestinationXML(String applicationName, ArrayList descriptors, String xmlFileName, OutputStream out, boolean savePassword) throws IOException, ParserConfigurationException {
        DocumentBuilder builder = XMLParser.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element all = mainDocument.createElement("jms-destinations");
        mainDocument.appendChild(all);
        XMLParser.load(mainDocument, all, applicationName, "application-name");
        int i = 0;
        while (i < descriptors.size()) {
            DestinationDescriptor descr = (DestinationDescriptor)descriptors.get(i);
            Element facElem = mainDocument.createElement("destination");
            all.appendChild(facElem);
            String temp = descr.getConnectionFactory();
            XMLParser.load(mainDocument, facElem, temp, "connection-factory");
            temp = descr.getDestinationName();
            XMLParser.load(mainDocument, facElem, temp, "destination-name");
            temp = descr.getUserName();
            if (temp.length() != 0) {
                XMLParser.load(mainDocument, facElem, savePassword ? temp : EMPTY_PASSWORD, "user-name");
            }
            if ((temp = descr.getPassword()).length() != 0) {
                XMLParser.load(mainDocument, facElem, savePassword ? temp : EMPTY_PASSWORD, "password");
            }
            if ((temp = descr.getDescription()).length() != 0) {
                XMLParser.load(mainDocument, facElem, temp, "description");
            }
            ++i;
        }
        if (xmlFileName != null) {
            new StandardDOMWriter().write(mainDocument, xmlFileName, "");
        } else {
            new StandardDOMWriter().write(mainDocument, out, "");
        }
    }

    public static ApplicationInfo parseJmsXml(InputStream xmlStream) throws ParseXMLException, IOException, SAXException {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        Document document = null;
        StandardDOMParser parser = XMLParser.createStandardDOMParser();
        document = parser.parse(xmlStream);
        xmlStream.close();
        boolean isFactory = true;
        NodeList main = document.getElementsByTagName("jms-factories");
        if (main.getLength() == 0) {
            isFactory = false;
            main = document.getElementsByTagName("jms-destinations");
        }
        if (isFactory) {
            if (main.getLength() != 1) {
                throw new ParseXMLException("jmsconnector_0000", "jms-factories");
            }
            applicationInfo.type = 0;
            XMLParser.parseJmsFactory(main.item(0).getChildNodes(), applicationInfo);
        } else {
            if (main.getLength() != 1) {
                throw new ParseXMLException("jmsconnector_0000", "jms-destinations");
            }
            applicationInfo.type = 1;
            XMLParser.parseJmsDestination(main.item(0).getChildNodes(), applicationInfo);
        }
        return applicationInfo;
    }

    public static void generateFactoryXML(String applicationName, ArrayList data, OutputStream out) throws IOException, ParserConfigurationException {
        XMLParser.generateFactoryXML(applicationName, data, null, out, true);
    }

    public static void generatePublicFactoryXML(String applicationName, ArrayList data, String absolutePath) throws IOException, ParserConfigurationException {
        XMLParser.generateFactoryXML(applicationName, data, absolutePath, null, false);
    }

    public static void generateFactoryXML(String applicationName, ArrayList data, String absolutePath) throws IOException, ParserConfigurationException {
        XMLParser.generateFactoryXML(applicationName, data, absolutePath, null, true);
    }

    private static void generateFactoryXML(String applicationName, ArrayList data, String absolutePath, OutputStream out, boolean savePassword) throws IOException, ParserConfigurationException {
        DocumentBuilder builder = XMLParser.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element all = mainDocument.createElement("jms-factories");
        mainDocument.appendChild(all);
        XMLParser.load(mainDocument, all, applicationName, "application-name");
        int i = 0;
        while (i < data.size()) {
            Element prop;
            String name;
            Enumeration<?> e;
            Element propsElement;
            Properties props;
            ConnectionFactoryDescriptor descr = (ConnectionFactoryDescriptor)data.get(i);
            Element facElem = mainDocument.createElement("connection-factory");
            all.appendChild(facElem);
            String temp = descr.getDescription();
            if (temp.length() != 0) {
                XMLParser.load(mainDocument, facElem, temp, "description");
            }
            if ((temp = descr.getLibraryName()).length() != 0) {
                XMLParser.load(mainDocument, facElem, temp, "library-name");
            }
            String[] aliases = descr.getAliases();
            int j = 0;
            while (j < aliases.length) {
                XMLParser.load(mainDocument, facElem, aliases[j], "alias");
                ++j;
            }
            XMLParser.load(mainDocument, facElem, descr.getFactoryTypeString(), "connection-factory-type");
            XMLParser.load(mainDocument, facElem, descr.getFactoryName(), "factory-name");
            if (descr.hasNaming()) {
                Element context = mainDocument.createElement("context-factory-type");
                facElem.appendChild(context);
                temp = descr.getLinkFactoryName();
                if (temp.length() != 0) {
                    XMLParser.load(mainDocument, context, temp, "link-factory-name");
                }
                props = (Properties)((Hashtable)descr.getContextProperties()).clone();
                XMLParser.load(mainDocument, context, (String)((Hashtable)props).remove("java.naming.factory.initial"), "initial-context-factory");
                XMLParser.load(mainDocument, context, (String)((Hashtable)props).remove("java.naming.provider.url"), "provider-url");
                if (savePassword) {
                    XMLParser.load(mainDocument, context, (String)((Hashtable)props).remove("java.naming.security.principal"), "security-principal");
                    XMLParser.load(mainDocument, context, (String)((Hashtable)props).remove("java.naming.security.credentials"), "security-credentials");
                } else {
                    if (((String)((Hashtable)props).remove("java.naming.security.principal")).length() == 0) {
                        XMLParser.load(mainDocument, context, "", "security-principal");
                    } else {
                        XMLParser.load(mainDocument, context, EMPTY_PASSWORD, "security-principal");
                    }
                    if (((String)((Hashtable)props).remove("java.naming.security.credentials")).length() == 0) {
                        XMLParser.load(mainDocument, context, "", "security-credentials");
                    } else {
                        XMLParser.load(mainDocument, context, EMPTY_PASSWORD, "security-credentials");
                    }
                }
                if (((Hashtable)props).size() != 0) {
                    propsElement = mainDocument.createElement("properties");
                    context.appendChild(propsElement);
                    e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        prop = mainDocument.createElement("property");
                        propsElement.appendChild(prop);
                        XMLParser.load(mainDocument, prop, name, "property-name");
                        XMLParser.load(mainDocument, prop, props.getProperty(name), "property-value");
                    }
                }
            } else {
                Element object = mainDocument.createElement("object-factory-type");
                facElem.appendChild(object);
                temp = descr.getObjectFactoryName();
                if (temp.length() != 0) {
                    XMLParser.load(mainDocument, object, temp, "object-factory-name");
                }
                if ((temp = descr.getClassName()).length() != 0) {
                    XMLParser.load(mainDocument, object, temp, "class-name");
                }
                if (((Hashtable)(props = descr.getCreateFactoryProperties())).size() != 0) {
                    propsElement = mainDocument.createElement("properties");
                    object.appendChild(propsElement);
                    e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        prop = mainDocument.createElement("property");
                        propsElement.appendChild(prop);
                        XMLParser.load(mainDocument, prop, name, "property-name");
                        XMLParser.load(mainDocument, prop, props.getProperty(name), "property-value");
                    }
                }
            }
            temp = descr.getClientID();
            if (temp.length() != 0) {
                XMLParser.load(mainDocument, facElem, temp, "client-id");
            }
            if ((temp = descr.getUserName()).length() != 0) {
                XMLParser.load(mainDocument, facElem, savePassword ? temp : EMPTY_PASSWORD, "user-name");
            }
            if ((temp = descr.getPassword()).length() != 0) {
                XMLParser.load(mainDocument, facElem, savePassword ? temp : EMPTY_PASSWORD, "password");
            }
            ++i;
        }
        if (absolutePath != null) {
            new StandardDOMWriter().write(mainDocument, absolutePath, "");
        } else {
            new StandardDOMWriter().write(mainDocument, out, "");
        }
    }

    private static void parseJmsFactory(NodeList factoriesList, ApplicationInfo applicationInfo) throws ParseXMLException {
        ArrayList<ConnectionFactoryDescriptor> descr;
        applicationInfo.factoryDescriptors = descr = new ArrayList<ConnectionFactoryDescriptor>();
        String toParse = null;
        long number = 0L;
        int number1 = 0;
        int j = 0;
        while (j < factoriesList.getLength()) {
            if (factoriesList.item(j).getNodeType() == 1) {
                Element el = (Element)factoriesList.item(j);
                String tempTag = el.getTagName();
                if (tempTag.equals("application-name")) {
                    applicationInfo.applicationName = XMLParser.getTextValue(el);
                } else if (tempTag.equals("connection-factory")) {
                    ConnectionFactoryDescriptor descriptor = new ConnectionFactoryDescriptor();
                    ArrayList<String> aliases = new ArrayList<String>();
                    NodeList connList = el.getChildNodes();
                    int i = 0;
                    while (i < connList.getLength()) {
                        if (connList.item(i).getNodeType() == 1) {
                            Element elIn = (Element)connList.item(i);
                            String tag = elIn.getNodeName();
                            if (tag.equals("description")) {
                                descriptor.setDescription(XMLParser.getTextValue(elIn));
                            } else if (tag.equals("library-name")) {
                                descriptor.setLibraryName(XMLParser.getTextValue(elIn));
                            } else if (tag.equals("alias")) {
                                aliases.add(XMLParser.getTextValue(elIn));
                            } else if (!tag.equals("connection-factory-type")) {
                                String value;
                                NodeList typeList;
                                String value2;
                                Element typeEl;
                                int c;
                                Properties properties;
                                if (tag.equals("factory-name")) {
                                    descriptor.setFactoryName(XMLParser.getTextValue(elIn));
                                } else if (tag.equals("context-factory-type")) {
                                    descriptor.setNaming(true);
                                    properties = new Properties();
                                    NodeList typeList2 = elIn.getChildNodes();
                                    c = 0;
                                    while (c < typeList2.getLength()) {
                                        if (typeList2.item(c).getNodeType() == 1) {
                                            typeEl = (Element)typeList2.item(c);
                                            value2 = typeEl.getNodeName();
                                            if (value2.equals("link-factory-name")) {
                                                descriptor.setLinkFactoryName(XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("initial-context-factory")) {
                                                ((Hashtable)properties).put("java.naming.factory.initial", XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("provider-url")) {
                                                ((Hashtable)properties).put("java.naming.provider.url", XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("security-principal")) {
                                                ((Hashtable)properties).put("java.naming.security.principal", XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("security-credentials")) {
                                                ((Hashtable)properties).put("java.naming.security.credentials", XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("properties")) {
                                                XMLParser.processProperties(typeEl, properties);
                                            } else {
                                                throw new ParseXMLException("jmsconnector_0001", value2);
                                            }
                                        }
                                        ++c;
                                    }
                                    descriptor.setContextProperties(properties);
                                } else if (tag.equals("object-factory-type")) {
                                    descriptor.setNaming(false);
                                    properties = new Properties();
                                    NodeList typeList3 = elIn.getChildNodes();
                                    c = 0;
                                    while (c < typeList3.getLength()) {
                                        if (typeList3.item(c).getNodeType() == 1) {
                                            typeEl = (Element)typeList3.item(c);
                                            value2 = typeEl.getNodeName();
                                            if (value2.equals("object-factory-name")) {
                                                descriptor.setObjectFactoryName(XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("class-name")) {
                                                descriptor.setClassName(XMLParser.getTextValue(typeEl));
                                            } else if (value2.equals("properties")) {
                                                XMLParser.processProperties(typeEl, properties);
                                            } else {
                                                throw new ParseXMLException("jmsconnector_0001", value2);
                                            }
                                        }
                                        ++c;
                                    }
                                    descriptor.setCreateFactoryProperties(properties);
                                } else if (tag.equals("client-id")) {
                                    descriptor.setClientID(XMLParser.getTextValue(elIn));
                                } else if (tag.equals("user-name")) {
                                    descriptor.setUserName(XMLParser.getTextValue(elIn));
                                } else if (tag.equals("password")) {
                                    descriptor.setPassword(XMLParser.getTextValue(elIn));
                                } else if (tag.equals("pooled")) {
                                    descriptor.setMode(1);
                                    typeList = elIn.getChildNodes();
                                    int c2 = 0;
                                    while (c2 < typeList.getLength()) {
                                        if (typeList.item(c2).getNodeType() == 1) {
                                            Element typeEl2 = (Element)typeList.item(c2);
                                            value = typeEl2.getNodeName();
                                            if (value.equals("expire-timeout")) {
                                                toParse = XMLParser.getTextValue(typeEl2);
                                                try {
                                                    number = Long.parseLong(toParse);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new ParseXMLException("jmsconnector_0002", new Object[]{"expire-timeout", toParse}, (Throwable)nfe);
                                                }
                                                if (number < 0L) {
                                                    throw new ParseXMLException("jmsconnector_0003", new Object[]{"expire-timeout", toParse});
                                                }
                                                descriptor.setExpireTimeout(number);
                                            } else if (value.equals("min-connections")) {
                                                toParse = XMLParser.getTextValue(typeEl2);
                                                try {
                                                    number1 = Integer.parseInt(toParse);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new ParseXMLException("jmsconnector_0002", new Object[]{"min-connections", toParse}, (Throwable)nfe);
                                                }
                                                if (number1 < 0) {
                                                    throw new ParseXMLException("jmsconnector_0003", new Object[]{"min-connections", toParse});
                                                }
                                                descriptor.setMinConnections(number1);
                                            } else if (value.equals("max-connections")) {
                                                toParse = XMLParser.getTextValue(typeEl2);
                                                try {
                                                    number1 = Integer.parseInt(toParse);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new ParseXMLException("jmsconnector_0002", new Object[]{"max-connections", toParse}, (Throwable)nfe);
                                                }
                                                if (number1 < 0) {
                                                    throw new ParseXMLException("jmsconnector_0003", new Object[]{"max-connections", toParse});
                                                }
                                                descriptor.setMaxConnections(number1);
                                            } else if (value.equals("time-to-wait")) {
                                                toParse = XMLParser.getTextValue(typeEl2);
                                                try {
                                                    number1 = Integer.parseInt(toParse);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new ParseXMLException("jmsconnector_0002", new Object[]{"time-to-wait", toParse}, (Throwable)nfe);
                                                }
                                                if (number1 < 0) {
                                                    throw new ParseXMLException("jmsconnector_0003", new Object[]{"time-to-wait", toParse});
                                                }
                                                descriptor.setTimeToWait(number1);
                                            } else {
                                                throw new ParseXMLException("jmsconnector_0001", value);
                                            }
                                        }
                                        ++c2;
                                    }
                                } else if (tag.equals("shared")) {
                                    descriptor.setMode(2);
                                    typeList = elIn.getChildNodes();
                                    int c3 = 0;
                                    while (c3 < typeList.getLength()) {
                                        if (typeList.item(c3).getNodeType() == 1) {
                                            Element typeEl3 = (Element)typeList.item(c3);
                                            value = typeEl3.getNodeName();
                                            if (value.equals("expire-timeout")) {
                                                toParse = XMLParser.getTextValue(typeEl3);
                                                try {
                                                    number = Long.parseLong(toParse);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new ParseXMLException("jmsconnector_0002", new Object[]{"expire-timeout", toParse}, (Throwable)nfe);
                                                }
                                                if (number < 0L) {
                                                    throw new ParseXMLException("jmsconnector_0003", new Object[]{"expire-timeout", toParse});
                                                }
                                                descriptor.setExpireTimeout(number);
                                            } else {
                                                throw new ParseXMLException("jmsconnector_0001", value);
                                            }
                                        }
                                        ++c3;
                                    }
                                } else {
                                    throw new ParseXMLException("jmsconnector_0001", tag);
                                }
                            }
                        }
                        ++i;
                    }
                    descriptor.setAliases(aliases.toArray(new String[aliases.size()]));
                    descr.add(descriptor);
                } else {
                    throw new ParseXMLException("jmsconnector_0001", tempTag);
                }
            }
            ++j;
        }
    }

    private static void parseJmsDestination(NodeList factoriesList, ApplicationInfo applicationInfo) throws ParseXMLException {
        ArrayList<DestinationDescriptor> descr;
        applicationInfo.destinationsDescriptors = descr = new ArrayList<DestinationDescriptor>();
        int j = 0;
        while (j < factoriesList.getLength()) {
            if (factoriesList.item(j).getNodeType() == 1) {
                Element el = (Element)factoriesList.item(j);
                String tag = el.getNodeName();
                if (tag.equals("destination")) {
                    DestinationDescriptor descriptor = new DestinationDescriptor();
                    NodeList connList = el.getChildNodes();
                    int i = 0;
                    while (i < connList.getLength()) {
                        if (connList.item(i).getNodeType() == 1) {
                            Element connEl = (Element)connList.item(i);
                            String connTag = connEl.getNodeName();
                            if (connTag.equals("description")) {
                                descriptor.setDescription(XMLParser.getTextValue(connEl));
                            } else if (connTag.equals("connection-factory")) {
                                descriptor.setConnectionFactory(XMLParser.getTextValue(connEl));
                            } else if (connTag.equals("destination-name")) {
                                descriptor.setDestinationName(XMLParser.getTextValue(connEl));
                            } else if (connTag.equals("user-name")) {
                                descriptor.setUserName(XMLParser.getTextValue(connEl));
                            } else if (connTag.equals("password")) {
                                descriptor.setPassword(XMLParser.getTextValue(connEl));
                            } else {
                                throw new ParseXMLException("jmsconnector_0001", connTag);
                            }
                        }
                        ++i;
                    }
                    descr.add(descriptor);
                } else if (tag.equals("application-name")) {
                    applicationInfo.applicationName = XMLParser.getTextValue(el);
                } else {
                    throw new ParseXMLException("jmsconnector_0001", tag);
                }
            }
            ++j;
        }
    }

    private static Element load(Document mainDocument, Element el, String value, String tagName) {
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private static final String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    private static final void processProperties(Element propElement, Properties properties) {
        NodeList propertyList = propElement.getChildNodes();
        int i = 0;
        while (i < propertyList.getLength()) {
            Element el;
            String tag;
            if (propertyList.item(i).getNodeType() == 1 && (tag = (el = (Element)propertyList.item(i)).getNodeName()).equals("property")) {
                NodeList entList = el.getChildNodes();
                String propertyName = null;
                String propertyValue = null;
                int j = 0;
                while (j < entList.getLength()) {
                    if (entList.item(j).getNodeType() == 1) {
                        Element nextEl = (Element)entList.item(j);
                        String nextTag = nextEl.getNodeName();
                        if (nextTag.equals("property-name")) {
                            propertyName = XMLParser.getTextValue(nextEl);
                        } else if (nextTag.equals("property-value")) {
                            propertyValue = XMLParser.getTextValue(nextEl);
                        }
                    }
                    ++j;
                }
                if (propertyName != null && propertyValue != null) {
                    properties.setProperty(propertyName, propertyValue);
                }
            }
            ++i;
        }
    }

    private static StandardDOMParser createStandardDOMParser() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$jmsconnector$deploy$XMLParser == null ? (class$com$sap$engine$services$jmsconnector$deploy$XMLParser = XMLParser.class$("com.sap.engine.services.jmsconnector.deploy.XMLParser")) : class$com$sap$engine$services$jmsconnector$deploy$XMLParser).getClassLoader());
            StandardDOMParser standardDOMParser = new StandardDOMParser();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMParser;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$jmsconnector$deploy$XMLParser == null ? (class$com$sap$engine$services$jmsconnector$deploy$XMLParser = XMLParser.class$("com.sap.engine.services.jmsconnector.deploy.XMLParser")) : class$com$sap$engine$services$jmsconnector$deploy$XMLParser).getClassLoader());
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return documentBuilder;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

