/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.jmsconnector.JMSConnectorFrame;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ApplicationInfo;
import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.deploy.DestinationDescriptor;
import com.sap.engine.services.jmsconnector.deploy.JmsManager;
import com.sap.engine.services.jmsconnector.deploy.XMLParser;
import com.sap.engine.services.jmsconnector.exceptions.BaseDeploymentException;
import com.sap.engine.services.jmsconnector.exceptions.BaseWarningException;
import com.sap.engine.services.jmsconnector.exceptions.JMSConnectorException;
import com.sap.engine.services.jmsconnector.exceptions.ParseXMLException;
import com.sap.engine.services.jmsconnector.spi.ManagedConnectionFactoryImpl;
import com.sap.tc.logging.Category;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.rmi.PortableRemoteObject;
import org.xml.sax.SAXException;

public class ContainerImpl
extends PortableRemoteObject
implements ContainerInterface,
JmsManager {
    public static final String CONTAINER_NAME = "JMSConnector";
    private static final String SECURE_SUB_CONFIGURATION = "Secure";
    private static final String META_INF = "META-INF/";
    private static final String JMS_CONNECTIONS_FILENAME = "jms-factories.xml";
    private static final String JMS_DESTINATIONS_FILENAME = "jms-destinations.xml";
    private static final String STAND_ALONE = "StandAlone";
    private static final String APPLICATION_TYPE = "ApplicationType";
    private static final String ROOT_CONF = "apps";
    private static final String DEFINED_LIBS = "libraries";
    private static final String SAP_PREFIX = "sap.com/";
    private static final String MCF_NAMING = "mcf/";
    private static final String DESCRIPTOR_NAMING = "mcf_descriptors/jms/";
    private static final String FACTORY_NAMING = "jmsFactory/";
    private static final String QUEUE_NAMING = "jmsQueues/";
    private static final String TOPIC_NAMING = "jmsTopics/";
    private static final String[] RESOURCE_TYPES = new String[]{"javax.jms.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.jms.Topic", "javax.jms.Queue"};
    private static final int APP_PRIORITY = 90;
    private static final String PROP_MAX_CONNECTIONS = "maxConnections";
    private static final String PROP_TIME_TO_WAIT_FOR_CONNECTION = "timeToWaitForConnection";
    private static final int DEF_INITIAL_CONNECTIONS = 0;
    private static final int DEF_MAX_CONNECTIONS = 100;
    private static final int DEF_TIME_TO_WAIT_FOR_CONNECTION = 60;
    private static final int DEF_CONNECTION_LIFETIME = 0;
    private static final int DEF_RUN_CLEANUP_THREAD = 0;
    private int maxConnections;
    private int timeToWaitForConnection;
    private ContainerInfo containerInfo;
    private DeployCommunicator deployCommunicator;
    private ApplicationServiceContext serviceContext;
    private DeployService deploy;
    private ConfigurationHandler configurationHandler;
    private ArrayList libraries;
    private String rootDir;
    private Hashtable runtimeUpdateCache;
    private Hashtable appsCache;
    private HashMap initQueues = new HashMap();
    private HashMap queues = new HashMap();
    private HashMap initTopics = new HashMap();
    private HashMap topics = new HashMap();
    private Object destMonitor = new Object();
    private HashSet aliasSet = new HashSet();
    private HashSet namingSet = new HashSet();
    private static final byte[] XML_1 = "<provider-descriptor><display-name>".getBytes();
    private static final byte[] XML_2 = "</display-name><component-name>".getBytes();
    private static final byte[] XML_3 = "</component-name><major-version>1</major-version><minor-version>1</minor-version><micro-version>1</micro-version><provider-name>sap.com</provider-name><references><reference type=\"library\" strength=\"weak\">jms</reference></references><jars>".getBytes();
    private static final byte[] XML_4 = "<jar-name>".getBytes();
    private static final byte[] XML_5 = "</jar-name>".getBytes();
    private static final byte[] XML_6 = "</jars></provider-descriptor>".getBytes();

    public ContainerImpl(ApplicationServiceContext serviceContext) throws RemoteException, NamingException, ConfigurationException {
        this.serviceContext = serviceContext;
        this.containerInfo = new ContainerInfo();
        this.containerInfo.setName(CONTAINER_NAME);
        this.containerInfo.setModuleName(CONTAINER_NAME);
        this.containerInfo.setJ2EEContainer(false);
        this.containerInfo.setFileNames(new String[]{JMS_CONNECTIONS_FILENAME, JMS_DESTINATIONS_FILENAME, "META-INF/jms-factories.xml", "META-INF/jms-destinations.xml"});
        this.containerInfo.setServiceName(serviceContext.getServiceState().getServiceName());
        this.containerInfo.setResourceTypes(RESOURCE_TYPES);
        this.containerInfo.setPriority(90);
        this.containerInfo.setSupportingSingleFileUpdate(false);
        this.appsCache = new Hashtable();
        this.runtimeUpdateCache = new Hashtable();
        this.rootDir = serviceContext.getServiceState().getWorkingDirectoryName();
        this.configurationHandler = serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        String name = null;
        try {
            name = XMLParser.parseJmsXml((InputStream)new FileInputStream((File)standaloneFile)).applicationName;
        }
        catch (Exception e) {
            throw new BaseDeploymentException("jmsconnector_0004", standaloneFile.getAbsolutePath(), (Throwable)e);
        }
        if (name == null) {
            throw new BaseDeploymentException("jmsconnector_0005", standaloneFile.getAbsolutePath());
        }
        return name.replace('/', '~');
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException {
        ApplicationInfo applicationInfoHelp;
        ApplicationInfo applicationInfo;
        String appName = deployInfo.getApplicationName();
        boolean isStandAlone = deployInfo.isStandAloneArchive();
        String logPrefix = "JMS Connector Container Application: " + appName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " start deploying.");
        if (archiveFiles.length == 1) {
            ApplicationInfo applicationInfo2;
            File deployFile = archiveFiles[0];
            try {
                applicationInfo2 = XMLParser.parseJmsXml(new FileInputStream(deployFile));
            }
            catch (Exception e) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error parsing " + deployFile.getAbsolutePath(), (Throwable)e);
                throw new BaseDeploymentException("jmsconnector_0004", deployFile.getAbsolutePath(), (Throwable)e);
            }
            applicationInfo2.applicationName = appName;
            applicationInfo2.isStandAlone = isStandAlone;
            try {
                Configuration configuration = deployInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME);
                ContainerImpl.saveSecureFile(configuration, applicationInfo2.type == 0 ? JMS_CONNECTIONS_FILENAME : JMS_DESTINATIONS_FILENAME, deployFile);
                configuration.addConfigEntry(STAND_ALONE, new Boolean(isStandAlone));
                configuration.addConfigEntry(APPLICATION_TYPE, new Integer(applicationInfo2.type));
            }
            catch (ConfigurationException cex) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " configuration error:", (Throwable)((Object)cex));
                throw new BaseDeploymentException("jmsconnector_0007", (Throwable)((Object)cex));
            }
            catch (IOException ioex) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " IO error: " + deployFile.getAbsolutePath() + ". ", (Throwable)ioex);
                throw new BaseDeploymentException("jmsconnector_0006", new Object[]{deployFile.getAbsolutePath(), "Configuration"}, (Throwable)ioex);
            }
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " deploy completed successfully.");
            return this.makeDeployInfo(applicationInfo2, props);
        }
        String jmsFactoriesFile = null;
        String jmsDestnationsFile = null;
        int i = 0;
        while (i < archiveFiles.length) {
            if (archiveFiles[i].getName().endsWith(JMS_CONNECTIONS_FILENAME)) {
                if (jmsFactoriesFile != null) {
                    Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " " + JMS_CONNECTIONS_FILENAME + " found in root and in the \\META-INF " + jmsFactoriesFile + " " + archiveFiles[i].getPath());
                    throw new BaseDeploymentException("jmsconnector_0044", new Object[]{JMS_CONNECTIONS_FILENAME, jmsFactoriesFile, archiveFiles[i].getPath()});
                }
                jmsFactoriesFile = archiveFiles[i].getPath();
            } else {
                if (jmsDestnationsFile != null) {
                    Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " " + JMS_DESTINATIONS_FILENAME + " found in root and in the \\META-INF " + jmsDestnationsFile + " " + archiveFiles[i].getPath());
                    throw new BaseDeploymentException("jmsconnector_0044", new Object[]{JMS_DESTINATIONS_FILENAME, jmsDestnationsFile, archiveFiles[i].getPath()});
                }
                jmsDestnationsFile = archiveFiles[i].getPath();
            }
            ++i;
        }
        File deployFile1 = archiveFiles[0];
        File deployFile2 = archiveFiles[1];
        File temp = deployFile1;
        try {
            applicationInfo = XMLParser.parseJmsXml(new FileInputStream(deployFile1));
            temp = deployFile2;
            applicationInfoHelp = XMLParser.parseJmsXml(new FileInputStream(deployFile2));
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error parsing " + temp.getAbsolutePath() + ": ", (Throwable)e);
            throw new BaseDeploymentException("jmsconnector_0004", temp.getAbsolutePath(), (Throwable)e);
        }
        if (applicationInfo.type == applicationInfoHelp.type) {
            Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " wrong file types " + Integer.toString(applicationInfo.type));
            throw new BaseDeploymentException("jmsconnector_0009", Integer.toString(applicationInfo.type));
        }
        if (applicationInfo.type == 0) {
            if (!deployFile1.getName().equalsIgnoreCase(JMS_CONNECTIONS_FILENAME)) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " " + deployFile1.getName() + " contains wrong information about factories.");
                throw new BaseDeploymentException("jmsconnector_0037", new Object[]{deployFile1.getName(), JMS_CONNECTIONS_FILENAME});
            }
        } else if (!deployFile1.getName().equalsIgnoreCase(JMS_DESTINATIONS_FILENAME)) {
            Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " " + deployFile1.getName() + " contains wrong information about destinations.");
            throw new BaseDeploymentException("jmsconnector_0037", new Object[]{deployFile1.getName(), JMS_DESTINATIONS_FILENAME});
        }
        try {
            Configuration configuration = deployInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME);
            temp = deployFile1;
            ContainerImpl.saveSecureFile(configuration, applicationInfo.type == 0 ? JMS_CONNECTIONS_FILENAME : JMS_DESTINATIONS_FILENAME, deployFile1);
            temp = deployFile2;
            ContainerImpl.saveSecureFile(configuration, applicationInfoHelp.type == 0 ? JMS_CONNECTIONS_FILENAME : JMS_DESTINATIONS_FILENAME, deployFile2);
            configuration.addConfigEntry(STAND_ALONE, new Boolean(isStandAlone));
            configuration.addConfigEntry(APPLICATION_TYPE, new Integer(2));
        }
        catch (ConfigurationException cex) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " configuration error: ", (Throwable)((Object)cex));
            throw new BaseDeploymentException("jmsconnector_0007", (Throwable)((Object)cex));
        }
        catch (IOException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " IO error: " + temp.getAbsolutePath() + " ", (Throwable)e);
            throw new BaseDeploymentException("jmsconnector_0006", new Object[]{temp.getAbsolutePath(), "Configuration"}, (Throwable)e);
        }
        if (applicationInfo.type == 0) {
            applicationInfo.destinationsDescriptors = applicationInfoHelp.destinationsDescriptors;
        } else {
            applicationInfo.factoryDescriptors = applicationInfoHelp.factoryDescriptors;
        }
        applicationInfo.applicationName = appName;
        applicationInfo.type = 2;
        applicationInfo.isStandAlone = isStandAlone;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " deploy completed successfully.");
        return this.makeDeployInfo(applicationInfo, props);
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException {
        WarningException we = null;
        try {
            this.remove(deployInfo.getApplicationName());
        }
        catch (WarningException _we) {
            we = _we;
        }
        try {
            deployInfo.getConfiguration().deleteConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "configuration error: ", (Throwable)((Object)cex));
        }
        if (archiveFiles != null && archiveFiles.length > 0) {
            ApplicationDeployInfo appDeployInfo = this.deploy(archiveFiles, deployInfo, props);
            if (we != null) {
                appDeployInfo.addWarnings(we.getWarnings());
            }
            return appDeployInfo;
        }
        return null;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void prepareStart(String appName, Configuration appConfig) throws DeploymentException, WarningException {
        Comparable descr;
        Iterator i;
        String logPrefix = "JMS Connector Container Application: " + appName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " starting...");
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.loadApplicationFromConfiguration(appName, appConfig.getSubConfiguration(CONTAINER_NAME));
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " cannot load application from configuration: ", (Throwable)e);
            throw new BaseDeploymentException("jmsconnector_0010", appName, (Throwable)e);
        }
        this.appsCache.put(appName, applicationInfo);
        if (applicationInfo.factoryDescriptors != null) {
            i = ((AbstractList)applicationInfo.factoryDescriptors).iterator();
            while (i.hasNext()) {
                descr = (ConnectionFactoryDescriptor)i.next();
                this.loadFactory((ConnectionFactoryDescriptor)descr, appName, applicationInfo.isStandAlone);
            }
        }
        if (applicationInfo.destinationsDescriptors != null) {
            i = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
            while (i.hasNext()) {
                descr = (DestinationDescriptor)i.next();
                this.loadDestination((DestinationDescriptor)descr, appName);
            }
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
    }

    public void commitStart(String applicationName) throws WarningException {
    }

    public void rollbackStart(String applicationName) throws WarningException {
        JMSConnectorResourceAccessor.location.logT(300, "Application: " + applicationName + " rollback started.");
        this.clearAllResources(applicationName);
    }

    public void prepareStop(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
        JMSConnectorResourceAccessor.location.logT(300, "Application: " + applicationName + " commit stop.");
        this.clearAllResources(applicationName);
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public File[] getClientJar(String applicationName) {
        return null;
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return null;
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        JMSConnectorResourceAccessor.location.logT(300, "Application: " + applicationName + " commitRuntimeChanges.");
        return this.makeDeployInfo((ApplicationInfo)this.runtimeUpdateCache.remove(applicationName), new Properties());
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public void deployJmsLibrary(String libraryName, SerializableFile[] libFiles) throws RemoteException, JMSConnectorException {
        File file = new File(this.rootDir + File.separatorChar + libraryName);
        file.delete();
        String logPrefix = "JMS Connector Container Library: " + libraryName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " deploing...");
        try {
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(file));
            byte[] name = libraryName.getBytes();
            ContainerImpl.addXmlToJar("alone/provider.xml", name, jarOut, libFiles);
            ContainerImpl.addXmlToJar("server/provider.xml", name, jarOut, libFiles);
            int i = 0;
            while (i < libFiles.length) {
                JarEntry entry = new JarEntry(libFiles[i].getFileName());
                jarOut.putNextEntry(entry);
                jarOut.write(libFiles[i].getBytes());
                jarOut.closeEntry();
                ++i;
            }
            jarOut.close();
        }
        catch (IOException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " IO error: ", (Throwable)e);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        try {
            this.deploy.deployLibrary(file.getAbsolutePath());
        }
        catch (RemoteException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " deploy error: ", (Throwable)e);
            throw e;
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    private static final void addXmlToJar(String xmlName, byte[] libraryName, JarOutputStream jarOut, SerializableFile[] libFiles) throws IOException {
        JarEntry entry = new JarEntry(xmlName);
        jarOut.putNextEntry(entry);
        jarOut.write(XML_1);
        jarOut.write(libraryName);
        jarOut.write(XML_2);
        jarOut.write(libraryName);
        jarOut.write(XML_3);
        int i = 0;
        while (i < libFiles.length) {
            jarOut.write(XML_4);
            jarOut.write(libFiles[i].getFileName().getBytes());
            jarOut.write(XML_5);
            ++i;
        }
        jarOut.write(XML_6);
        jarOut.closeEntry();
    }

    public void undeployJmsLibrary(String libraryName) throws RemoteException {
        this.deploy.removeLibrary(libraryName);
    }

    public void defineJmsLibrary(String libraryName) throws RemoteException, JMSConnectorException {
        String logPrefix = "JMS Connector Container Library: " + libraryName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " defining...");
        if (this.deploy.getServerLibraries().get(libraryName) == null) {
            Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " cannot define undeployed library.");
            throw new JMSConnectorException("jmsconnector_0018", libraryName);
        }
        try {
            if (this.libraries == null) {
                this.libraries = this.loadJmsLibraries();
            }
            if (this.libraries.contains(libraryName)) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " alredy defined.");
                JMSConnectorException exc = new JMSConnectorException("jmsconnector_0019", libraryName);
                exc.log();
                throw exc;
            }
            this.libraries.add(libraryName);
            this.updateConfigEntry(DEFINED_LIBS, this.libraries);
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " configuration error: ", (Throwable)((Object)e));
            throw new JMSConnectorException("jmsconnector_0023", (Throwable)((Object)e));
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    private ArrayList loadJmsLibraries() throws ConfigurationException {
        ArrayList libs = (ArrayList)this.getConfigEntry(DEFINED_LIBS);
        if (libs == null) {
            return new ArrayList();
        }
        return libs;
    }

    public void undefineJmsLibrary(String libraryName) throws JMSConnectorException {
        try {
            if (this.libraries == null) {
                this.libraries = this.loadJmsLibraries();
            }
            if (!this.libraries.contains(libraryName)) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, "undefineJmsLibrary() " + libraryName + " is not defined.");
                throw new JMSConnectorException("jmsconnector_0020", libraryName);
            }
            ((AbstractCollection)this.libraries).remove(libraryName);
            this.updateConfigEntry(DEFINED_LIBS, this.libraries);
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "undefineJmsLibrary() " + libraryName + " error: ", (Throwable)((Object)e));
            throw new JMSConnectorException("jmsconnector_0023", (Throwable)((Object)e));
        }
    }

    public ArrayList getAllJmsLibraries() throws RemoteException, JMSConnectorException {
        try {
            if (this.libraries == null) {
                this.libraries = this.loadJmsLibraries();
            }
            Hashtable allLibs = this.deploy.getServerLibraries();
            boolean isChanged = false;
            int i = 0;
            while (i < this.libraries.size()) {
                if (allLibs.get(this.libraries.get(i)) == null) {
                    isChanged = true;
                    this.libraries.remove(i);
                    continue;
                }
                ++i;
            }
            if (isChanged) {
                this.updateConfigEntry(DEFINED_LIBS, this.libraries);
            }
            return this.libraries;
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "getAllJmsLibraries() error: ", (Throwable)((Object)e));
            throw new JMSConnectorException("jmsconnector_0023", (Throwable)((Object)e));
        }
    }

    public Hashtable getServerLibraries() throws RemoteException {
        return this.deploy.getServerLibraries();
    }

    public void deployJmsResource(SerializableFile xmlFile) throws RemoteException, JMSConnectorException {
        File file = new File(this.rootDir + File.separatorChar + xmlFile.getFileName());
        file.delete();
        String logPrefix = "JMS Connector Container File: " + file.getAbsoluteFile();
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " deploy...");
        try {
            RandomAccessFile out = new RandomAccessFile(file, "rw");
            out.write(xmlFile.getBytes());
            out.close();
        }
        catch (IOException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " IO error: ", (Throwable)e);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        Properties props = new Properties();
        props.setProperty("isStandAlone", "true");
        try {
            String[] depInfo = this.deploy.deploy(file.getAbsolutePath(), CONTAINER_NAME, null, props);
            String appName = depInfo[0].substring("Application : ".length());
            this.deployCommunicator.startApplicationAndWait(appName);
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
        }
        catch (WarningException e) {
            Category.SYS_SERVER.logThrowableT(400, JMSConnectorResourceAccessor.location, logPrefix + " ", (Throwable)e);
            this.deployCommunicator.startApplicationAndWait(e.getResult()[0].substring("Application : ".length()));
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
            throw e;
        }
    }

    public void undeployJmsResource(String applicationName) throws RemoteException {
        this.deploy.remove(applicationName);
    }

    public ArrayList getAllApplications() throws JMSConnectorException {
        String[] apps = this.deployCommunicator.getMyApplications();
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>();
        if (apps == null) {
            return result;
        }
        Configuration configuration = null;
        try {
            int i = 0;
            while (i < apps.length) {
                String app = apps[i];
                ApplicationInfo applicationInfo = (ApplicationInfo)this.appsCache.get(app);
                if (applicationInfo == null) {
                    if (configuration == null) {
                        configuration = this.configurationHandler.openConfiguration(ROOT_CONF, 0);
                    }
                    Configuration appConf = configuration.getSubConfiguration(app + '/' + CONTAINER_NAME);
                    applicationInfo = this.loadApplicationFromConfiguration(app, appConf);
                }
                applicationInfo.status = this.deployCommunicator.getStatus(app);
                result.add(applicationInfo);
                ++i;
            }
            if (configuration != null) {
                configuration.close();
            }
        }
        catch (Exception e) {
            JMSConnectorResourceAccessor.location.traceThrowableT(500, "getAllApplications() error: ", (Throwable)e);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        return result;
    }

    public void createAndDeployDestination(String applicationName, String factoryName, String destinationName, String user, String password) throws RemoteException, JMSConnectorException {
        String logPrefix = "JMS Connector Container Application: " + applicationName + " component: " + destinationName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " create and deploy destination...");
        File file = new File(this.rootDir + File.separatorChar + "tmp.xml");
        file.delete();
        ArrayList<DestinationDescriptor> descr = new ArrayList<DestinationDescriptor>(1);
        descr.add(new DestinationDescriptor(destinationName, factoryName, user, password, ""));
        try {
            XMLParser.generateDestinationXML(applicationName, descr, file.getAbsolutePath());
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error generating xml: ", (Throwable)e);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        Properties props = new Properties();
        props.setProperty("isStandAlone", "true");
        try {
            String[] depInfo = this.deploy.deploy(file.getAbsolutePath(), CONTAINER_NAME, null, props);
            String appName = depInfo[0].substring("Application : ".length());
            this.deployCommunicator.startApplicationAndWait(appName);
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
        }
        catch (WarningException e) {
            Category.SYS_SERVER.logThrowableT(400, JMSConnectorResourceAccessor.location, logPrefix + " ", (Throwable)e);
            String[] depInfo = e.getResult();
            String appName = depInfo[0].substring("Application : ".length());
            this.deployCommunicator.startApplicationAndWait(appName);
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
            throw e;
        }
    }

    public void startApplication(String applicationName, boolean global) throws RemoteException {
        if (global) {
            this.deployCommunicator.startApplicationAndWait(applicationName);
        } else {
            this.deployCommunicator.startApplicationLocalAndWait(applicationName);
        }
    }

    public void stopApplication(String applicationName, boolean global) throws RemoteException {
        if (global) {
            this.deployCommunicator.stopApplicationAndWait(applicationName);
        } else {
            this.deployCommunicator.stopApplicationLocalAndWait(applicationName);
        }
    }

    public void updateComponent(ApplicationInfo applicationInfo, Object component) throws RemoteException, JMSConnectorException {
        String appName = applicationInfo.applicationName;
        String logPrefix = "JMS Connector Container Application: " + appName + " component: " + component;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " updating...");
        try {
            Configuration conf = this.deployCommunicator.startRuntimeChanges(appName).getSubConfiguration(CONTAINER_NAME);
            String workDir = this.getAppWorkDir(appName);
            new File(workDir).mkdirs();
            if (component instanceof ConnectionFactoryDescriptor) {
                int i = 0;
                while (i < applicationInfo.factoryDescriptors.size()) {
                    if (component.toString().equals(applicationInfo.factoryDescriptors.get(i).toString())) {
                        applicationInfo.factoryDescriptors.set(i, component);
                        break;
                    }
                    ++i;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateFactoryXML(appName, applicationInfo.factoryDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_CONNECTIONS_FILENAME, buffer.toByteArray());
            } else {
                int i = 0;
                while (i < applicationInfo.destinationsDescriptors.size()) {
                    if (component.toString().equals(applicationInfo.destinationsDescriptors.get(i).toString())) {
                        applicationInfo.destinationsDescriptors.set(i, component);
                        break;
                    }
                    ++i;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateDestinationXML(appName, applicationInfo.destinationsDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_DESTINATIONS_FILENAME, buffer.toByteArray());
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error updating component: ", (Throwable)e);
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        this.runtimeUpdateCache.put(appName, applicationInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    public void removeComponent(ApplicationInfo applicationInfo, Object component) throws RemoteException, JMSConnectorException {
        String appName = applicationInfo.applicationName;
        String logPrefix = "JMS Connector Container Application: " + appName + " component: " + component;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " removing...");
        try {
            Configuration conf = this.deployCommunicator.startRuntimeChanges(appName).getSubConfiguration(CONTAINER_NAME);
            String workDir = this.getAppWorkDir(appName);
            new File(workDir).mkdirs();
            if (component instanceof ConnectionFactoryDescriptor) {
                ((AbstractCollection)applicationInfo.factoryDescriptors).remove(component);
                if (applicationInfo.factoryDescriptors.size() == 0) {
                    throw new BaseDeploymentException("jmsconnector_0011");
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateFactoryXML(appName, applicationInfo.factoryDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_CONNECTIONS_FILENAME, buffer.toByteArray());
            } else {
                ((AbstractCollection)applicationInfo.destinationsDescriptors).remove(component);
                if (applicationInfo.destinationsDescriptors.size() == 0) {
                    throw new BaseDeploymentException("jmsconnector_0011");
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateDestinationXML(appName, applicationInfo.destinationsDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_DESTINATIONS_FILENAME, buffer.toByteArray());
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error removing component: ", (Throwable)e);
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        this.runtimeUpdateCache.put(appName, applicationInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    public void addComponent(ApplicationInfo applicationInfo, Object component) throws RemoteException, JMSConnectorException {
        String appName = applicationInfo.applicationName;
        String logPrefix = "JMS Connector Container Application: " + appName + " component: " + component;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " adding...");
        try {
            Configuration conf = this.deployCommunicator.startRuntimeChanges(appName).getSubConfiguration(CONTAINER_NAME);
            String workDir = this.getAppWorkDir(appName);
            new File(workDir).mkdirs();
            if (component instanceof ConnectionFactoryDescriptor) {
                int i = 0;
                while (i < applicationInfo.factoryDescriptors.size()) {
                    if (component.toString().equals(applicationInfo.factoryDescriptors.get(i).toString())) {
                        throw new BaseDeploymentException("jmsconnector_0021", component);
                    }
                    ++i;
                }
                applicationInfo.factoryDescriptors.add(component);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateFactoryXML(appName, applicationInfo.factoryDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_CONNECTIONS_FILENAME, buffer.toByteArray());
            } else {
                int i = 0;
                while (i < applicationInfo.destinationsDescriptors.size()) {
                    if (component.toString().equals(applicationInfo.destinationsDescriptors.get(i).toString())) {
                        throw new BaseDeploymentException("jmsconnector_0021", component);
                    }
                    ++i;
                }
                applicationInfo.destinationsDescriptors.add(component);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XMLParser.generateDestinationXML(appName, applicationInfo.destinationsDescriptors, buffer);
                ContainerImpl.updateSecureFile(conf, JMS_DESTINATIONS_FILENAME, buffer.toByteArray());
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error adding component: ", (Throwable)e);
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        this.runtimeUpdateCache.put(appName, applicationInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    public void deployComponent(String applicationName, Object descriptor) throws RemoteException, JMSConnectorException {
        File file;
        String[] apps = this.deployCommunicator.getDeployedApplications();
        applicationName = applicationName.replace('/', '~');
        String fullAppName = SAP_PREFIX + applicationName;
        String logPrefix = "JMS Connector Container Application: " + fullAppName + " component: " + descriptor;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " deploying...");
        int i = 0;
        while (i < apps.length) {
            if (apps[i].equals(fullAppName)) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " Application name already exists.");
                throw new JMSConnectorException("jmsconnector_0022", fullAppName);
            }
            ++i;
        }
        try {
            String workDir = this.getAppWorkDir("jmsconnector" + File.separatorChar + fullAppName);
            new File(workDir).mkdirs();
            String fileName = workDir + File.separatorChar + "standaloneapp.xml";
            file = new File(fileName);
            file.delete();
            ArrayList<Object> descr = new ArrayList<Object>();
            descr.add(descriptor);
            if (descriptor instanceof ConnectionFactoryDescriptor) {
                XMLParser.generateFactoryXML(applicationName, descr, fileName);
            } else {
                XMLParser.generateDestinationXML(applicationName, descr, fileName);
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error deploying component: ", (Throwable)e);
            throw new JMSConnectorException("jmsconnector_0023", e);
        }
        Properties props = new Properties();
        props.setProperty("isStandAlone", "true");
        try {
            try {
                this.deploy.deploy(file.getAbsolutePath(), CONTAINER_NAME, null, props);
            }
            catch (WarningException e) {
                Category.SYS_SERVER.logThrowableT(400, JMSConnectorResourceAccessor.location, logPrefix + " ", (Throwable)e);
                this.deployCommunicator.startApplicationAndWait(applicationName);
                JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
                throw e;
            }
            Object var12_13 = null;
            file.delete();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            file.delete();
            throw throwable;
        }
        this.deployCommunicator.startApplicationAndWait(applicationName);
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    private Configuration getRootConfig(int access) throws ConfigurationException {
        try {
            return this.configurationHandler.openConfiguration(CONTAINER_NAME, access);
        }
        catch (com.sap.engine.frame.core.configuration.NameNotFoundException e) {
            return this.configurationHandler.createRootConfiguration(CONTAINER_NAME);
        }
    }

    private void configCommit() throws ConfigurationException {
        this.configurationHandler.commit();
        this.configurationHandler.closeAllConfigurations();
    }

    private void updateConfigEntry(String name, Object obj) throws ConfigurationException {
        Configuration rootConfig = this.getRootConfig(1);
        try {
            rootConfig.modifyConfigEntry(name, obj, true);
            Object var5_4 = null;
            this.configCommit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.configCommit();
            throw throwable;
        }
    }

    private Object getConfigEntry(String name) throws ConfigurationException {
        Configuration rootConfig = this.getRootConfig(0);
        try {
            try {
                Object object = rootConfig.getConfigEntry(name);
                Object var6_5 = null;
                this.configCommit();
                return object;
            }
            catch (com.sap.engine.frame.core.configuration.NameNotFoundException e) {
                Object var4_8 = null;
                Object var6_6 = null;
                this.configCommit();
                return var4_8;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.configCommit();
            throw throwable;
        }
    }

    public void setDeployCommunicator(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    private final String getAppWorkDir(String applicationName) throws IOException {
        return this.deployCommunicator.getMyWorkDirectory(applicationName);
    }

    private ApplicationInfo loadApplicationFromConfiguration(String appName, Configuration appConfig) throws ConfigurationException, ParseXMLException, IOException, SAXException, BaseDeploymentException {
        boolean isStandAlone = (Boolean)appConfig.getConfigEntry(STAND_ALONE);
        int type = (Integer)appConfig.getConfigEntry(APPLICATION_TYPE);
        ApplicationInfo applicationInfo = null;
        switch (type) {
            case 2: {
                InputStream factoriesXml = ContainerImpl.getSecureFile(appConfig, JMS_CONNECTIONS_FILENAME);
                InputStream destinationsXml = ContainerImpl.getSecureFile(appConfig, JMS_DESTINATIONS_FILENAME);
                applicationInfo = XMLParser.parseJmsXml(factoriesXml);
                ApplicationInfo destApplicationInfo = XMLParser.parseJmsXml(destinationsXml);
                applicationInfo.destinationsDescriptors = destApplicationInfo.destinationsDescriptors;
                applicationInfo.type = 2;
                break;
            }
            case 1: {
                InputStream destinationsXml = ContainerImpl.getSecureFile(appConfig, JMS_DESTINATIONS_FILENAME);
                applicationInfo = XMLParser.parseJmsXml(destinationsXml);
                break;
            }
            case 0: {
                InputStream factoriesXml = ContainerImpl.getSecureFile(appConfig, JMS_CONNECTIONS_FILENAME);
                applicationInfo = XMLParser.parseJmsXml(factoriesXml);
                break;
            }
            default: {
                throw new BaseDeploymentException("jmsconnector_0008", Integer.toString(type));
            }
        }
        applicationInfo.isStandAlone = isStandAlone;
        applicationInfo.applicationName = appName;
        return applicationInfo;
    }

    private void clearAllResources(String applicationName) throws WarningException {
        String name;
        Comparable descr;
        Iterator i;
        Context ctx;
        String logPrefix = "JMS Connector Container Application: " + applicationName;
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " start clearing all memory structores...");
        ApplicationInfo applicationInfo = (ApplicationInfo)this.appsCache.remove(applicationName);
        if (applicationInfo == null) {
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
            return;
        }
        try {
            ctx = ContainerImpl.getInitialContext();
        }
        catch (NamingException _) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error getting initial context: ", (Throwable)_);
            throw new BaseWarningException("jmsconnector_0013", (Throwable)_);
        }
        if (applicationInfo.factoryDescriptors != null) {
            i = ((AbstractList)applicationInfo.factoryDescriptors).iterator();
            while (i.hasNext()) {
                boolean forRemove;
                descr = (ConnectionFactoryDescriptor)i.next();
                name = ((ConnectionFactoryDescriptor)descr).getFactoryName();
                HashSet hashSet = this.namingSet;
                synchronized (hashSet) {
                    forRemove = this.namingSet.remove(applicationName + name);
                }
                if (!forRemove) continue;
                try {
                    ResourceObjectFactory.removeConnectionFactory(name);
                }
                catch (ResourceException _) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_);
                }
                HashSet _ = this.aliasSet;
                synchronized (_) {
                    if (this.aliasSet.remove(applicationName + name)) {
                        ResourceObjectFactory.unregisterAliases(((ConnectionFactoryDescriptor)descr).getAliases());
                    }
                }
                try {
                    Context descrContext = (Context)ctx.lookup(DESCRIPTOR_NAMING);
                    ContainerImpl.unbind(descrContext, name);
                }
                catch (NamingException _2) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_2);
                }
                try {
                    Context mcfContext = (Context)ctx.lookup(MCF_NAMING);
                    ContainerImpl.unbind(mcfContext, name);
                }
                catch (NamingException _3) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_3);
                }
                try {
                    Context refContext = (Context)ctx.lookup(FACTORY_NAMING);
                    ContainerImpl.unbind(refContext, name);
                }
                catch (NamingException _4) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_4);
                }
            }
        }
        if (applicationInfo.destinationsDescriptors != null) {
            i = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
            while (i.hasNext()) {
                Context inCtx;
                HashMap apps;
                descr = (DestinationDescriptor)i.next();
                name = ((DestinationDescriptor)descr).getDestinationName();
                try {
                    Object forRemove = this.destMonitor;
                    synchronized (forRemove) {
                        apps = (HashMap)this.topics.get(name);
                        if (apps != null) {
                            apps.remove(applicationName);
                            if (apps.size() == 0) {
                                this.initTopics.remove(name);
                                inCtx = (Context)ctx.lookup(TOPIC_NAMING);
                                ContainerImpl.unbind(inCtx, name);
                                this.topics.remove(name);
                            }
                        }
                    }
                }
                catch (NamingException _) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_);
                }
                try {
                    Object _ = this.destMonitor;
                    synchronized (_) {
                        apps = (HashMap)this.queues.get(name);
                        if (apps != null) {
                            apps.remove(applicationName);
                            if (apps.size() == 0) {
                                this.initQueues.remove(name);
                                inCtx = (Context)ctx.lookup(QUEUE_NAMING);
                                ContainerImpl.unbind(inCtx, name);
                                this.queues.remove(name);
                            }
                        }
                    }
                }
                catch (NamingException _) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(300, logPrefix + " cannot remove " + name + " ", (Throwable)_);
                }
            }
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " done.");
    }

    private void loadDestination(DestinationDescriptor descr, String appName) throws DeploymentException {
        String logPrefix;
        block19: {
            String name = descr.getDestinationName();
            logPrefix = "JMS Connector Container Application: " + appName + " destination name: " + name;
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " start loading...");
            try {
                Context ctx = ContainerImpl.getInitialContext();
                ApplicationWork applicationWork = new ApplicationWork(ctx, FACTORY_NAMING + descr.getConnectionFactory());
                JMSConnectorResourceAccessor.location.logT(300, logPrefix + " lookup source factory: " + FACTORY_NAMING + descr.getConnectionFactory());
                ApplicationWork applicationWork2 = applicationWork;
                synchronized (applicationWork2) {
                    JMSConnectorFrame.getThreadSystem().startThread(applicationWork, false);
                    try {
                        applicationWork.wait();
                    }
                    catch (InterruptedException e) {
                        JMSConnectorResourceAccessor.location.catching((Throwable)e);
                    }
                }
                if (applicationWork.namingException != null) {
                    throw applicationWork.namingException;
                }
                Object factory = applicationWork.factory;
                if (factory instanceof QueueConnectionFactory) {
                    QueueConnectionFactory qFactory = (QueueConnectionFactory)factory;
                    QueueConnection connection = descr.getUserName().length() == 0 && descr.getPassword().length() == 0 ? qFactory.createQueueConnection() : qFactory.createQueueConnection(descr.getUserName(), descr.getPassword());
                    QueueSession session = connection.createQueueSession(false, 1);
                    Queue queue = session.createQueue(name);
                    connection.close();
                    Object object = this.destMonitor;
                    synchronized (object) {
                        HashMap<String, Queue> apps = (HashMap<String, Queue>)this.queues.get(name);
                        if (apps == null) {
                            this.initQueues.put(name, queue);
                            apps = new HashMap<String, Queue>();
                            this.queues.put(name, apps);
                        }
                        apps.put(appName, queue);
                        ContainerImpl.bind(ctx, QUEUE_NAMING + name, new DestinationWrapper(this.initQueues.get(name), apps), true);
                        break block19;
                    }
                }
                if (factory instanceof TopicConnectionFactory) {
                    TopicConnectionFactory tFactory = (TopicConnectionFactory)factory;
                    TopicConnection connection = descr.getUserName().length() == 0 && descr.getPassword().length() == 0 ? tFactory.createTopicConnection() : tFactory.createTopicConnection(descr.getUserName(), descr.getPassword());
                    TopicSession session = connection.createTopicSession(false, 1);
                    Topic topic = session.createTopic(descr.getDestinationName());
                    connection.close();
                    Object object = this.destMonitor;
                    synchronized (object) {
                        HashMap<String, Topic> apps = (HashMap<String, Topic>)this.topics.get(name);
                        if (apps == null) {
                            this.initTopics.put(name, topic);
                            apps = new HashMap<String, Topic>();
                            this.topics.put(name, apps);
                        }
                        apps.put(appName, topic);
                        ContainerImpl.bind(ctx, TOPIC_NAMING + name, new DestinationWrapper(this.initTopics.get(name), apps), true);
                        break block19;
                    }
                }
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " invalid factory type: " + descr.getConnectionFactory() + " " + factory.getClass().getName());
                throw new BaseDeploymentException("jmsconnector_0014", new Object[]{descr.getConnectionFactory(), factory.getClass().getName()});
            }
            catch (NamingException ne) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " naming error: ", (Throwable)ne);
                throw new BaseDeploymentException("jmsconnector_0013", (Throwable)ne);
            }
            catch (JMSException e) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " jms provider error: ", (Throwable)e);
                throw new BaseDeploymentException("jmsconnector_0015", (Throwable)e);
            }
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " loaded successful.");
    }

    private void loadFactory(ConnectionFactoryDescriptor connDescr, String applicatonName, boolean isStandAlone) throws DeploymentException {
        int transacted;
        String logPrefix;
        String name;
        Object linkFactory;
        block26: {
            linkFactory = null;
            name = connDescr.getFactoryName();
            logPrefix = "JMS Connector Container Application: " + applicatonName + " factory name: " + name;
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " start loading...");
            if (connDescr.hasNaming()) {
                JMSConnectorResourceAccessor.location.logT(300, logPrefix + " naming link factory: " + connDescr.getLinkFactoryName());
                Thread currentThread = Thread.currentThread();
                ClassLoader currentContextClassLoader = currentThread.getContextClassLoader();
                try {
                    try {
                        ClassLoader classLoader = this.getClassLoader(connDescr, logPrefix);
                        currentThread.setContextClassLoader(classLoader);
                        linkFactory = new InitialContext(connDescr.getContextProperties()).lookup(connDescr.getLinkFactoryName());
                    }
                    catch (NamingException _) {
                        Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error during lookup: ", (Throwable)_);
                        throw new BaseDeploymentException("jmsconnector_0013", (Throwable)_);
                    }
                    Object var11_12 = null;
                    currentThread.setContextClassLoader(currentContextClassLoader);
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    currentThread.setContextClassLoader(currentContextClassLoader);
                    throw throwable;
                }
            }
            String objectFactoryName = connDescr.getObjectFactoryName();
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " object factory name: " + objectFactoryName);
            Reference ref = new Reference(connDescr.getClassName(), objectFactoryName, "");
            Properties objectFactoryProperties = connDescr.getCreateFactoryProperties();
            Enumeration e = ((Hashtable)objectFactoryProperties).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = objectFactoryProperties.getProperty(key);
                ref.add(new StringRefAddr(key, val));
            }
            try {
                Class<?> cl = this.getClassLoader(connDescr, logPrefix).loadClass(objectFactoryName);
                linkFactory = ((ObjectFactory)cl.newInstance()).getObjectInstance(ref, null, null, new Hashtable());
            }
            catch (Exception cce) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " error loading class: ", (Throwable)cce);
                throw new BaseDeploymentException("jmsconnector_0016", (Throwable)cce);
            }
        }
        Reference ref = new Reference("com.sap.engine.services.jmsconnector.cci.ConnectionImpl", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
        if (linkFactory instanceof XATopicConnectionFactory) {
            connDescr.setFactoryType(3);
            transacted = 2;
            ref.add(new StringRefAddr("res-type", "javax.jms.XATopicConnectionFactory"));
        } else if (linkFactory instanceof XAQueueConnectionFactory) {
            connDescr.setFactoryType(4);
            transacted = 2;
            ref.add(new StringRefAddr("res-type", "javax.jms.XAQueueConnectionFactory"));
        } else if (linkFactory instanceof TopicConnectionFactory) {
            connDescr.setFactoryType(1);
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " the specified TopicConnectionFactory is not transactional, Transaction with messages will not work.");
            transacted = 1;
            ref.add(new StringRefAddr("res-type", "javax.jms.TopicConnectionFactory"));
        } else if (linkFactory instanceof QueueConnectionFactory) {
            connDescr.setFactoryType(2);
            JMSConnectorResourceAccessor.location.logT(300, logPrefix + " the specified QueueConnectionFactory is not transactional, Transaction with messages will not work.");
            transacted = 1;
            ref.add(new StringRefAddr("res-type", "javax.jms.QueueConnectionFactory"));
        } else {
            String linkClassName = linkFactory == null ? "null" : linkFactory.getClass().getName();
            Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " invalid factory type: " + linkClassName);
            throw new BaseDeploymentException("jmsconnector_0014", new Object[]{name, linkClassName});
        }
        ManagedConnectionFactoryImpl factory = new ManagedConnectionFactoryImpl((ConnectionFactory)linkFactory, connDescr);
        MCFWrapper wrapper = new MCFWrapper(factory, transacted, null, 0, this.maxConnections, this.timeToWaitForConnection, 0, 0);
        wrapper.setAliases(connDescr.getAliases());
        try {
            Context ctx = ContainerImpl.getInitialContext();
            ContainerImpl.bind(ctx, MCF_NAMING + name, wrapper, false);
            ref.add(new StringRefAddr("res-auth", "Application"));
            ref.add(new StringRefAddr("sharing-scope", "Shareable"));
            ref.add(new StringRefAddr("res-name", name));
            ContainerImpl.bind(ctx, FACTORY_NAMING + name, ref, false);
            ContainerImpl.bind(ctx, DESCRIPTOR_NAMING + name, connDescr, false);
            HashSet hashSet = this.namingSet;
            synchronized (hashSet) {
                this.namingSet.add(applicatonName + name);
            }
        }
        catch (NamingException _) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " naming error: ", (Throwable)_);
            throw new BaseDeploymentException("jmsconnector_0013", (Throwable)_);
        }
        try {
            ResourceObjectFactory.addConnectionFactory(applicatonName, name, connDescr.getFactoryTypeString(), false, isStandAlone);
            ResourceObjectFactory.startConnectionFactory(name);
            ResourceObjectFactory.registerAliases(name, connDescr.getAliases());
            HashSet _ = this.aliasSet;
            synchronized (_) {
                this.aliasSet.add(applicatonName + name);
            }
        }
        catch (ResourceException _) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, logPrefix + " resource error: ", (Throwable)_);
            throw new BaseDeploymentException("jmsconnector_0017", (Throwable)_);
        }
        JMSConnectorResourceAccessor.location.logT(300, logPrefix + " loaded successful.");
    }

    private final ClassLoader getClassLoader(ConnectionFactoryDescriptor connDescr, String logPrefix) {
        String lib = connDescr.getLibraryName();
        LoadContext classLoaderContext = this.serviceContext.getCoreContext().getLoadContext();
        if (lib == null || lib.length() == 0) {
            return this.getClass().getClassLoader();
        }
        ClassLoader classLoader = classLoaderContext.getClassLoader("library:" + lib);
        if (classLoader == null) {
            Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, logPrefix + " loader does not exist: " + lib + " . Using default class loader!!!");
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    private static final Context getInitialContext() throws NamingException {
        Properties props = new Properties();
        ((Hashtable)props).put("domain", "true");
        return new InitialContext(props);
    }

    private static final void bind(Context root, String name, Object obj, boolean rebind) throws NamingException {
        String s;
        Context ic = root;
        Context current = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                current = (Context)ic.lookup(s);
            }
            catch (NameNotFoundException e) {
                try {
                    current = ic.createSubcontext(s);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)ic.lookup(s);
                }
            }
            ic = current;
        }
        if (rebind) {
            ic.rebind(s, obj);
        } else {
            ic.bind(s, obj);
        }
    }

    private static final void unbind(Context root, String name) throws NamingException {
        int index = name.lastIndexOf(47);
        if (index == -1) {
            root.unbind(name);
        } else {
            ((Context)root.lookup(name.substring(0, index))).unbind(name.substring(index + 1));
            ContainerImpl.destroyContext(root, name.substring(0, index));
        }
    }

    private static void destroyContext(Context root, String contextName) throws NamingException {
        if (contextName.equals("")) {
            return;
        }
        int index = contextName.indexOf(47);
        try {
            if (index == -1) {
                root.destroySubcontext(contextName);
            } else {
                String s = contextName.substring(0, index);
                ContainerImpl.destroyContext((Context)root.lookup(contextName.substring(0, index)), contextName.substring(index + 1));
                root.destroySubcontext(s);
            }
        }
        catch (ContextNotEmptyException cne) {
            JMSConnectorResourceAccessor.location.traceThrowableT(300, "Context cannot be destroyed bacause it is not empty: " + contextName, (Throwable)cne);
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    private ApplicationDeployInfo makeDeployInfo(ApplicationInfo applicationInfo, Properties props) {
        Iterator iterator;
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        ArrayList<String> components = new ArrayList<String>();
        if (applicationInfo.factoryDescriptors != null) {
            iterator = ((AbstractList)applicationInfo.factoryDescriptors).iterator();
            while (iterator.hasNext()) {
                ConnectionFactoryDescriptor descr = (ConnectionFactoryDescriptor)iterator.next();
                components.add(descr.getFactoryName());
                String[] aliases = descr.getAliases();
                int i = 0;
                while (i < aliases.length) {
                    components.add(aliases[i]);
                    ++i;
                }
            }
        }
        if (applicationInfo.destinationsDescriptors != null) {
            iterator = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
            while (iterator.hasNext()) {
                components.add(((DestinationDescriptor)iterator.next()).getDestinationName());
            }
        }
        result.setDeployedComponentNames(components.toArray(new String[components.size()]));
        if (applicationInfo.destinationsDescriptors != null) {
            Iterator i;
            if (applicationInfo.factoryDescriptors != null) {
                i = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
                while (i.hasNext()) {
                    DestinationDescriptor descriptor = (DestinationDescriptor)i.next();
                    boolean isFound = false;
                    String name = descriptor.getConnectionFactory();
                    Iterator f = ((AbstractList)applicationInfo.factoryDescriptors).iterator();
                    while (f.hasNext()) {
                        if (!name.equals(((ConnectionFactoryDescriptor)f.next()).getFactoryName())) continue;
                        isFound = true;
                        break;
                    }
                    if (isFound) continue;
                    result.addResourceReference(name, RESOURCE_TYPES[0], "hard");
                }
            } else {
                i = ((AbstractList)applicationInfo.destinationsDescriptors).iterator();
                while (i.hasNext()) {
                    result.addResourceReference(((DestinationDescriptor)i.next()).getConnectionFactory(), RESOURCE_TYPES[0], "hard");
                }
            }
        }
        result.setDeployProperties(props);
        return result;
    }

    public void setProperties(Properties props) {
        String prop = props.getProperty(PROP_MAX_CONNECTIONS);
        try {
            this.maxConnections = Integer.parseInt(prop);
            if (this.maxConnections < 0) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, "maxConnections cannot be negative.");
                this.maxConnections = 100;
            }
        }
        catch (NumberFormatException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "JMS Connector Invalid property maxConnections: ", (Throwable)e);
            this.maxConnections = 100;
        }
        prop = props.getProperty(PROP_TIME_TO_WAIT_FOR_CONNECTION);
        try {
            this.timeToWaitForConnection = Integer.parseInt(prop);
            if (this.timeToWaitForConnection < 0) {
                Category.SYS_SERVER.logT(500, JMSConnectorResourceAccessor.location, "timeToWaitForConnection cannot be negative.");
                this.timeToWaitForConnection = 60;
            }
        }
        catch (NumberFormatException e) {
            Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "JMS Connector Invalid property 60: ", (Throwable)e);
            this.timeToWaitForConnection = 60;
        }
    }

    public DeployCommunicator getDeployCommunicator() {
        return this.deployCommunicator;
    }

    public void setDeployService(DeployService deployService) {
        this.deploy = deployService;
    }

    private static void saveSecureFile(Configuration database, String name, File deployFile) throws ConfigurationException, IOException {
        database = database.existsSubConfiguration(SECURE_SUB_CONFIGURATION) ? database.getSubConfiguration(SECURE_SUB_CONFIGURATION) : database.createSubConfiguration(SECURE_SUB_CONFIGURATION, 1);
        PropertySheet propertySheet = database.getPropertySheetInterface();
        byte[] data = new byte[(int)deployFile.length()];
        RandomAccessFile file = new RandomAccessFile(deployFile, "r");
        file.readFully(data);
        file.close();
        propertySheet.createSecurePropertyEntry(name, new String(data), name);
    }

    private static void updateSecureFile(Configuration database, String name, File deployFile) throws ConfigurationException, IOException {
        if (database.existsFile(name)) {
            database.deleteFile(name);
            Configuration sub = null;
            sub = !database.existsSubConfiguration(SECURE_SUB_CONFIGURATION) ? database.createSubConfiguration(SECURE_SUB_CONFIGURATION, 1) : database.getSubConfiguration(SECURE_SUB_CONFIGURATION);
            sub.getPropertySheetInterface().createSecurePropertyEntry(name, name, name);
        }
        database = database.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = database.getPropertySheetInterface();
        PropertyEntry entry = propertySheet.getPropertyEntry(name);
        byte[] data = new byte[(int)deployFile.length()];
        RandomAccessFile file = new RandomAccessFile(deployFile, "r");
        file.readFully(data);
        file.close();
        entry.setDefault(new String(data));
    }

    private static void updateSecureFile(Configuration database, String name, byte[] data) throws ConfigurationException {
        if (database.existsFile(name)) {
            database.deleteFile(name);
            Configuration sub = null;
            sub = !database.existsSubConfiguration(SECURE_SUB_CONFIGURATION) ? database.createSubConfiguration(SECURE_SUB_CONFIGURATION, 1) : database.getSubConfiguration(SECURE_SUB_CONFIGURATION);
            sub.getPropertySheetInterface().createSecurePropertyEntry(name, name, name);
        }
        database = database.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = database.getPropertySheetInterface();
        PropertyEntry entry = propertySheet.getPropertyEntry(name);
        entry.setDefault(new String(data));
    }

    private static InputStream getSecureFile(Configuration database, String name) throws ConfigurationException {
        if (database.existsFile(name)) {
            return database.getFile(name);
        }
        database = database.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = database.getPropertySheetInterface();
        PropertyEntry entry = propertySheet.getPropertyEntry(name);
        String data = (String)entry.getValue();
        return new ByteArrayInputStream(data.getBytes());
    }

    static class DestinationWrapper
    implements Serializable {
        static final long serialVersionUID = 7299862786252395962L;
        private HashMap destinations;
        private Object initDestination;

        public DestinationWrapper(Object initDestination, HashMap destinations) {
            this.initDestination = initDestination;
            this.destinations = destinations;
        }

        private Object readResolve() {
            ComponentExecutionContext context = JMSConnectorFrame.getComponentExecutionContext();
            if (context == null) {
                return this.initDestination;
            }
            if (JMSConnectorFrame.getThreadSystem().getThreadContext() == null) {
                return this.initDestination;
            }
            Object dest = this.destinations.get(context.getApplicationName());
            return dest == null ? this.initDestination : dest;
        }
    }

    private static class ApplicationWork
    implements Runnable {
        NamingException namingException;
        Context ctx;
        String name;
        Object factory;

        public ApplicationWork(Context ctx, String name) {
            this.ctx = ctx;
            this.name = name;
        }

        public synchronized void run() {
            try {
                this.factory = this.ctx.lookup(this.name);
            }
            catch (NamingException e) {
                this.namingException = e;
            }
            this.notify();
        }
    }
}

