/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.deploy;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConnectionFactoryDescriptor
implements Serializable,
Comparable {
    static final long serialVersionUID = 5453739069738006833L;
    public static final int NONE = 0;
    public static final int POOLED = 1;
    public static final int SHARED = 2;
    public static final int UNKNOW_TYPE = 0;
    public static final int TOPIC_TYPE = 1;
    public static final int QUEUE_TYPE = 2;
    public static final int XA_TOPIC_TYPE = 3;
    public static final int XA_QUEUE_TYPE = 4;
    private static final String[] TYPES = new String[]{"Unknown", "TopicConnectionFactory", "QueueConnectionFactory", "XATopicConnectionFactory", "XAQueueConnectionFactory"};
    private static final String NULL = "";
    private int mode = 0;
    private String description = "";
    private int factoryType;
    private String factoryName = "";
    private boolean hasNaming = false;
    private String linkFactoryName = "";
    private Properties contextProperties = new Properties();
    private String objectFactoryName = "";
    private String className = "";
    private Properties createFactoryProperties = new Properties();
    private String clientID = "";
    private String userName = "";
    private String password = "";
    private String libraryName = "";
    private String[] aliases = new String[0];
    private long expireTimeout;
    private int minConnections;
    private int maxConnections;
    private int timeToWait;

    public void setAliases(String[] ali) {
        this.aliases = ali;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setLibraryName(String name) {
        this.libraryName = name;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFactoryType(int factoryType) {
        this.factoryType = factoryType;
    }

    public int getFactoryType() {
        return this.factoryType;
    }

    public String getFactoryTypeString() {
        return TYPES[this.factoryType];
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String toString() {
        return this.factoryName;
    }

    public void setNaming(boolean hasNaming) {
        this.hasNaming = hasNaming;
    }

    public boolean hasNaming() {
        return this.hasNaming;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setLinkFactoryName(String linkFactoryName) {
        this.linkFactoryName = linkFactoryName;
    }

    public String getLinkFactoryName() {
        return this.linkFactoryName;
    }

    public void setContextProperties(Properties ctxProps) {
        this.contextProperties = ctxProps;
    }

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    public void setObjectFactoryName(String objectFactoryName) {
        this.objectFactoryName = objectFactoryName;
    }

    public String getObjectFactoryName() {
        return this.objectFactoryName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setCreateFactoryProperties(Properties createFactoryProperties) {
        this.createFactoryProperties = createFactoryProperties;
    }

    public Properties getCreateFactoryProperties() {
        return this.createFactoryProperties;
    }

    public long getExpireTimeout() {
        return this.expireTimeout;
    }

    public void setExpireTimeout(long expireTimeout) {
        this.expireTimeout = expireTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getTimeToWait() {
        return this.timeToWait;
    }

    public void setTimeToWait(int time) {
        this.timeToWait = time;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectionFactoryDescriptor)) {
            return false;
        }
        ConnectionFactoryDescriptor descr = (ConnectionFactoryDescriptor)obj;
        if (descr.description != null ? !descr.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (descr.libraryName != null ? !descr.libraryName.equals(this.libraryName) : this.libraryName != null) {
            return false;
        }
        if (descr.factoryName != null ? !descr.factoryName.equals(this.factoryName) : this.factoryName != null) {
            return false;
        }
        if (descr.clientID != null ? !descr.clientID.equals(this.clientID) : this.clientID != null) {
            return false;
        }
        if (descr.userName != null ? !descr.userName.equals(this.userName) : this.userName != null) {
            return false;
        }
        if (descr.password != null ? !descr.password.equals(this.password) : this.password != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(descr.aliases, this.aliases)) {
            return false;
        }
        if (descr.hasNaming != this.hasNaming) {
            return false;
        }
        if (descr.hasNaming) {
            if (descr.linkFactoryName != null ? !descr.linkFactoryName.equals(this.linkFactoryName) : this.linkFactoryName != null) {
                return false;
            }
            if (!EqualUtils.equalObjects(descr.contextProperties, this.contextProperties)) {
                return false;
            }
        } else {
            if (descr.objectFactoryName != null ? !descr.objectFactoryName.equals(this.objectFactoryName) : this.objectFactoryName != null) {
                return false;
            }
            if (descr.className != null ? !descr.className.equals(this.className) : this.className != null) {
                return false;
            }
            if (!EqualUtils.equalObjects(descr.createFactoryProperties, this.createFactoryProperties)) {
                return false;
            }
        }
        if (descr.mode != this.mode) {
            return false;
        }
        if (descr.mode == 1) {
            if (descr.expireTimeout != this.expireTimeout) {
                return false;
            }
            if (descr.minConnections != this.minConnections) {
                return false;
            }
            if (descr.maxConnections != this.maxConnections) {
                return false;
            }
            if (descr.timeToWait != this.timeToWait) {
                return false;
            }
        } else if (descr.mode == 2 && descr.expireTimeout != this.expireTimeout) {
            return false;
        }
        return true;
    }

    public Object clone() {
        ConnectionFactoryDescriptor cloning = new ConnectionFactoryDescriptor();
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.libraryName = this.libraryName == null ? null : new String(this.libraryName);
        cloning.factoryName = this.factoryName == null ? null : new String(this.factoryName);
        cloning.clientID = this.clientID == null ? null : new String(this.clientID);
        cloning.userName = this.userName == null ? null : new String(this.userName);
        String string = cloning.password = this.password == null ? null : new String(this.password);
        if (this.aliases == null) {
            cloning.aliases = null;
        } else {
            cloning.aliases = new String[this.aliases.length];
            int i = 0;
            while (i < this.aliases.length) {
                cloning.aliases[i] = this.aliases[i] == null ? null : new String(this.aliases[i]);
                ++i;
            }
        }
        cloning.hasNaming = this.hasNaming;
        if (this.hasNaming) {
            cloning.linkFactoryName = this.linkFactoryName;
            if (this.contextProperties == null) {
                cloning.contextProperties = null;
            } else {
                Properties newAddProps = new Properties();
                Enumeration enumeration = ((Hashtable)this.contextProperties).keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = (String)((Hashtable)this.contextProperties).get(key);
                    newAddProps.setProperty(new String(key), new String(value));
                }
                cloning.contextProperties = newAddProps;
            }
        } else {
            cloning.objectFactoryName = this.objectFactoryName;
            cloning.className = this.className;
            if (this.createFactoryProperties == null) {
                cloning.createFactoryProperties = null;
            } else {
                Properties newAddProps = new Properties();
                Enumeration enumeration = ((Hashtable)this.createFactoryProperties).keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = (String)((Hashtable)this.createFactoryProperties).get(key);
                    newAddProps.setProperty(new String(key), new String(value));
                }
                cloning.createFactoryProperties = newAddProps;
            }
        }
        cloning.mode = this.mode;
        if (this.mode == 1) {
            cloning.expireTimeout = this.expireTimeout;
            cloning.minConnections = this.minConnections;
            cloning.maxConnections = this.maxConnections;
            cloning.timeToWait = this.timeToWait;
        } else if (this.mode == 2) {
            cloning.expireTimeout = this.expireTimeout;
        }
        return cloning;
    }

    public int compareTo(Object o) {
        return this.factoryName.compareToIgnoreCase(((ConnectionFactoryDescriptor)o).factoryName);
    }
}

