/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class UndeployLibrary
implements Command {
    private ContainerImpl jmsManager;

    public UndeployLibrary(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "undeploy_jms_library";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        int i = 0;
        while (i < params.length) {
            try {
                this.jmsManager.undeployJmsLibrary(params[i]);
                out.println(params[i] + " unregistered.");
            }
            catch (Exception e) {
                out.println("Can not undeploy " + params[i]);
                out.println(e);
                e.printStackTrace(out);
            }
            ++i;
        }
        out.println("Commnd exits.");
    }

    public String getHelpMessage() {
        return "\nRemoves completely a JMS library previously deployed on J2EE Engine.\n\nUsage: UNDEPLOY_JMS_LIBRARY <libraryNames>\n\nParameters:\n\n     <libraryNames>     - the names of the JMS libraries to be unregistered\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

