/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class UndeployJmsResource
implements Command {
    private ContainerImpl jmsManager;

    public UndeployJmsResource(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "undeploy_jms_resource";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        out.println();
        int i = 0;
        while (i < params.length) {
            try {
                this.jmsManager.undeployJmsResource(params[i]);
                out.println(params[i] + " undeployed.");
            }
            catch (Exception e) {
                out.println("Can not undeploy " + params[i]);
                out.println(e);
                e.printStackTrace(out);
            }
            ++i;
        }
        out.println("Command exits.");
    }

    public String getHelpMessage() {
        return "\nRemoves the application and the JMS ConnectionFactory and Destination objects in it (if any).\n\nUsage: UNDEPLOY_JMS_RESOURCE <applicationNames>\n\nParameters:\n\n     <applicationNames>     - the names of the applications to be destroyed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

