/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class UndefineLibrary
implements Command {
    private ContainerImpl jmsManager;

    public UndefineLibrary(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "undefine_jms_library";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        int i = 0;
        while (i < params.length) {
            try {
                this.jmsManager.undefineJmsLibrary(params[i]);
            }
            catch (Exception e) {
                JMSConnectorResourceAccessor.location.traceThrowableT(100, "Error undefining library", (Throwable)e);
                out.println(e);
                e.printStackTrace(out);
            }
            ++i;
        }
        out.println("Command exits.");
    }

    public String getHelpMessage() {
        return "\nRemoves a library from the list of registered JMS libraries.\n\nUsage: UNDEFINE_JMS_LIBRARY <libraryNames>\n\nParameters:\n\n     <libraryNames>    - the names of one or more JMS libraries that you want to unregister\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

