/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DeployLibrary
implements Command {
    private ContainerImpl jmsManager;

    public DeployLibrary(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "deploy_jms_library";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        SerializableFile[] files = new SerializableFile[params.length - 1];
        int i = 1;
        while (i < params.length) {
            files[i - 1] = new SerializableFile(params[i]);
            ++i;
        }
        try {
            this.jmsManager.deployJmsLibrary(params[0], files);
        }
        catch (Exception e) {
            JMSConnectorResourceAccessor.location.traceThrowableT(100, "Error deploying library", (Throwable)e);
            out.println(e);
            e.printStackTrace(out);
        }
        out.println("Command exits.");
    }

    public String getHelpMessage() {
        return "\nRegisters a JMS library on J2EE Engine.\n\nUsage: DEPLOY_JMS_LIBRARY <libraryName><jarFiles>\n\nParameters:\n\n     <libraryName>  - an arbitrary name for the JMS library\n     <jarFiles>     - archive file(s) that contains the classes of the JMS library\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

