/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DeployJmsResource
implements Command {
    private ContainerImpl jmsManager;

    public DeployJmsResource(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "deploy_jms_resource";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        out.println();
        int i = 0;
        while (i < params.length) {
            try {
                this.jmsManager.deployJmsResource(new SerializableFile(params[i]));
                out.println(params[i] + " loaded.");
            }
            catch (WarningException we) {
                JMSConnectorResourceAccessor.location.traceThrowableT(300, "Jms resource deployed with warnings", (Throwable)we);
                out.println("Warning: " + we);
                out.println("Message: " + we.getMessage());
                out.println(params[i] + " loaded.");
            }
            catch (Exception e) {
                JMSConnectorResourceAccessor.location.traceThrowableT(100, "Error deploying jms resource", (Throwable)e);
                out.println("Can not deploy  " + params[i]);
                out.println(e);
                e.printStackTrace(out);
            }
            ++i;
        }
        out.println("Command exits.");
    }

    public String getHelpMessage() {
        return "\nDeploys a JMS ConnectionFactory or JMS Destination defined in the specified descriptor XML file.\n\nUsage: DEPLOY_JMS_RESOURCE <xmlFiles>\n\nParameters:\n\n     <xmlFiles>     - the paths to the XML files that describes the resource to be deployed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

