/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DeployDestination
implements Command {
    private ContainerImpl jmsManager;

    public DeployDestination(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "deploy_destination";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length < 3 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        out.println();
        try {
            this.jmsManager.createAndDeployDestination(params[0], params[1], params[2], params.length <= 3 ? "" : params[3], params.length <= 4 ? "" : params[4]);
        }
        catch (WarningException we) {
            JMSConnectorResourceAccessor.location.traceThrowableT(300, "Library deployed with warnings", (Throwable)we);
            out.println("Warning: " + we);
            out.println("Message: " + we.getMessage());
        }
        catch (Exception e) {
            JMSConnectorResourceAccessor.location.traceThrowableT(100, "Error deploying library", (Throwable)e);
            out.println(e);
            e.printStackTrace(out);
        }
        out.println("Command exits.");
    }

    public String getHelpMessage() {
        return "\nCreates a JMS Destination object with the specified parameters and deploys it on J2EE Engine.\n\nUsage: DEPLOY_DESTINATION <applicationName><factoryName><destinationName>[user][password]\n\nParameters:\n\n     <applicationName>    - name of the application to which the Destination object is associated\n     <factoryName>        - name of the used ConnectionFactory\n     <destinationName>    - destination object name\n     [user]               - user name (for JMS Provider security)\n     [password]           - password\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

