/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DefineLibrary
implements Command {
    private ContainerImpl jmsManager;

    public DefineLibrary(ContainerImpl manager) {
        this.jmsManager = manager;
    }

    public String getName() {
        return "define_jms_library";
    }

    public String getGroup() {
        return "jmsconnector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length == 0 || params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        int i = 0;
        while (i < params.length) {
            try {
                this.jmsManager.defineJmsLibrary(params[i]);
            }
            catch (Exception e) {
                JMSConnectorResourceAccessor.location.traceThrowableT(100, "Error defining library", (Throwable)e);
                out.println(e);
                e.printStackTrace(out);
            }
            ++i;
        }
        out.println("Commnd exits.");
    }

    public String getHelpMessage() {
        return "\nRegisters a previously deployed library as a JMS library.\n\nUsage: DEFINE_JMS_LIBRARY <libraryNames>\n\nParameters:\n\n     <libraryNames>     - the names of one or more libraries that you want to register as JMS libraries\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

