/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.cci.SessionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.SessionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicSessionImpl
extends SessionImpl
implements TopicSession {
    public TopicSessionImpl(Session session, SessionCloseEventListener closeEventListener) {
        super(session, closeEventListener);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        TopicSubscriber subscriber = ((TopicSession)this.session).createDurableSubscriber(topic, name);
        return subscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        TopicSubscriber subscriber = ((TopicSession)this.session).createDurableSubscriber(topic, name, messageSelector, noLocal);
        return subscriber;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        TopicPublisher publisher = ((TopicSession)this.session).createPublisher(topic);
        return publisher;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        TopicSubscriber subscriber = ((TopicSession)this.session).createSubscriber(topic);
        return subscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        TopicSubscriber subscriber = ((TopicSession)this.session).createSubscriber(topic, messageSelector, noLocal);
        return subscriber;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return ((TopicSession)this.session).createTemporaryTopic();
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return ((TopicSession)this.session).createTopic(topicName);
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        ((TopicSession)this.session).unsubscribe(name);
    }
}

