/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.TopicConnection2Impl;
import com.sap.engine.services.jmsconnector.cci.TopicConnectionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSException;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class TopicConnectionFactoryImpl
implements TopicConnectionFactory,
ConnectionCloseEventListener {
    protected static final Location location = JMSConnectorResourceAccessor.location;
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionManager connectionManager;
    private TopicConnectionFactory connectionFactory;
    private boolean isXA;
    private String user;
    private String password;
    private String clientID;
    private boolean isSonic = false;
    private Method sonicMethod;
    private static final String SONIC_FACTORY = "progress.message.jclient.xa.XATopicConnectionFactory";
    private static final String SONIC_METHOD = "getTopicConnection";

    public TopicConnectionFactoryImpl(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, TopicConnectionFactory connectionFactory, boolean isXA, String user, String password, String clientID) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.connectionFactory = connectionFactory;
        this.isXA = isXA;
        if (user.length() != 0) {
            this.user = user;
            this.password = password;
        }
        if (clientID.length() != 0) {
            this.clientID = clientID;
        }
        if (isXA && connectionFactory.getClass().getName().equals(SONIC_FACTORY)) {
            this.isSonic = true;
        }
        if (location.beLogged(100)) {
            location.logT(100, "TopicConnectionFactoryImpl.TopicConnectionFactoryImpl() isSonic = " + this.isSonic);
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        TopicConnection realConnection;
        if (location.beLogged(100)) {
            location.logT(100, "TopicConnectionFactoryImpl.createTopicConnection()");
        }
        if (this.user != null) {
            return this.createTopicConnection(this.user, this.password);
        }
        if (this.isSonic) {
            return this.createSonicTopicConnection();
        }
        Object object = realConnection = this.isXA ? ((XATopicConnectionFactory)this.connectionFactory).createXATopicConnection() : this.connectionFactory.createTopicConnection();
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
        }
        return new TopicConnectionImpl(realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        TopicConnection realConnection;
        if (location.beLogged(100)) {
            location.logT(100, "TopicConnectionFactoryImpl.createTopicConnection(String userName, String password)");
        }
        if (this.isSonic) {
            return this.createSonicTopicConnection(userName, password);
        }
        Object object = realConnection = this.isXA ? ((XATopicConnectionFactory)this.connectionFactory).createXATopicConnection(userName, password) : this.connectionFactory.createTopicConnection(userName, password);
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
        }
        return new TopicConnectionImpl(realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public void connectionClosed(Connection connection) throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "TopicConnectionFactoryImpl.connectionClosed()");
        }
        connection.close();
    }

    public TopicConnection createSonicTopicConnection() throws JMSException {
        XATopicConnection realXAConnection = ((XATopicConnectionFactory)this.connectionFactory).createXATopicConnection();
        TopicConnection realConnection = null;
        if (this.sonicMethod == null) {
            try {
                this.sonicMethod = realXAConnection.getClass().getDeclaredMethod(SONIC_METHOD, null);
            }
            catch (NoSuchMethodException e) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
                exc.log();
                throw exc;
            }
        }
        try {
            realConnection = (TopicConnection)this.sonicMethod.invoke((Object)realXAConnection, null);
        }
        catch (IllegalAccessException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        catch (InvocationTargetException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
            realXAConnection.setClientID(this.clientID);
        }
        return new TopicConnection2Impl((TopicConnection)realXAConnection, realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public TopicConnection createSonicTopicConnection(String userName, String password) throws JMSException {
        XATopicConnection realXAConnection = ((XATopicConnectionFactory)this.connectionFactory).createXATopicConnection(userName, password);
        TopicConnection realConnection = null;
        if (this.sonicMethod == null) {
            try {
                this.sonicMethod = realXAConnection.getClass().getDeclaredMethod(SONIC_METHOD, null);
            }
            catch (NoSuchMethodException e) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
                exc.log();
                throw exc;
            }
        }
        try {
            realConnection = (TopicConnection)this.sonicMethod.invoke((Object)realXAConnection, null);
        }
        catch (IllegalAccessException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        catch (InvocationTargetException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
            realXAConnection.setClientID(this.clientID);
        }
        return new TopicConnection2Impl((TopicConnection)realXAConnection, realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }
}

