/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.cci.Connection2Impl;
import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSException;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import com.sap.engine.services.jmsconnector.spi.ConnectionRequestInfoImpl;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class TopicConnection2Impl
extends Connection2Impl
implements TopicConnection {
    public TopicConnection2Impl(TopicConnection realXAConnection, TopicConnection realConnection, ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory, ConnectionCloseEventListener closeEventListener) throws JMSException {
        super((Connection)realXAConnection, (Connection)realConnection, connectionManager, managedConnectionFactory, closeEventListener);
    }

    public void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        super.close();
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        ConnectionConsumer result = ((TopicConnection)this.realConnection).createConnectionConsumer(topic, messageSelector, serverSessionPool, maxMessages);
        return result;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        ConnectionConsumer result = ((TopicConnection)this.realConnection).createDurableConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
        return result;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        TopicSession result = null;
        if (transacted) {
            ConnectionRequestInfoImpl reqInfo = new ConnectionRequestInfoImpl(this.realXAConnection, this);
            try {
                result = (TopicSession)this.connectionManager.allocateConnection(this.managedConnectionFactory, (ConnectionRequestInfo)reqInfo);
            }
            catch (ResourceException rex) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0035", (Throwable)rex);
                exc.log();
                throw exc;
            }
            this.sessions.add(result);
        } else {
            result = ((TopicConnection)this.realConnection).createTopicSession(transacted, acknowledgeMode);
        }
        return result;
    }
}

