/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.cci.SessionCloseEventListener;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class SessionImpl
implements Session,
ExceptionListener {
    protected static final Location location = JMSConnectorResourceAccessor.location;
    protected boolean isClosed;
    protected Session session;
    private SessionCloseEventListener closeEventListener;

    public SessionImpl(Session session, SessionCloseEventListener closeEventListener) {
        this.session = session;
        this.closeEventListener = closeEventListener;
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.SessionImpl()");
        }
    }

    public Session getSessionImpl() {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.getSessionImpl()");
        }
        return this.session;
    }

    public void onException(JMSException exception) {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.onException()");
        }
        ((ExceptionListener)this.closeEventListener).onException(exception);
    }

    public void close() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.close()");
        }
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.closeEventListener.sessionClosed(null);
    }

    public void commit() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.commit()");
        }
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        this.session.commit();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.getTransacted();
    }

    public void recover() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.recover()");
        }
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        this.session.recover();
    }

    public void rollback() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.rollback()");
        }
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        this.session.rollback();
    }

    public void run() {
        if (location.beLogged(100)) {
            location.logT(100, "SessionImpl.run()");
        }
        this.session.run();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        this.session.setMessageListener(messageListener);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String txt) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return this.session.createTextMessage(txt);
    }
}

