/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.cci.SessionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.SessionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;

public class QueueSessionImpl
extends SessionImpl
implements QueueSession {
    public QueueSessionImpl(Session session, SessionCloseEventListener closeEventListener) {
        super(session, closeEventListener);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        QueueBrowser browser = ((QueueSession)this.session).createBrowser(queue);
        return browser;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        QueueBrowser browser = ((QueueSession)this.session).createBrowser(queue, messageSelector);
        return browser;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return ((QueueSession)this.session).createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        QueueReceiver receiver = ((QueueSession)this.session).createReceiver(queue);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        QueueReceiver receiver = ((QueueSession)this.session).createReceiver(queue, messageSelector);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        QueueSender sender = ((QueueSession)this.session).createSender(queue);
        return sender;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0036");
            exc.log();
            throw exc;
        }
        return ((QueueSession)this.session).createTemporaryQueue();
    }
}

