/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.QueueConnection2Impl;
import com.sap.engine.services.jmsconnector.cci.QueueConnectionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSException;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class QueueConnectionFactoryImpl
implements QueueConnectionFactory,
ConnectionCloseEventListener {
    protected static final Location location = JMSConnectorResourceAccessor.location;
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionManager connectionManager;
    private QueueConnectionFactory connectionFactory;
    private boolean isXA;
    private String user;
    private String password;
    private String clientID;
    private boolean isSonic = false;
    private Method sonicMethod;
    private static final String SONIC_FACTORY = "progress.message.jclient.xa.XAQueueConnectionFactory";
    private static final String SONIC_METHOD = "getQueueConnection";

    public QueueConnectionFactoryImpl(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, QueueConnectionFactory connectionFactory, boolean isXA, String user, String password, String clientID) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.connectionFactory = connectionFactory;
        this.isXA = isXA;
        if (user.length() != 0) {
            this.user = user;
            this.password = password;
        }
        if (clientID.length() != 0) {
            this.clientID = clientID;
        }
        if (isXA && connectionFactory.getClass().getName().equals(SONIC_FACTORY)) {
            this.isSonic = true;
        }
        if (location.beLogged(100)) {
            location.logT(100, "QueueConnectionFactoryImpl.QueueConnectionFactoryImpl() isSonic = " + this.isSonic);
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        QueueConnection realConnection;
        if (location.beLogged(100)) {
            location.logT(100, "QueueConnectionFactoryImpl.createQueueConnection()");
        }
        if (this.user != null) {
            return this.createQueueConnection(this.user, this.password);
        }
        if (this.isSonic) {
            return this.createSonicQueueConnection();
        }
        Object object = realConnection = this.isXA ? ((XAQueueConnectionFactory)this.connectionFactory).createXAQueueConnection() : this.connectionFactory.createQueueConnection();
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
        }
        return new QueueConnectionImpl(realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        QueueConnection realConnection;
        if (location.beLogged(100)) {
            location.logT(100, "QueueConnectionFactoryImpl.createQueueConnection(String userName, String password)");
        }
        if (this.isSonic) {
            return this.createSonicQueueConnection(userName, password);
        }
        Object object = realConnection = this.isXA ? ((XAQueueConnectionFactory)this.connectionFactory).createXAQueueConnection(userName, password) : this.connectionFactory.createQueueConnection(userName, password);
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
        }
        return new QueueConnectionImpl(realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public void connectionClosed(Connection connection) throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "QueueConnectionFactoryImpl.connectionClosed()");
        }
        connection.close();
    }

    public QueueConnection createSonicQueueConnection() throws JMSException {
        XAQueueConnection realXAConnection = ((XAQueueConnectionFactory)this.connectionFactory).createXAQueueConnection();
        QueueConnection realConnection = null;
        if (this.sonicMethod == null) {
            try {
                this.sonicMethod = realXAConnection.getClass().getDeclaredMethod(SONIC_METHOD, null);
            }
            catch (NoSuchMethodException e) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
                exc.log();
                throw exc;
            }
        }
        try {
            realConnection = (QueueConnection)this.sonicMethod.invoke((Object)realXAConnection, null);
        }
        catch (IllegalAccessException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        catch (InvocationTargetException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
            realXAConnection.setClientID(this.clientID);
        }
        return new QueueConnection2Impl((QueueConnection)realXAConnection, realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }

    public QueueConnection createSonicQueueConnection(String userName, String password) throws JMSException {
        XAQueueConnection realXAConnection = ((XAQueueConnectionFactory)this.connectionFactory).createXAQueueConnection(userName, password);
        QueueConnection realConnection = null;
        if (this.sonicMethod == null) {
            try {
                this.sonicMethod = realXAConnection.getClass().getDeclaredMethod(SONIC_METHOD, null);
            }
            catch (NoSuchMethodException e) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
                exc.log();
                throw exc;
            }
        }
        try {
            realConnection = (QueueConnection)this.sonicMethod.invoke((Object)realXAConnection, null);
        }
        catch (IllegalAccessException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        catch (InvocationTargetException e) {
            BaseJMSException exc = new BaseJMSException("jmsconnector_0034", (Throwable)e);
            exc.log();
            throw exc;
        }
        if (this.clientID != null) {
            realConnection.setClientID(this.clientID);
            realXAConnection.setClientID(this.clientID);
        }
        return new QueueConnection2Impl((QueueConnection)realXAConnection, realConnection, this.connectionManager, this.managedConnectionFactory, (ConnectionCloseEventListener)this);
    }
}

