/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.cci.Connection2Impl;
import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSException;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import com.sap.engine.services.jmsconnector.spi.ConnectionRequestInfoImpl;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class QueueConnection2Impl
extends Connection2Impl
implements QueueConnection {
    public QueueConnection2Impl(QueueConnection realXAConnection, QueueConnection realConnection, ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory, ConnectionCloseEventListener closeEventListener) throws JMSException {
        super((Connection)realXAConnection, (Connection)realConnection, connectionManager, managedConnectionFactory, closeEventListener);
    }

    public void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        super.close();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        ConnectionConsumer result = ((QueueConnection)this.realConnection).createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
        return result;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        QueueSession result = null;
        if (transacted) {
            ConnectionRequestInfoImpl reqInfo = new ConnectionRequestInfoImpl(this.realXAConnection, this);
            try {
                result = (QueueSession)this.connectionManager.allocateConnection(this.managedConnectionFactory, (ConnectionRequestInfo)reqInfo);
            }
            catch (ResourceException rex) {
                BaseJMSException exc = new BaseJMSException("jmsconnector_0033", (Throwable)rex);
                exc.log();
                throw exc;
            }
            this.sessions.add(result);
        } else {
            if (acknowledgeMode == 0) {
                acknowledgeMode = 1;
            }
            result = ((QueueConnection)this.realConnection).createQueueSession(transacted, acknowledgeMode);
        }
        return result;
    }
}

