/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionImpl
implements Connection,
ExceptionListener {
    protected static final Location location = JMSConnectorResourceAccessor.location;
    protected Connection realConnection;
    protected ConnectionManager connectionManager;
    protected ManagedConnectionFactory managedConnectionFactory;
    protected boolean isClosed;
    protected int transactedSessions;
    protected ArrayList sessions;
    protected ConnectionCloseEventListener closeEventListener;
    protected ExceptionListener listener;

    public ConnectionImpl(Connection realConnection, ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory, ConnectionCloseEventListener closeEventListener) throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.ConnectionImpl()");
        }
        this.realConnection = realConnection;
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.closeEventListener = closeEventListener;
        this.sessions = new ArrayList();
        realConnection.setExceptionListener((ExceptionListener)this);
    }

    public void onException(JMSException exception) {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.onException()");
        }
        if (this.listener != null) {
            this.listener.onException(exception);
        }
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            Iterator e = ((AbstractList)this.sessions).iterator();
            while (e.hasNext()) {
                ((ExceptionListener)e.next()).onException(exception);
            }
        }
    }

    public void addTransactedSession() {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.addTransactedSession() " + this.transactedSessions);
        }
        ++this.transactedSessions;
    }

    public void removeTransactedSession() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.removeTransactedSession() " + this.transactedSessions);
        }
        --this.transactedSessions;
        if (this.transactedSessions == 0 && this.isClosed) {
            this.closeEventListener.connectionClosed(this.realConnection);
        }
    }

    public void sessionClosed(Session session) {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.sessionClosed()");
        }
        if (this.isClosed) {
            return;
        }
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            ((AbstractCollection)this.sessions).remove(session);
        }
    }

    public void start() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.start()");
        }
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.start();
    }

    public void stop() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.stop()");
        }
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.stop();
    }

    public void close() throws JMSException {
        if (location.beLogged(100)) {
            location.logT(100, "ConnectionImpl.close()");
        }
        if (this.isClosed) {
            return;
        }
        this.stop();
        this.isClosed = true;
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            Iterator e = ((AbstractList)this.sessions).iterator();
            while (e.hasNext()) {
                ((Session)e.next()).close();
            }
        }
        if (this.transactedSessions == 0) {
            this.closeEventListener.connectionClosed(this.realConnection);
        }
    }

    public String getClientID() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.realConnection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.realConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.listener = exceptionListener;
    }
}

