/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.cci;

import com.sap.engine.services.jmsconnector.cci.ConnectionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.ConnectionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseJMSIllegalStateException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class Connection2Impl
extends ConnectionImpl
implements Connection,
ExceptionListener {
    protected Connection realXAConnection;

    public Connection2Impl(Connection realXAConnection, Connection realConnection, ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory, ConnectionCloseEventListener closeEventListener) throws JMSException {
        super(realConnection, connectionManager, managedConnectionFactory, closeEventListener);
        this.realXAConnection = realXAConnection;
        realXAConnection.setExceptionListener((ExceptionListener)this);
    }

    public void onException(JMSException exception) {
        if (this.listener != null) {
            this.listener.onException(exception);
        }
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            Iterator e = ((AbstractList)this.sessions).iterator();
            while (e.hasNext()) {
                ((ExceptionListener)e.next()).onException(exception);
            }
        }
    }

    public void addTransactedSession() {
        ++this.transactedSessions;
    }

    public void removeTransactedSession() throws JMSException {
        --this.transactedSessions;
        if (this.transactedSessions == 0 && this.isClosed) {
            this.closeEventListener.connectionClosed(this.realConnection);
            this.closeEventListener.connectionClosed(this.realXAConnection);
        }
    }

    public void sessionClosed(Session session) {
        if (this.isClosed) {
            return;
        }
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            ((AbstractCollection)this.sessions).remove(session);
        }
    }

    public void start() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.start();
        this.realXAConnection.start();
    }

    public void stop() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.stop();
        this.realXAConnection.stop();
    }

    public void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.stop();
        this.isClosed = true;
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            Iterator e = ((AbstractList)this.sessions).iterator();
            while (e.hasNext()) {
                ((Session)e.next()).close();
            }
        }
        if (this.transactedSessions == 0) {
            this.closeEventListener.connectionClosed(this.realConnection);
            this.closeEventListener.connectionClosed(this.realXAConnection);
        }
    }

    public String getClientID() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.realConnection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.realConnection.setClientID(clientID);
        this.realXAConnection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.realConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.isClosed) {
            BaseJMSIllegalStateException exc = new BaseJMSIllegalStateException("jmsconnector_0032");
            exc.log();
            throw exc;
        }
        this.listener = exceptionListener;
    }
}

