/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.command.DefineLibrary;
import com.sap.engine.services.jmsconnector.command.DeployDestination;
import com.sap.engine.services.jmsconnector.command.DeployJmsResource;
import com.sap.engine.services.jmsconnector.command.DeployLibrary;
import com.sap.engine.services.jmsconnector.command.UndefineLibrary;
import com.sap.engine.services.jmsconnector.command.UndeployJmsResource;
import com.sap.engine.services.jmsconnector.command.UndeployLibrary;
import com.sap.engine.services.jmsconnector.deploy.ContainerImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseServiceException;
import com.sap.tc.logging.Category;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class JMSConnectorFrame
extends ContainerEventListenerAdapter
implements ApplicationServiceFrame {
    private static final int MASK = 196;
    private static ApplicationServiceContext serviceContext;
    private static ComponentExecutionContext appContext;
    private static ThreadSystem threadSystem;
    private ContainerImpl containerImpl;
    private ContainerManagement containerManagment;
    private ShellInterface shell;
    private int commandsId;
    private Command[] commands;
    private Set interestingNames = new HashSet(3);

    public JMSConnectorFrame() {
        this.interestingNames.add("shell");
        this.interestingNames.add("container");
        this.interestingNames.add("deploy");
        this.interestingNames.add("appcontext");
    }

    public void start(ApplicationServiceContext appServiceContext) throws ServiceException {
        serviceContext = appServiceContext;
        threadSystem = appServiceContext.getCoreContext().getThreadSystem();
        Properties props = serviceContext.getServiceState().getProperties();
        if (this.containerImpl == null) {
            try {
                this.containerImpl = new ContainerImpl(serviceContext);
                this.commands = new Command[7];
                this.commands[0] = new DeployLibrary(this.containerImpl);
                this.commands[1] = new UndeployLibrary(this.containerImpl);
                this.commands[2] = new DeployJmsResource(this.containerImpl);
                this.commands[3] = new UndeployJmsResource(this.containerImpl);
                this.commands[4] = new DeployDestination(this.containerImpl);
                this.commands[5] = new DefineLibrary(this.containerImpl);
                this.commands[6] = new UndefineLibrary(this.containerImpl);
            }
            catch (Exception e) {
                throw new BaseServiceException("jmsconnector_0040", (Throwable)e);
            }
        }
        this.containerImpl.setProperties(props);
        serviceContext.getServiceState().registerContainerEventListener(196, this.interestingNames, this);
    }

    public void stop() {
        serviceContext.getServiceState().unregisterContainerEventListener();
        if (this.containerManagment != null) {
            this.containerManagment.unregisterContainer("JMSConnector");
            if (this.shell != null) {
                this.shell.unregisterCommands(this.commandsId);
            }
            serviceContext.getServiceState().unregisterManagementInterface();
            serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
        }
        this.shell = null;
        this.containerManagment = null;
        serviceContext = null;
        threadSystem = null;
    }

    public static ComponentExecutionContext getComponentExecutionContext() {
        return appContext;
    }

    public static ApplicationServiceContext getAppContext() {
        return serviceContext;
    }

    public static ThreadSystem getThreadSystem() {
        return threadSystem;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            if (this.containerManagment != null) {
                this.commandsId = this.shell.registerCommands(this.commands);
            }
        } else if (interfaceName.equals("container")) {
            this.containerManagment = (ContainerManagement)interfaceImpl;
            DeployCommunicator deployCommunicator = this.containerManagment.registerContainer(this.containerImpl.getContainerInfo().getName(), this.containerImpl);
            this.containerImpl.setDeployCommunicator(deployCommunicator);
            String JMS_CONNECTIONS_FILENAME = "jms-factories.xml";
            String JMS_DESTINATIONS_FILENAME = "jms-destinations.xml";
            String SECURE_SUB_CONFIGURATION = "Secure";
            JMSConnectorResourceAccessor.location.logT(300, "Starting migration to secure passwords saving.");
            try {
                ConfigurationHandler configurationHandler = serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
                String[] apps = deployCommunicator.getMyApplications();
                if (apps != null) {
                    JMSConnectorResourceAccessor.location.logT(300, "All deployed jms applications " + apps.length);
                    ArrayList<String> notModifedApps = new ArrayList<String>();
                    try {
                        int i = 0;
                        while (i < apps.length) {
                            Configuration configuration = configurationHandler.openConfiguration(deployCommunicator.getAppConfigPath(apps[i]), 0).getSubConfiguration("JMSConnector");
                            if (configuration.existsFile("jms-factories.xml") || configuration.existsFile("jms-destinations.xml")) {
                                notModifedApps.add(apps[i]);
                            }
                            ++i;
                        }
                    }
                    catch (ConfigurationLockedException e) {
                        JMSConnectorResourceAccessor.location.traceThrowableT(500, "Another server is making the migration: ", (Throwable)((Object)e));
                        configurationHandler.closeAllConfigurations();
                    }
                    JMSConnectorResourceAccessor.location.logT(300, "Modifying " + notModifedApps.size() + " applications.");
                    if (notModifedApps.size() > 0) {
                        int i = 0;
                        while (i < notModifedApps.size()) {
                            String name = (String)notModifedApps.get(i);
                            deployCommunicator.startModification(name);
                            try {
                                Configuration sub;
                                int read;
                                ByteArrayOutputStream buff;
                                InputStream inFile;
                                Configuration configuration = configurationHandler.openConfiguration(deployCommunicator.getAppConfigPath(name), 1).getSubConfiguration("JMSConnector");
                                if (configuration.existsFile("jms-factories.xml")) {
                                    new File(deployCommunicator.getMyWorkDirectory(name) + File.separatorChar + "jms-factories.xml").delete();
                                    inFile = configuration.getFile("jms-factories.xml");
                                    buff = new ByteArrayOutputStream();
                                    read = 0;
                                    while ((read = inFile.read()) != -1) {
                                        buff.write(read);
                                    }
                                    configuration.deleteFile("jms-factories.xml");
                                    sub = null;
                                    sub = !configuration.existsSubConfiguration("Secure") ? configuration.createSubConfiguration("Secure", 1) : configuration.getSubConfiguration("Secure");
                                    sub.getPropertySheetInterface().createSecurePropertyEntry("jms-factories.xml", new String(buff.toByteArray()), "jms-factories.xml");
                                }
                                if (configuration.existsFile("jms-destinations.xml")) {
                                    new File(deployCommunicator.getMyWorkDirectory(name) + File.separatorChar + "jms-destinations.xml").delete();
                                    inFile = configuration.getFile("jms-destinations.xml");
                                    buff = new ByteArrayOutputStream();
                                    read = 0;
                                    while ((read = inFile.read()) != -1) {
                                        buff.write(read);
                                    }
                                    configuration.deleteFile("jms-destinations.xml");
                                    sub = null;
                                    sub = !configuration.existsSubConfiguration("Secure") ? configuration.createSubConfiguration("Secure", 1) : configuration.getSubConfiguration("Secure");
                                    sub.getPropertySheetInterface().createSecurePropertyEntry("jms-destinations.xml", new String(buff.toByteArray()), "jms-destinations.xml");
                                }
                            }
                            catch (ConfigurationLockedException e) {
                                JMSConnectorResourceAccessor.location.traceThrowableT(500, "Unexpected error ocurred during migration of application " + name + " ", (Throwable)((Object)e));
                            }
                            configurationHandler.commit();
                            configurationHandler.closeAllConfigurations();
                            deployCommunicator.modificationDone(name);
                            ++i;
                        }
                    }
                }
                JMSConnectorResourceAccessor.location.logT(300, "Migration done.");
            }
            catch (Exception e) {
                JMSConnectorResourceAccessor.location.traceThrowableT(500, "Unexpected error ocurred during migration: ", (Throwable)e);
            }
            try {
                serviceContext.getServiceState().registerManagementInterface(this.containerImpl);
            }
            catch (ServiceException e) {
                Category.SYS_SERVER.logThrowableT(500, JMSConnectorResourceAccessor.location, "Cannot register management interface.", (Throwable)((Object)e));
            }
            serviceContext.getContainerContext().getObjectRegistry().registerInterface(this.containerImpl);
            if (this.shell != null) {
                this.shell.registerCommands(this.commands);
            }
        } else if (interfaceName.equals("appcontext")) {
            appContext = (ComponentExecutionContext)interfaceImpl;
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.shell = null;
        } else if (interfaceName.equals("container")) {
            if (this.shell != null) {
                this.shell.unregisterCommands(this.commandsId);
            }
            serviceContext.getServiceState().unregisterManagementInterface();
            serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
            this.containerManagment = null;
        } else if (interfaceName.equals("appcontext")) {
            appContext = null;
        }
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("deploy")) {
            this.containerImpl.setDeployService((DeployService)serviceInterface);
        }
    }
}

