/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server.generator;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.iiop.internal.util.RepositoryID;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.generator.MethodNamesDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class IDLNames {
    public static Hashtable namesCache = new Hashtable();
    static int arr = 0;
    static int k = 0;
    public static final String[] IDL_KEYWORDS = new String[]{"any", "readonly", "unsigned", "attribute", "enum", "sequence", "union", "exception", "module", "FALSE", "string", "wchar", "fixed", "octet", "struct", "wstring", "oneway", "context", "in", "out", "TRUE", "inout", "raises", "typedef", "double", "interface", "long", "boolean", "short", "void", "case", "Object", "char", "const", "float", "switch", "default"};
    public static final String[] ATTRIBUTE_PREFIX = new String[]{"", "_get_", "_get_", "_get_", "_get_", "_set_"};
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;

    public static String[] getIDLnames(Method[] method) {
        int count = method.length;
        String[] idlName = new String[count];
        MethodNamesDescriptor[] methods = new MethodNamesDescriptor[count];
        int i = 0;
        while (i < count) {
            methods[i] = new MethodNamesDescriptor(method[i]);
            ++i;
        }
        try {
            IDLNames.setMethodNames(methods);
            int i2 = 0;
            while (i2 < count) {
                idlName[i2] = methods[i2].getIDLname();
                namesCache.put(idlName[i2], method[i2].getName());
                ++i2;
            }
        }
        catch (Exception ex) {
            Logger.traceError("IDLNames.getIDLnames(Method[])", "Cannot get IDl name. The reason is: " + Logger.exceptionTrace(ex));
        }
        return idlName;
    }

    public static void setMethodNames(MethodNamesDescriptor[] methods) throws Exception {
        int count = methods.length;
        if (count == 0) {
            return;
        }
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = methods[i].getName();
            ++i;
        }
        int[] starts = new int[count];
        int k = 0;
        while (k < count) {
            starts[k] = IDLNames.getInitialAttributeKind(methods[k]);
            ++k;
        }
        IDLNames.setAttributeKinds(methods, starts, names);
        boolean[] collisions = new boolean[count];
        int i2 = 0;
        while (i2 < count) {
            names[i2] = IDLNames.getMemberName(names[i2]);
            collisions[i2] = !methods[i2].isAttribute() && IDLNames.doesMethodCollide(methods[i2], methods, names[i2], names, true);
            ++i2;
        }
        IDLNames.convertOverloadedMethods(methods, names, collisions);
        int i3 = 0;
        while (i3 < count) {
            if (methods[i3].isAttribute() && IDLNames.doesMethodCollide(methods[i3], methods, names[i3], names, true)) {
                int n = i3;
                names[n] = names[n] + "__";
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < count) {
            String s = names[i4];
            if (methods[i4].isAttribute()) {
                s = ATTRIBUTE_PREFIX[methods[i4].getAttributeKind()] + IDLNames.stripLeadingUnderscore(s);
                String tmp = names[i4];
                methods[i4].setAttributeName(tmp);
            }
            methods[i4].setIDLname(s);
            ++i4;
        }
    }

    private static int getInitialAttributeKind(MethodNamesDescriptor method) {
        int starts = 0;
        boolean flag = true;
        Class[] exceptions = method.exceptions();
        if (exceptions.length > 0) {
            int i = 0;
            while (i < exceptions.length) {
                if (!(class$java$rmi$RemoteException == null ? IDLNames.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exceptions[i])) {
                    flag = false;
                    break;
                }
                ++i;
            }
        }
        if (flag) {
            String name = method.getName();
            int len = name.length();
            int argLen = method.parameters().length;
            if (name.startsWith("get") && len > 3 && argLen == 0) {
                starts = 2;
            } else if (name.startsWith("is") && len > 2 && argLen == 0) {
                starts = 1;
            } else if (name.startsWith("set") && len > 3 && argLen == 1) {
                starts = 5;
            }
        }
        return starts;
    }

    private static void setAttributeKinds(MethodNamesDescriptor[] methods, int[] starts, String[] names) {
        int count = methods.length;
        int j = 0;
        while (j < count) {
            switch (starts[j]) {
                case 2: {
                    names[j] = names[j].substring(3);
                    break;
                }
                case 1: {
                    names[j] = names[j].substring(2);
                    break;
                }
                case 5: {
                    names[j] = names[j].substring(3);
                }
            }
            ++j;
        }
        int k = 0;
        while (k < count) {
            if (starts[k] == 1) {
                int i = 0;
                while (i < count) {
                    if (i != k && (starts[i] == 2 || starts[i] == 5) && names[k].equals(names[i])) {
                        Class param;
                        Class type = methods[k].returnType();
                        if (!type.equals(param = starts[i] == 2 ? methods[i].returnType() : methods[i].parameters()[0])) {
                            starts[k] = 0;
                            names[k] = methods[k].getName();
                            break;
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
        int k2 = 0;
        while (k2 < count) {
            if (starts[k2] == 5) {
                int s = -1;
                int i = 0;
                while (i < i) {
                    Class param;
                    Class type;
                    if (i != k2 && (starts[i] == 2 || starts[i] == 1) && names[k2].equals(names[i]) && (type = methods[i].returnType()).equals(param = methods[k2].parameters()[0])) {
                        s = i;
                        break;
                    }
                    ++i;
                }
                if (s < 0) {
                    starts[k2] = 0;
                    names[k2] = methods[k2].getName();
                } else {
                    starts[s] = starts[s] == 2 ? 4 : 3;
                    methods[s].setAttributePairIndex(k2);
                    methods[k2].setAttributePairIndex(s);
                }
            }
            ++k2;
        }
        int k3 = 0;
        while (k3 < count) {
            String s;
            if (starts[k3] != 0 && Character.isUpperCase((s = names[k3]).charAt(0)) && (s.length() == 1 || Character.isLowerCase(s.charAt(1)))) {
                StringBuffer buffer = new StringBuffer(s);
                buffer.setCharAt(0, Character.toLowerCase(s.charAt(0)));
                names[k3] = buffer.toString();
            }
            methods[k3].setAttributeKind(starts[k3]);
            ++k3;
        }
    }

    private static boolean doesMethodCollide(MethodNamesDescriptor method, MethodNamesDescriptor[] methods, String name, String[] names, boolean flag) {
        int i = 0;
        while (i < methods.length) {
            MethodNamesDescriptor currentMethod = methods[i];
            if (!(method == currentMethod || flag && currentMethod.isAttribute() || !name.equals(names[i]))) {
                int j = method.getAttributeKind();
                int k = currentMethod.getAttributeKind();
                if (j == 0 || k == 0 || (j != 5 || k == 5) && (k != 5 || j == 5)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String getMemberName(String name) {
        name = IDLNames.convertLeadingUnderscores(name);
        name = IDLNames.convertIDLKeywords(name);
        name = Convert.byteArrToAString(RepositoryID.convertToISOLatin1(name, new byte[name.length()], 0));
        return name;
    }

    public static String convertLeadingUnderscores(String s) {
        if (s.startsWith("_")) {
            return "J" + s;
        }
        return s;
    }

    public static String convertIDLKeywords(String s) {
        int i = 0;
        while (i < IDL_KEYWORDS.length) {
            if (s.equalsIgnoreCase(IDL_KEYWORDS[i])) {
                return "_" + s;
            }
            ++i;
        }
        return s;
    }

    private static String stripLeadingUnderscore(String s) {
        if (s != null && s.length() > 1 && s.charAt(0) == '_') {
            return s.substring(1);
        }
        return s;
    }

    private static void convertOverloadedMethods(MethodNamesDescriptor[] methods, String[] names, boolean[] collisions) {
        int i = 0;
        while (i < names.length) {
            if (collisions[i]) {
                MethodNamesDescriptor method = methods[i];
                Class[] params = method.parameters();
                StringBuffer buffer = new StringBuffer(names[i]);
                int j = 0;
                while (j < params.length) {
                    buffer.append("__");
                    buffer.append(IDLNames.idlType(params[j]));
                    ++j;
                }
                if (params.length == 0) {
                    buffer.append("__");
                }
                names[i] = IDLNames.stripLeadingUnderscore(buffer.toString());
            }
            ++i;
        }
    }

    private static String idlType(Class cls) {
        String type = null;
        if (cls.isArray()) {
            k = 0;
            Class<?> cls2 = null;
            while ((cls2 = cls.getComponentType()) != null) {
                ++k;
                cls = cls2;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("org_omg_boxedRMI");
            buffer.append("_");
            ++arr;
            buffer.append(IDLNames.idlType(cls));
            --arr;
            type = buffer.toString();
        } else if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                type = "long";
            } else if (cls == Byte.TYPE) {
                type = "byte";
            } else if (cls == Long.TYPE) {
                type = "long_long";
            } else if (cls == Float.TYPE) {
                type = "float";
            } else if (cls == Double.TYPE) {
                type = "double";
            } else if (cls == Short.TYPE) {
                type = "short";
            } else if (cls == Character.TYPE) {
                type = "wchar";
            } else if (cls == Boolean.TYPE) {
                type = "boolean";
            } else if (cls == Void.TYPE) {
                type = "void";
            }
        } else if (cls == (class$java$lang$String == null ? (class$java$lang$String = IDLNames.class$("java.lang.String")) : class$java$lang$String)) {
            type = "CORBA_WStringValue";
        } else if (cls == (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = IDLNames.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object)) {
            type = "Object";
        } else if (cls == (class$java$lang$Class == null ? (class$java$lang$Class = IDLNames.class$("java.lang.Class")) : class$java$lang$Class)) {
            type = "javax_rmi_CORBA_ClassDesc";
        } else if ((class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = IDLNames.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(cls)) {
            StringBuffer buffer = new StringBuffer("org_omg_boxedIDL_");
            if (arr == 0) {
                buffer.append(cls.getName().replace('.', '_'));
            } else {
                String _package = cls.getName().replace('.', '_');
                _package = _package.substring(0, _package.lastIndexOf(95) + 1);
                String _name = cls.getName().replace('.', '_');
                _name = _name.substring(_package.length() - 1);
                buffer.append(_package);
                buffer.append("seq");
                buffer.append(k);
                buffer.append(_name);
            }
            type = buffer.toString();
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(cls.getName().replace('.', '_'));
            type = buffer.toString();
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

