/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server.generator;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.xml.StandardDOMWriterNoSpace;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.generator.ClassDescriptor;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorField;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethod;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethodException;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethodParameter;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorReturnType;
import com.sap.engine.services.iiop.server.generator.DTDContastants;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClassDescriptorDocument
implements DTDContastants {
    private static final String dtd = "<!DOCTYPE Class [\r\n<!ELEMENT Class (Package?,StubPackage,AccessFlag?,Attribute*,Name,SuperClass?,SuperInterface*,ForStubName?,RMIRepositoryID+,ResourceId,Field*,Method*) >\r\n  <!ELEMENT Package (#PCDATA) >\r\n  <!ELEMENT StubPackage (#PCDATA) >\r\n  <!ELEMENT AccessFlag (#PCDATA) >\r\n  <!ELEMENT Name (#PCDATA) >\r\n  <!ELEMENT SuperClass (#PCDATA) >\r\n  <!ELEMENT SuperInterface (#PCDATA) >\r\n  <!ELEMENT ForStubName (#PCDATA) >\r\n  <!ELEMENT RMIRepositoryID (#PCDATA) >\r\n  <!ELEMENT ResourceId (#PCDATA) >\r\n  <!ELEMENT Field (Name,AccessFlag,Attribute*,Type) >\r\n  <!ELEMENT Type (#PCDATA) >\r\n  <!ELEMENT Attribute (#PCDATA) >\r\n  <!ELEMENT Method (Name,IDLName,AccessFlag,Attribute*,IsRemoteReturnType,ReturnType,Parameter*,Exception*)>\r\n  <!ELEMENT ReturnType (IsReturnType,IsInterface,ClassType,ToWriteAsObject,ForStubName,Method*)>\r\n  <!ELEMENT IsReturnType (#PCDATA)>\r\n  <!ELEMENT ClassType (#PCDATA)>\r\n  <!ELEMENT IDLName (#PCDATA) >\r\n  <!ELEMENT IsRemoteReturnType (#PCDATA) >\r\n  <!ELEMENT ToWriteAsObject (#PCDATA)>\r\n  <!ELEMENT Parameter (Type,IsInterface,IsRemote,ToWriteAsObject,ForStubName,Method) >\r\n  <!ELEMENT IsInterface (#PCDATA) >\r\n  <!ELEMENT IsRemote (#PCDATA) >\r\n  <!ELEMENT Exception (Name,IDLRepostoryID*,IsRemoteException) >\r\n  <!ELEMENT IDLRepostoryID (#PCDATA) >\r\n  <!ELEMENT IsRemoteException (#PCDATA) >]>";
    protected Document mainDocument;
    protected ClassLoader loader;

    public ClassDescriptorDocument() {
    }

    public ClassDescriptorDocument(ClassDescriptor descriptor) {
        SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
        this.loadDocumentFromDescriptor(descriptor);
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    public void setLoader(ClassLoader _loader) {
        this.loader = _loader;
    }

    public Document loadDocumentFromDescriptor(ClassDescriptor descriptor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.mainDocument = builder.newDocument();
            this.mainDocument.appendChild(this.loadElementFromDescriptor(descriptor, this.mainDocument));
        }
        catch (ParserConfigurationException ex) {
            return this.mainDocument;
        }
        return this.mainDocument;
    }

    public Element loadElementFromDescriptor(ClassDescriptor descriptor, Document document) {
        Element docElement = null;
        Element tempElement = null;
        Element tempsElement = null;
        Element innerEl1 = null;
        Element innerEl2 = null;
        Element innerEl3 = null;
        this.mainDocument = document;
        try {
            int j;
            int i;
            docElement = this.mainDocument.createElement("Class");
            if (descriptor.getPackage() != null) {
                this.load(docElement, descriptor.getPackage(), "Package");
            }
            if (descriptor.getInterfacePackage() != null) {
                this.load(docElement, descriptor.getInterfacePackage(), "StubPackage");
            }
            this.load(docElement, descriptor.getAccessFlag(), "AccessFlag");
            if (descriptor.getAttribute() != null) {
                i = 0;
                while (i < descriptor.getAttribute().length) {
                    this.load(docElement, descriptor.getAttribute(i), "Attribute");
                    ++i;
                }
            }
            this.load(docElement, descriptor.getName(), "Name");
            if (descriptor.getSuperClass() != null) {
                this.load(docElement, descriptor.getSuperClass(), "SuperClass");
            }
            if (descriptor.getSuperInterface() != null) {
                i = 0;
                while (i < descriptor.getSuperInterface().length) {
                    this.load(docElement, descriptor.getSuperInterface(i), "SuperInterface");
                    ++i;
                }
            }
            if (descriptor.getForStubName() != null) {
                this.load(docElement, descriptor.getForStubName(), "ForStubName");
            }
            if (descriptor.getRMIRepositoryID() != null) {
                i = 0;
                while (i < descriptor.getRMIRepositoryID().length) {
                    this.load(docElement, descriptor.getRMIRepositoryID(i), "RMIRepositoryID");
                    ++i;
                }
            }
            if (descriptor.getResourceId() != null) {
                this.load(docElement, descriptor.getResourceId(), "ResourceId");
            }
            if (descriptor.getField() != null) {
                i = 0;
                while (i < descriptor.getField().length) {
                    tempElement = this.mainDocument.createElement("Field");
                    docElement.appendChild(tempElement);
                    this.load(tempElement, descriptor.getField(i).getName(), "Name");
                    this.load(tempElement, descriptor.getField(i).getAccessFlag(), "AccessFlag");
                    if (descriptor.getField(i).getAttribute() != null) {
                        j = 0;
                        while (j < descriptor.getField(i).getAttribute().length) {
                            this.load(tempElement, descriptor.getField(i).getAttribute(j), "Attribute");
                            ++j;
                        }
                    }
                    this.load(tempElement, descriptor.getField(i).getType(), "Type");
                    ++i;
                }
            }
            if (descriptor.getMethod() != null) {
                i = 0;
                while (i < descriptor.getMethod().length) {
                    tempElement = this.mainDocument.createElement("Method");
                    docElement.appendChild(tempElement);
                    this.load(tempElement, descriptor.getMethod(i).getName(), "Name");
                    this.load(tempElement, descriptor.getMethod(i).getIDLname(), "IDLName");
                    this.load(tempElement, descriptor.getMethod(i).getAccessFlag(), "AccessFlag");
                    if (descriptor.getMethod(i).getAttribute() != null) {
                        j = 0;
                        while (j < descriptor.getMethod(i).getAttribute().length) {
                            this.load(tempElement, descriptor.getMethod(i).getAttribute(j), "Attribute");
                            ++j;
                        }
                    }
                    this.load(tempElement, descriptor.getMethod(i).getRemoteType(), "IsRemoteReturnType");
                    if (descriptor.getMethod(i).getReturnType() != null) {
                        innerEl1 = this.mainDocument.createElement("ReturnType");
                        tempElement.appendChild(innerEl1);
                        this.load(innerEl1, descriptor.getMethod(i).getReturnType().getIsReturnType(), "IsReturnType");
                        this.load(innerEl1, descriptor.getMethod(i).getReturnType().getIsInterface(), "IsInterface");
                        this.load(innerEl1, descriptor.getMethod(i).getReturnType().getClassType(), "ClassType");
                        this.load(innerEl1, descriptor.getMethod(i).getReturnType().getToWriteAsObject(), "ToWriteAsObject");
                        this.load(innerEl1, descriptor.getMethod(i).getReturnType().getForStubName(), "ForStubName");
                        if (descriptor.getMethod(i).getReturnType().getMethod().length > 0) {
                            int m = 0;
                            while (m < descriptor.getMethod(i).getReturnType().getMethod().length) {
                                innerEl2 = this.mainDocument.createElement("Method");
                                innerEl1.appendChild(innerEl2);
                                this.load(innerEl2, descriptor.getMethod(i).getReturnType().getMethod(m).getName(), "Name");
                                if (descriptor.getMethod(i).getReturnType().getMethod(m).getException().length > 0) {
                                    int l = 0;
                                    while (l < descriptor.getMethod(i).getReturnType().getMethod(m).getException().length) {
                                        innerEl3 = this.mainDocument.createElement("Exception");
                                        innerEl2.appendChild(innerEl3);
                                        this.load(innerEl3, descriptor.getMethod(i).getReturnType().getMethod(m).getException(l).getName(), "Name");
                                        if (descriptor.getMethod(i).getReturnType().getMethod(m).getException(l).getName() != "java.rmi.RemoteException") {
                                            this.load(innerEl3, descriptor.getMethod(i).getReturnType().getMethod(m).getException(l).getIDLRepID(), "IDLRepostoryID");
                                        }
                                        this.load(innerEl3, descriptor.getMethod(i).getReturnType().getMethod(m).getException(l).isRemoteException(), "IsRemoteException");
                                        ++l;
                                    }
                                }
                                ++m;
                            }
                        }
                    }
                    if (descriptor.getMethod(i).getParameter() != null) {
                        j = 0;
                        while (j < descriptor.getMethod(i).getParameter().length) {
                            innerEl1 = this.mainDocument.createElement("Parameter");
                            tempElement.appendChild(innerEl1);
                            this.load(innerEl1, descriptor.getMethod(i).getParameter(j).getType(), "Type");
                            this.load(innerEl1, descriptor.getMethod(i).getParameter(j).isInterface(), "IsInterface");
                            this.load(innerEl1, descriptor.getMethod(i).getParameter(j).isRemote(), "IsRemote");
                            this.load(innerEl1, descriptor.getMethod(i).getParameter(j).getForStubName(), "ForStubName");
                            this.load(innerEl1, descriptor.getMethod(i).getParameter(j).getToWriteAsObject(), "ToWriteAsObject");
                            if (descriptor.getMethod(i).getParameter(j).getMethod().length > 0) {
                                int k = 0;
                                while (k < descriptor.getMethod(i).getParameter(j).getMethod().length) {
                                    innerEl2 = this.mainDocument.createElement("Method");
                                    innerEl1.appendChild(innerEl2);
                                    this.load(innerEl2, descriptor.getMethod(i).getParameter(j).getMethod(k).getName(), "Name");
                                    if (descriptor.getMethod(i).getParameter(j).getMethod(k).getException().length > 0) {
                                        int l = 0;
                                        while (l < descriptor.getMethod(i).getParameter(j).getMethod(k).getException().length) {
                                            innerEl3 = this.mainDocument.createElement("Exception");
                                            innerEl2.appendChild(innerEl3);
                                            this.load(innerEl3, descriptor.getMethod(i).getParameter(j).getMethod(k).getException(l).getName(), "Name");
                                            if (descriptor.getMethod(i).getParameter(j).getMethod(k).getException(l).getName() != "java.rmi.RemoteException") {
                                                this.load(innerEl3, descriptor.getMethod(i).getParameter(j).getMethod(k).getException(l).getIDLRepID(), "IDLRepostoryID");
                                            }
                                            this.load(innerEl3, descriptor.getMethod(i).getParameter(j).getMethod(k).getException(l).isRemoteException(), "IsRemoteException");
                                            ++l;
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    if (descriptor.getMethod(i).getException() != null) {
                        j = 0;
                        while (j < descriptor.getMethod(i).getException().length) {
                            tempsElement = this.mainDocument.createElement("Exception");
                            tempElement.appendChild(tempsElement);
                            this.load(tempsElement, descriptor.getMethod(i).getException(j).getName(), "Name");
                            if (descriptor.getMethod(i).getException(j).getName() != "java.rmi.RemoteException") {
                                this.load(tempsElement, descriptor.getMethod(i).getException(j).getIDLRepID(), "IDLRepostoryID");
                            }
                            this.load(tempsElement, descriptor.getMethod(i).getException(j).isRemoteException(), "IsRemoteException");
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Logger.traceError("ClassDescriptorDocument.loadElementFromDescriptor(ClassDescriptor, Document)", "Descriptor error : " + Logger.exceptionTrace(e));
        }
        return docElement;
    }

    public ClassDescriptor loadDescriptorFromDocument(Document document) {
        ClassDescriptor descriptor = new ClassDescriptor();
        try {
            descriptor = this.loadDescriptorFromDocument(document.getDocumentElement());
        }
        catch (Exception ex) {
            Logger.traceWarning("ClassDescriptorDocument.loadDescriptorFromDocument(Document)", Logger.exceptionTrace(ex));
            return descriptor;
        }
        return descriptor;
    }

    public ClassDescriptor loadDescriptorFromDocument(Element elmnt) throws WrongStructureException {
        ClassDescriptor resourceDescriptor = new ClassDescriptor();
        Element element = null;
        String tag = null;
        ClassDescriptorField classDescriptorField = null;
        ClassDescriptorMethod classDescriptorMethod = null;
        ClassDescriptorMethod innerClassDescriptorMethod = null;
        ClassDescriptorReturnType classDescriptorReturnType = null;
        ClassDescriptorMethodParameter classDescriptorMethodParameter = null;
        ClassDescriptorMethodException classDescriptorMethodException = null;
        NodeList list = elmnt.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                int k;
                String nextElTag;
                Element nextEl;
                NodeList paramsList;
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("Method")) {
                    classDescriptorMethod = new ClassDescriptorMethod();
                    paramsList = element.getChildNodes();
                    if (paramsList != null) {
                        nextEl = null;
                        nextElTag = null;
                        k = 0;
                        while (k < paramsList.getLength()) {
                            if (paramsList.item(k).getNodeType() == 1) {
                                String nextParsElTag;
                                Element nextParsEl;
                                NodeList exceptionParsList;
                                String nextMethElTag;
                                Element nextMethEl;
                                int j;
                                String nextParamsElTag;
                                Element nextParamsEl;
                                nextEl = (Element)paramsList.item(k);
                                nextElTag = nextEl.getNodeName();
                                if (nextElTag.equals("Name")) {
                                    classDescriptorMethod.setName(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("IDLName")) {
                                    classDescriptorMethod.setIDLname(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("Parameter")) {
                                    NodeList paramsParamsList = nextEl.getChildNodes();
                                    if (paramsParamsList != null) {
                                        nextParamsEl = null;
                                        nextParamsElTag = null;
                                        classDescriptorMethodParameter = new ClassDescriptorMethodParameter();
                                        j = 0;
                                        while (j < paramsParamsList.getLength()) {
                                            if (paramsParamsList.item(j).getNodeType() == 1) {
                                                nextParamsEl = (Element)paramsParamsList.item(j);
                                                nextParamsElTag = nextParamsEl.getNodeName();
                                                if (nextParamsElTag.equals("Type")) {
                                                    classDescriptorMethodParameter.setType(this.getTextValue(nextParamsEl).replace('$', '.'));
                                                } else if (nextParamsElTag.equals("IsInterface")) {
                                                    classDescriptorMethodParameter.setInterface(this.getTextValue(nextParamsEl));
                                                } else if (nextParamsElTag.equals("IsRemote")) {
                                                    classDescriptorMethodParameter.setRemote(this.getTextValue(nextParamsEl));
                                                } else if (nextParamsElTag.equals("ForStubName")) {
                                                    classDescriptorMethodParameter.setForStubName(this.getTextValue(nextParamsEl));
                                                } else if (nextParamsElTag.equals("ToWriteAsObject")) {
                                                    classDescriptorMethodParameter.setToWriteAsObject(this.getTextValue(nextParamsEl));
                                                } else if (nextParamsElTag.equals("Method")) {
                                                    innerClassDescriptorMethod = new ClassDescriptorMethod();
                                                    NodeList elemTypeList = nextParamsEl.getChildNodes();
                                                    if (elemTypeList != null) {
                                                        nextMethEl = null;
                                                        nextMethElTag = null;
                                                        int m = 0;
                                                        while (m < elemTypeList.getLength()) {
                                                            if (elemTypeList.item(m).getNodeType() == 1 && (nextMethElTag = (nextMethEl = (Element)elemTypeList.item(m)).getNodeName()).equals("Exception") && (exceptionParsList = nextMethEl.getChildNodes()) != null) {
                                                                nextParsEl = null;
                                                                nextParsElTag = null;
                                                                classDescriptorMethodException = new ClassDescriptorMethodException();
                                                                int n = 0;
                                                                while (n < exceptionParsList.getLength()) {
                                                                    if (exceptionParsList.item(n).getNodeType() == 1) {
                                                                        nextParsEl = (Element)exceptionParsList.item(n);
                                                                        nextParsElTag = nextParsEl.getNodeName();
                                                                        if (nextParsElTag.equals("Name")) {
                                                                            classDescriptorMethodException.setName(this.getTextValue(nextParsEl).replace('$', '.'));
                                                                        } else if (nextParsElTag.equals("IsRemoteException")) {
                                                                            classDescriptorMethodException.setIsRemoteException(this.getTextValue(nextParsEl));
                                                                        } else if (nextParsElTag.equals("IDLRepostoryID")) {
                                                                            classDescriptorMethodException.setIDLRepID(this.replaceStr(this.getTextValue(nextParsEl), "$", "__"));
                                                                        } else {
                                                                            throw new WrongStructureException("ID019155: Unknown Tag " + tag);
                                                                        }
                                                                    }
                                                                    ++n;
                                                                }
                                                                innerClassDescriptorMethod.setException(classDescriptorMethodException);
                                                            }
                                                            ++m;
                                                        }
                                                    }
                                                } else {
                                                    throw new WrongStructureException("ID019156: Unknown Tag " + tag);
                                                }
                                            }
                                            ++j;
                                        }
                                        classDescriptorMethod.setParameter(classDescriptorMethodParameter);
                                    }
                                } else if (nextElTag.equals("AccessFlag")) {
                                    classDescriptorMethod.setAccessFlag(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("Attribute")) {
                                    classDescriptorMethod.setAttribute(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("IsRemoteReturnType")) {
                                    classDescriptorMethod.setRemoteType(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("ReturnType")) {
                                    NodeList paramsReturnList = nextEl.getChildNodes();
                                    if (paramsReturnList != null) {
                                        Element nextParamRetEl = null;
                                        String nextParamRetElTag = null;
                                        classDescriptorReturnType = new ClassDescriptorReturnType();
                                        int n = 0;
                                        while (n < paramsReturnList.getLength()) {
                                            if (paramsReturnList.item(n).getNodeType() == 1) {
                                                nextParamRetEl = (Element)paramsReturnList.item(n);
                                                nextParamRetElTag = nextParamRetEl.getNodeName();
                                                if (nextParamRetElTag.equals("IsReturnType")) {
                                                    classDescriptorReturnType.setIsReturnType(this.getTextValue(nextParamRetEl));
                                                } else if (nextParamRetElTag.equals("IsInterface")) {
                                                    classDescriptorReturnType.setIsInterface(this.getTextValue(nextParamRetEl));
                                                } else if (nextParamRetElTag.equals("ClassType")) {
                                                    classDescriptorReturnType.setClassType(this.getTextValue(nextParamRetEl).replace('$', '.'));
                                                } else if (nextParamRetElTag.equals("ForStubName")) {
                                                    classDescriptorReturnType.setForStubName(this.getTextValue(nextParamRetEl));
                                                } else if (nextParamRetElTag.equals("ToWriteAsObject")) {
                                                    classDescriptorReturnType.setIsReturnType(this.getTextValue(nextParamRetEl));
                                                } else if (nextParamRetElTag.equals("Method")) {
                                                    innerClassDescriptorMethod = new ClassDescriptorMethod();
                                                    NodeList paramRetList = nextParamRetEl.getChildNodes();
                                                    if (paramRetList != null) {
                                                        nextMethEl = null;
                                                        nextMethElTag = null;
                                                        int p = 0;
                                                        while (p < paramRetList.getLength()) {
                                                            if (paramRetList.item(p).getNodeType() == 1 && (nextMethElTag = (nextMethEl = (Element)paramRetList.item(p)).getNodeName()).equals("Exception") && (exceptionParsList = nextMethEl.getChildNodes()) != null) {
                                                                nextParsEl = null;
                                                                nextParsElTag = null;
                                                                classDescriptorMethodException = new ClassDescriptorMethodException();
                                                                int r = 0;
                                                                while (r < exceptionParsList.getLength()) {
                                                                    if (exceptionParsList.item(r).getNodeType() == 1) {
                                                                        nextParsEl = (Element)exceptionParsList.item(r);
                                                                        nextParsElTag = nextParsEl.getNodeName();
                                                                        if (nextParsElTag.equals("Name")) {
                                                                            classDescriptorMethodException.setName(this.getTextValue(nextParsEl).replace('$', '.'));
                                                                        } else if (nextParsElTag.equals("IsRemoteException")) {
                                                                            classDescriptorMethodException.setIsRemoteException(this.getTextValue(nextParsEl));
                                                                        } else if (nextParsElTag.equals("IDLRepostoryID")) {
                                                                            classDescriptorMethodException.setIDLRepID(this.replaceStr(this.getTextValue(nextParsEl), "$", "__"));
                                                                        } else {
                                                                            throw new WrongStructureException("ID019157: Unknown Tag " + tag);
                                                                        }
                                                                    }
                                                                    ++r;
                                                                }
                                                                innerClassDescriptorMethod.setException(classDescriptorMethodException);
                                                            }
                                                            ++p;
                                                        }
                                                    }
                                                    classDescriptorReturnType.setMethod(innerClassDescriptorMethod);
                                                }
                                            }
                                            ++n;
                                        }
                                        classDescriptorMethod.setReturnType(classDescriptorReturnType);
                                    }
                                } else if (nextElTag.equals("Exception")) {
                                    NodeList exceptionParamsList = nextEl.getChildNodes();
                                    if (exceptionParamsList != null) {
                                        nextParamsEl = null;
                                        nextParamsElTag = null;
                                        classDescriptorMethodException = new ClassDescriptorMethodException();
                                        j = 0;
                                        while (j < exceptionParamsList.getLength()) {
                                            if (exceptionParamsList.item(j).getNodeType() == 1) {
                                                nextParamsEl = (Element)exceptionParamsList.item(j);
                                                nextParamsElTag = nextParamsEl.getNodeName();
                                                if (nextParamsElTag.equals("Name")) {
                                                    classDescriptorMethodException.setName(this.getTextValue(nextParamsEl).replace('$', '.'));
                                                } else if (nextParamsElTag.equals("IsRemoteException")) {
                                                    classDescriptorMethodException.setIsRemoteException(this.getTextValue(nextParamsEl));
                                                } else if (nextParamsElTag.equals("IDLRepostoryID")) {
                                                    classDescriptorMethodException.setIDLRepID(this.replaceStr(this.getTextValue(nextParamsEl), "$", "__"));
                                                } else {
                                                    throw new WrongStructureException("ID019158: Unknown Tag " + tag);
                                                }
                                            }
                                            ++j;
                                        }
                                        classDescriptorMethod.setException(classDescriptorMethodException);
                                    }
                                } else {
                                    throw new WrongStructureException("ID019159: Unknown Tag " + tag);
                                }
                            }
                            ++k;
                        }
                    }
                    resourceDescriptor.setMethod(classDescriptorMethod);
                } else if (tag.equals("Field")) {
                    classDescriptorField = new ClassDescriptorField();
                    paramsList = element.getChildNodes();
                    if (paramsList != null) {
                        nextEl = null;
                        nextElTag = null;
                        k = 0;
                        while (k < paramsList.getLength()) {
                            if (paramsList.item(k).getNodeType() == 1) {
                                nextEl = (Element)paramsList.item(k);
                                nextElTag = nextEl.getNodeName();
                                if (nextElTag.equals("Name")) {
                                    classDescriptorField.setName(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("AccessFlag")) {
                                    classDescriptorField.setAccessFlag(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("Attribute")) {
                                    classDescriptorField.setAttribute(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("Type")) {
                                    classDescriptorField.setType(this.getTextValue(nextEl));
                                } else {
                                    throw new WrongStructureException("ID019160: Unknown Tag " + tag);
                                }
                            }
                            ++k;
                        }
                    }
                    resourceDescriptor.setField(classDescriptorField);
                } else if (tag.equals("Attribute")) {
                    resourceDescriptor.setAttribute(this.getTextValue(element));
                } else if (tag.equals("Package")) {
                    resourceDescriptor.setPackage(this.getTextValue(element));
                } else if (tag.equals("StubPackage")) {
                    resourceDescriptor.setInterfacePackage(this.getTextValue(element));
                } else if (tag.equals("RMIRepositoryID")) {
                    resourceDescriptor.setRMIRepositoryID(this.getTextValue(element));
                } else if (tag.equals("AccessFlag")) {
                    resourceDescriptor.setAccessFlag(this.getTextValue(element));
                } else if (tag.equals("Name")) {
                    resourceDescriptor.setName(this.getTextValue(element));
                } else if (tag.equals("SuperClass")) {
                    resourceDescriptor.setSuperClass(this.getTextValue(element));
                } else if (tag.equals("ForStubName")) {
                    resourceDescriptor.setForStubName(this.getTextValue(element));
                } else if (tag.equals("ResourceId")) {
                    resourceDescriptor.setResourceId(this.getTextValue(element));
                } else if (tag.equals("SuperInterface")) {
                    resourceDescriptor.setSuperInterface(this.getTextValue(element));
                } else {
                    throw new WrongStructureException("ID019161: Unknown Tag " + tag);
                }
            }
            ++i;
        }
        return resourceDescriptor;
    }

    private String replaceStr(String base, String old, String rep) {
        int i = base.indexOf(old);
        if (i != -1) {
            return base.substring(0, i - 1) + rep + base.substring(i + 1);
        }
        return base;
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    protected void load(String name, String tagName) {
        this.load(this.mainDocument.getDocumentElement(), name, tagName);
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    public void writeDTDtoFile(String filename) {
        try {
            StandardDOMWriterNoSpace wr = new StandardDOMWriterNoSpace();
            wr.write(this.mainDocument, filename, dtd);
        }
        catch (IOException ioex) {
            Logger.traceError("ClassDescriptorDocument.writeDTDtoFile(String)", Logger.exceptionTrace(ioex));
        }
    }
}

