/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.cross.ObjectReference;
import com.sap.engine.interfaces.cross.ProtocolProvider;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.iiop.internal.IIOPObjectReference;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.IIOPGenerator;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class IIOPProvider
extends IIOPGenerator
implements ProtocolProvider {
    private MessageContext msgContext;
    private ClusterElement[] elements;
    private ClusterMonitor monitor;
    private Hashtable initialObjects = new Hashtable();
    private ORB orb;
    private static String[] symbols = new String[]{".", "_", ":"};
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$javax$rmi$PortableRemoteObject;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Vector;

    public IIOPProvider(ApplicationServiceContext context) {
        this.msgContext = context.getClusterContext().getMessageContext();
        this.monitor = context.getClusterContext().getClusterMonitor();
        this.elements = this.monitor.getServiceNodes();
        this.orb = ORB.init();
    }

    public void setInitialObject(String name, Remote initialObject) {
        this.initialObjects.put(name, initialObject);
        try {
            int len = 2 * name.length();
            Object corbaObject = (Object)Util.getTie((Remote)initialObject);
            if (corbaObject == null) {
                return;
            }
            String ior = this.orb.object_to_string(corbaObject);
            int iorLen = 2 * ior.length();
            byte[] message = new byte[len + iorLen + 1];
            message[0] = (byte)len;
            Convert.writeUStringToByteArr(message, 1, name);
            Convert.writeUStringToByteArr(message, len + 1, ior);
            int i = 0;
            while (i < this.elements.length) {
                int clusterId = this.elements[i].getClusterId();
                if (this.elements[i].getType() == 1) {
                    this.msgContext.send(clusterId, 44, message, 0, message.length);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Logger.traceError("IIOPProvider.setInitialObject(String, Remote)", Logger.exceptionTrace(ex));
        }
    }

    public void removeInitialObject(String name) {
        this.initialObjects.remove(name);
    }

    public String getName() {
        return "iiop";
    }

    public void exportObject(Remote rm, ClassLoader loader) {
        try {
            IIOPProvider.loadObject(rm);
        }
        catch (ClassNotFoundException cnfex) {
            return;
        }
        catch (Exception e) {
            Logger.traceWarning("IIOPProvider.exportObject(Remote, ClassLoader)", Logger.exceptionTrace(e));
            return;
        }
    }

    public void unexportObject(Remote rm) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)rm);
        if (tie == null) {
            throw new NoSuchObjectException(" Object not exported in iiop provider.");
        }
        Util.unexportObject((Remote)rm);
    }

    public ObjectReference getObjectReference(java.lang.Object obj) {
        String ior = "";
        String name = "";
        try {
            ObjectImpl corbaObj = (ObjectImpl)IIOPProvider.loadObject(obj);
            String temp = corbaObj._ids()[0];
            name = temp.substring(temp.indexOf(symbols[2]) + 1, temp.lastIndexOf(symbols[2]));
            ior = ORB.init().object_to_string((Object)corbaObj);
        }
        catch (ClassNotFoundException cnfex) {
            return null;
        }
        catch (Exception ex) {
            Logger.traceWarning("IIOPProvider.getObjectReference(Object)", "Can't get IOR for : " + obj + " , will use IORReference..." + Logger.exceptionTrace(ex));
            return null;
        }
        return new IIOPObjectReference(ior, name);
    }

    public Class getAssociatedClass() {
        return class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = IIOPProvider.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object;
    }

    public java.lang.Object narrow(java.lang.Object obj, Class _class) throws ClassCastException {
        Class<?> cl = obj.getClass();
        if (_class.isAssignableFrom(cl)) {
            return obj;
        }
        String clName = _class.getName();
        StringBuffer buffer = new StringBuffer(clName);
        buffer.insert(clName.lastIndexOf(symbols[0]) + 1, symbols[1]);
        buffer.append("_Stub");
        Stub stub = null;
        try {
            Class<?> cl1 = Class.forName(buffer.toString(), true, cl.getClassLoader());
            stub = (Stub)cl1.newInstance();
            stub._set_delegate(((ObjectImpl)obj)._get_delegate());
        }
        catch (Exception ex) {
            Logger.traceError("IIOPProvider.narrow(Object, Object)", Logger.exceptionTrace(ex));
        }
        return stub;
    }

    public static Object loadObject(java.lang.Object obj) throws ClassNotFoundException {
        if (obj instanceof Object) {
            return (Object)obj;
        }
        if (obj instanceof Remote) {
            Tie ob = Util.getTie((Remote)((Remote)obj));
            if (ob != null) {
                return (Object)ob;
            }
            Class<?> cl = obj.getClass();
            String initialStubName = null;
            while (cl != null && !cl.equals(class$javax$rmi$PortableRemoteObject == null ? IIOPProvider.class$("javax.rmi.PortableRemoteObject") : class$javax$rmi$PortableRemoteObject) && !cl.equals(class$java$lang$Object == null ? IIOPProvider.class$("java.lang.Object") : class$java$lang$Object)) {
                String clName = cl.getName();
                StringBuffer buffer = new StringBuffer(clName);
                buffer.insert(clName.lastIndexOf(symbols[0]) + 1, symbols[1]);
                buffer.append("_Tie");
                if (initialStubName == null) {
                    initialStubName = buffer.toString();
                }
                Tie tie = null;
                try {
                    Class<?> cl1 = Class.forName(buffer.toString(), true, cl.getClassLoader());
                    tie = (Tie)cl1.newInstance();
                    tie.setTarget((Remote)obj);
                    Util.registerTarget((Tie)tie, (Remote)((Remote)obj));
                    return (Object)tie;
                }
                catch (Exception ex) {
                    cl = cl.getSuperclass();
                }
            }
            ClassNotFoundException cnfe = new ClassNotFoundException(initialStubName);
            Logger.traceWarning("IIOPProvider.loadObject(Object)", "Cannot load tie class for " + initialStubName);
            throw cnfe;
        }
        ClassNotFoundException cnfe = new ClassNotFoundException("Incapable class:" + obj.getClass());
        Logger.traceError("IIOPProvider.loadObject(Object)", "Error during loading object\n" + obj.getClass());
        throw cnfe;
    }

    public void sendInitilObjects(int clusterId) {
        Enumeration names = this.initialObjects.keys();
        while (names.hasMoreElements()) {
            try {
                String name = (String)names.nextElement();
                Remote initialObject = (Remote)this.initialObjects.get(name);
                int len = 2 * name.length();
                Object corbaObject = (Object)Util.getTie((Remote)initialObject);
                if (corbaObject == null) break;
                String ior = this.orb.object_to_string(corbaObject);
                int iorLen = 2 * ior.length();
                byte[] message = new byte[len + iorLen + 1];
                message[0] = (byte)len;
                Convert.writeUStringToByteArr(message, 1, name);
                Convert.writeUStringToByteArr(message, len + 1, ior);
                ClusterElement element = this.monitor.getParticipant(clusterId);
                if (element == null || element.getType() != 1) continue;
                this.msgContext.send(clusterId, 44, message, 0, message.length);
            }
            catch (Exception ex) {
                Logger.traceError("IIOPProvider.sendInitilObjects(int)", Logger.exceptionTrace(ex));
            }
        }
    }

    public Class getProviderClass() {
        return class$java$util$Vector == null ? (class$java$util$Vector = IIOPProvider.class$("java.util.Vector")) : class$java$util$Vector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

