/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.util;

import com.sap.engine.services.iiop.internal.util.RepositoryID;
import com.sap.engine.services.iiop.internal.util.RepositoryIDCacheTable;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public final class RepositoryIDDescriptor {
    public long hashCode;
    public long sUID;
    public static RepositoryIDCacheTable repIDTable = new RepositoryIDCacheTable();
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;

    public static final RepositoryIDDescriptor get(Class clas) {
        RepositoryIDCacheTable repositoryIDCacheTable = repIDTable;
        synchronized (repositoryIDCacheTable) {
            RepositoryIDDescriptor repIDprocessed;
            RepositoryIDDescriptor repID = (RepositoryIDDescriptor)repIDTable.get(clas);
            if (repID == null) {
                repID = new RepositoryIDDescriptor();
                repID.computeHashCode(clas);
                repID.getSerialVersionUID(clas);
                repIDTable.put(clas, repID);
            }
            RepositoryIDDescriptor repositoryIDDescriptor = repIDprocessed = repID;
            return repositoryIDDescriptor;
        }
    }

    private final void computeHashCode(Class clas) {
        long hash = 0L;
        try {
            int k;
            ByteArrayOutputStream bs = new ByteArrayOutputStream(512);
            if (clas.isInterface() || !(class$java$io$Serializable == null ? (class$java$io$Serializable = RepositoryIDDescriptor.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clas)) {
                this.hashCode = 0L;
                return;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = RepositoryIDDescriptor.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clas)) {
                this.hashCode = 1L;
                return;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestStream = new DigestOutputStream(bs, digest);
            DataOutputStream stream = new DataOutputStream(digestStream);
            Class parent = clas.getSuperclass();
            RepositoryIDDescriptor descriptor = RepositoryIDDescriptor.get(parent);
            if (parent != null && parent != (class$java$lang$Object == null ? (class$java$lang$Object = RepositoryIDDescriptor.class$("java.lang.Object")) : class$java$lang$Object)) {
                stream.writeLong(descriptor.hashCode);
            }
            try {
                Class[] writeObjectArgs = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = RepositoryIDDescriptor.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                Method writeMethod = clas.getDeclaredMethod("writeObject", writeObjectArgs);
                int i = writeMethod.getModifiers();
                if (!Modifier.isPrivate(i) || Modifier.isStatic(i)) {
                    writeMethod = null;
                }
                stream.writeInt(writeMethod != null ? 2 : 1);
            }
            catch (NoSuchMethodException ex) {
                stream.writeInt(1);
            }
            Field[] fields = clas.getDeclaredFields();
            Arrays.sort(fields, RepositoryIDDescriptor.repIDTable.comparator);
            int i = 0;
            while (i < fields.length) {
                Field afield = fields[i];
                int j = afield.getModifiers();
                if (!Modifier.isTransient(j) && !Modifier.isStatic(j)) {
                    stream.writeUTF(afield.getName());
                    stream.writeUTF(RepositoryID.signature(afield.getType()));
                }
                ++i;
            }
            stream.flush();
            byte[] abyte = digest.digest();
            int i2 = k = Math.min(8, abyte.length);
            while (i2 > 0) {
                hash += (long)(abyte[i2] & 0xFF) << i2 * 8;
                --i2;
            }
        }
        catch (IOException ioexception) {
            hash = -1L;
        }
        catch (Exception e) {
            Logger.traceError("RepositoryIDDescriptor.computeHashCode(Class)", Logger.exceptionTrace(e));
        }
        this.hashCode = hash;
    }

    private final void getSerialVersionUID(Class clas) {
        long id = 0L;
        try {
            ObjectStreamClass osc = ObjectStreamClass.lookup(clas);
            if (osc != null) {
                id = osc.getSerialVersionUID();
            }
        }
        catch (Exception e) {
            Logger.traceError("RepositoryIDDescriptor.getSerialVersionUID(Class)", Logger.exceptionTrace(e));
            id = -1L;
        }
        this.sUID = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

