/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.util;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.iiop.internal.util.RepositoryIDDescriptor;
import com.sap.engine.services.iiop.internal.util.SpecialRepIDTable;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.Serializable;

public class RepositoryID {
    private Class cls;
    private String repositoryID;
    private String specialRepID;
    private byte[] repositoryIDbyte;
    static int index;
    private boolean processed;
    private String IDLrepID;
    private byte[] IDLrepIDbyte;
    private RepositoryIDDescriptor descriptor;
    private static final byte[] IDL_IDENTIFIER_CHARS;
    private static final byte[] ASCII_HEX;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$io$Serializable;

    public RepositoryID(Class cls) {
        this.cls = cls;
        if (!cls.isArray()) {
            this.descriptor = RepositoryIDDescriptor.get(cls);
        }
    }

    public static String getRMIRepositoryID(Class cls) {
        RepositoryID repID = new RepositoryID(cls);
        repID.process();
        if (cls == (class$java$util$Date == null ? (class$java$util$Date = RepositoryID.class$("java.util.Date")) : class$java$util$Date)) {
            return "RMI:java.util.Date:2B112DD1F3049E5C:686A81014B597419";
        }
        return repID.repositoryID;
    }

    public static String getRMIRepositoryID(Serializable serial) {
        return RepositoryID.getRMIRepositoryID(serial.getClass());
    }

    public static byte[] getRMIRepIDByte(Class cls) {
        RepositoryID repID = new RepositoryID(cls);
        repID.process();
        return repID.repositoryIDbyte;
    }

    public static byte[] getRMIRepIDByte(Serializable serial) {
        return RepositoryID.getRMIRepIDByte(serial.getClass());
    }

    public static String getIDLRepositoryID(Class cls) {
        RepositoryID repID = new RepositoryID(cls);
        repID.process();
        return repID.IDLrepID;
    }

    public static String getIDLRepositoryID(Serializable serial) {
        return RepositoryID.getIDLRepositoryID(serial.getClass());
    }

    public static byte[] getIDLRepIDByte(Class cls) {
        RepositoryID repID = new RepositoryID(cls);
        repID.process();
        return repID.IDLrepIDbyte;
    }

    public static byte[] getIDLRepIDByte(Serializable serial) {
        return RepositoryID.getIDLRepIDByte(serial.getClass());
    }

    private final void process() {
        if (!this.processed) {
            try {
                this.specialRepID = SpecialRepIDTable.getID(this.cls);
                if (this.cls.isArray()) {
                    this.repositoryIDbyte = RepositoryID.createSequenceRepID(this.cls);
                    this.repositoryID = Convert.byteArrToAString(this.repositoryIDbyte);
                } else if (this.specialRepID != null && !this.cls.isArray()) {
                    this.repositoryIDbyte = new byte[this.specialRepID.length()];
                    int i = 0;
                    while (i < this.specialRepID.length()) {
                        this.repositoryIDbyte[i] = (byte)this.specialRepID.charAt(i);
                        ++i;
                    }
                    this.repositoryID = this.specialRepID;
                } else if (this.specialRepID == null && (class$java$lang$Exception == null ? (class$java$lang$Exception = RepositoryID.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(this.cls)) {
                    this.IDLrepIDbyte = RepositoryID.createForIDLTypes(this.cls, 1, 0);
                    this.IDLrepID = Convert.byteArrToAString(this.IDLrepIDbyte);
                    this.repositoryIDbyte = RepositoryID.createForRMITypes(this.cls);
                    this.repositoryID = Convert.byteArrToAString(this.repositoryIDbyte);
                } else {
                    this.repositoryIDbyte = RepositoryID.createForRMITypes(this.cls);
                    this.repositoryID = Convert.byteArrToAString(this.repositoryIDbyte);
                }
                this.processed = true;
            }
            catch (Exception ex) {
                Logger.traceError("RepositoryID.process()", Logger.exceptionTrace(ex));
                this.repositoryID = Convert.byteArrToAString(RepositoryID.createForIDLTypes(this.cls, 1, 0));
            }
        }
    }

    private static byte[] createHash(Class clas, byte[] b, int off) {
        RepositoryIDDescriptor descriptor = RepositoryIDDescriptor.get(clas);
        String hashC = null;
        String uid = null;
        byte[] hashCode = b;
        try {
            int i;
            long hash = descriptor.hashCode;
            long id = 0L;
            if (clas.isInterface() || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RepositoryID.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clas) || !(class$java$io$Serializable == null ? (class$java$io$Serializable = RepositoryID.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clas)) {
                int i2 = 0;
                while (i2 < 16) {
                    hashCode[i2 + off] = 48;
                    ++i2;
                }
                return hashCode;
            }
            if (hash == 0L) {
                int i3 = 0;
                while (i3 < 16) {
                    hashCode[i3 + off] = 48;
                    ++i3;
                }
                return hashCode;
            }
            if (hash == 1L) {
                i = 0;
                while (i < 15) {
                    hashCode[i + off] = 48;
                    ++i;
                }
                hashCode[15 + off] = 49;
            }
            id = descriptor.sUID;
            hashC = Long.toHexString(hash).toUpperCase();
            int lenHash = hashC.length();
            int dimHashC = 16 - lenHash;
            int i4 = 0;
            while (i4 < 16) {
                if (dimHashC > 0) {
                    hashCode[i4 + off] = 48;
                    --dimHashC;
                } else {
                    hashCode[i4 + off] = (byte)hashC.charAt(i4 - 16 + lenHash);
                }
                ++i4;
            }
            if (hash != id) {
                hashCode[16 + off] = 58;
                if (id == 0L) {
                    i = 17;
                    while (i < 33) {
                        hashCode[i + off] = 48;
                        ++i;
                    }
                } else if (id == 1L) {
                    i = 17;
                    while (i < 32) {
                        hashCode[i + off] = 48;
                        ++i;
                    }
                    hashCode[32 + off] = 49;
                } else {
                    uid = Long.toHexString(id).toUpperCase();
                    int lenUID = uid.length();
                    int dimUID = 16 - lenUID;
                    i4 = 0;
                    while (i4 < 16) {
                        if (dimUID > 0) {
                            hashCode[i4 + off + 17] = 48;
                            --dimUID;
                        } else {
                            hashCode[i4 + off + 17] = (byte)uid.charAt(i4 - 16 + lenUID);
                        }
                        ++i4;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.traceError("RepositoryID.createHash(Class, byte[], int)", Logger.exceptionTrace(e));
        }
        return hashCode;
    }

    public static byte[] createForRMITypes(Class clas) {
        RepositoryIDDescriptor descriptor = RepositoryIDDescriptor.get(clas);
        int len = clas.getName().length();
        byte[] repID = null;
        repID = (class$java$io$Serializable == null ? (class$java$io$Serializable = RepositoryID.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clas) && descriptor.sUID != descriptor.hashCode ? new byte[len + 38] : new byte[len + 21];
        repID[0] = 82;
        repID[1] = 77;
        repID[2] = 73;
        repID[3] = 58;
        repID = RepositoryID.convertToISOLatin1(clas.getName(), repID, 4);
        repID[RepositoryID.index] = 58;
        repID = RepositoryID.createHash(clas, repID, index + 1);
        return repID;
    }

    public static byte[] createSequenceRepID(Class clas) {
        RepositoryIDDescriptor descriptor = RepositoryIDDescriptor.get(clas);
        byte[] repID = null;
        int k = 0;
        Class<?> cls2 = clas;
        Class<?> cls3 = null;
        while ((cls3 = clas.getComponentType()) != null) {
            ++k;
            clas = cls3;
        }
        descriptor = RepositoryIDDescriptor.get(clas);
        if (clas.isPrimitive()) {
            String name = cls2.getName();
            int len = name.length();
            repID = new byte[21 + len];
            repID[0] = 82;
            repID[1] = 77;
            repID[2] = 73;
            repID[3] = 58;
            int i = 4;
            while (i < 4 + len) {
                repID[i] = (byte)name.charAt(i - 4);
                ++i;
            }
            repID[4 + len] = 58;
            int i2 = 5 + len;
            while (i2 < 21 + len) {
                repID[i2] = 48;
                ++i2;
            }
        } else {
            String name = clas.getName();
            int len = name.length();
            repID = (class$java$io$Serializable == null ? (class$java$io$Serializable = RepositoryID.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clas) && descriptor.sUID != descriptor.hashCode ? new byte[len + k + 40] : new byte[len + k + 23];
            repID[0] = 82;
            repID[1] = 77;
            repID[2] = 73;
            repID[3] = 58;
            int i = 0;
            while (k > 0) {
                repID[i + 4] = 91;
                --k;
                ++i;
            }
            repID[i + 4] = 76;
            repID = RepositoryID.convertToISOLatin1(clas.getName(), repID, i + 5);
            repID[RepositoryID.index] = 59;
            repID[RepositoryID.index + 1] = 58;
            repID = RepositoryID.createHash(clas, repID, index + 2);
        }
        return repID;
    }

    public static byte[] createForIDLTypes(Class clas, int i, int j) {
        String nameIDL = clas.getName();
        byte[] repID = new byte[nameIDL.length() + 8];
        try {
            repID[0] = 73;
            repID[1] = 68;
            repID[2] = 76;
            repID[3] = 58;
            repID = RepositoryID.convertToISOLatin1(nameIDL, repID, 4);
            if (nameIDL.endsWith("Exception")) {
                repID = RepositoryID.replaceForEx(nameIDL, "Exception", "Ex", repID, 4);
            }
            repID[RepositoryID.index] = 58;
            repID[RepositoryID.index + 1] = (byte)(48 + i);
            repID[RepositoryID.index + 2] = 46;
            repID[RepositoryID.index + 3] = (byte)(48 + j);
        }
        catch (Exception e) {
            Logger.traceError("RepositoryID.createForIDLTypes(Class, int, int)", Logger.exceptionTrace(e));
        }
        return repID;
    }

    public static String signature(Class clas) {
        String sign = null;
        if (clas.isArray()) {
            int k = 0;
            Class<?> cls3 = null;
            while ((cls3 = clas.getComponentType()) != null) {
                ++k;
                clas = cls3;
            }
            StringBuffer buffer = new StringBuffer();
            int j = 0;
            while (j < k) {
                buffer.append("[");
                ++j;
            }
            buffer.append(RepositoryID.signature(clas));
            sign = buffer.toString();
        } else if (clas.isPrimitive()) {
            if (clas == Integer.TYPE) {
                sign = "I";
            } else if (clas == Byte.TYPE) {
                sign = "B";
            } else if (clas == Long.TYPE) {
                sign = "J";
            } else if (clas == Float.TYPE) {
                sign = "F";
            } else if (clas == Double.TYPE) {
                sign = "D";
            } else if (clas == Short.TYPE) {
                sign = "S";
            } else if (clas == Character.TYPE) {
                sign = "C";
            } else if (clas == Boolean.TYPE) {
                sign = "Z";
            } else if (clas == Void.TYPE) {
                sign = "V";
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("L");
            buffer.append(clas.getName().replace('.', '/'));
            buffer.append(";");
            sign = buffer.toString();
        }
        return sign;
    }

    public static byte[] convertToISOLatin1(String s, byte[] b, int off) {
        int len = s.length();
        if (len == 0) {
            return new byte[0];
        }
        byte[] temp = b;
        int pos = off;
        int k = 0;
        int i = 0;
        while (i < len) {
            byte c = (byte)s.charAt(i);
            if (k == 0 && (c > 255 || IDL_IDENTIFIER_CHARS[c] == 0)) {
                int j = i;
                while (j < len) {
                    byte no = (byte)s.charAt(j);
                    if (no > 255 || IDL_IDENTIFIER_CHARS[no] == 0) {
                        ++k;
                        b[off + j] = 33;
                    } else {
                        b[off + j] = no;
                    }
                    ++j;
                }
                temp = new byte[b.length + k * 5];
                System.arraycopy(b, 0, temp, 0, b.length);
            }
            if (b[off + i] == 33) {
                temp[pos + i] = 92;
                temp[pos + i + 1] = 85;
                temp[pos + i + 2] = ASCII_HEX[(c & 0xF000) >>> 12];
                temp[pos + i + 3] = ASCII_HEX[(c & 0xF00) >>> 8];
                temp[pos + i + 4] = ASCII_HEX[(c & 0xF0) >>> 4];
                temp[pos + i + 5] = ASCII_HEX[c & 0xF];
                pos += 5;
            } else {
                temp[pos + i] = c;
            }
            ++i;
        }
        index = len + pos;
        return temp;
    }

    private static byte[] replaceForEx(String s, String s1, String s2, byte[] b, int off) {
        byte[] temp = b;
        int lenS1 = s1.length();
        int lenS2 = s2.length();
        int i = s.indexOf(s1);
        if (lenS1 != lenS2) {
            temp = new byte[b.length - lenS1 + lenS2];
            System.arraycopy(b, 0, temp, 0, Math.min(b.length, temp.length));
        }
        int j = 0;
        while (j < s.length() - lenS1 + lenS2) {
            if (j == i) {
                int k = j;
                while (k < lenS2) {
                    temp[off + k] = (byte)s2.charAt(k);
                    ++k;
                }
                j += lenS2 - 1;
            } else {
                temp[off + j] = b[off + j] == 46 ? 47 : (byte)s.charAt(j);
            }
            ++j;
        }
        index = off + j;
        return temp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IDL_IDENTIFIER_CHARS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1};
        ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    }
}

