/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.util;

import com.sap.engine.services.iiop.internal.util.IDFactoryItem;
import com.sap.engine.services.iiop.logging.Logger;

public class IDFactoryUnit {
    private IDFactoryItem[] list = null;
    private IDFactoryUnit nextUnit = null;
    private int count = 0;
    private int firstAvail = 0;
    private int ID = 0;

    protected IDFactoryUnit(int size, int ID) {
        this.list = new IDFactoryItem[size];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = new IDFactoryItem(i + 1);
            ++i;
        }
        this.list[this.list.length - 1].setNext(-1);
        this.ID = ID;
    }

    private IDFactoryUnit() {
    }

    protected IDFactoryItem get(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            String messageWithId = "ID019113: IDFactoryUnit::get() - requested index is negative ";
            Logger.traceDebug("IDFactoryUnit.get(int)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        if (index > this.list.length) {
            String messageWithId = "ID019114: IDFactoryUnit::get() - requested index is out of bounds ";
            Logger.traceDebug("IDFactoryUnit.get(int)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        return this.list[index];
    }

    protected int getFirstAvail() {
        return this.firstAvail;
    }

    protected void setFirstAvail(int first) {
        this.firstAvail = first;
    }

    public synchronized int getNextAvailableItemID() {
        if (this.firstAvail == -2) {
            String messageWithId = "ID019110: IDFactoryUnit::getNextAvailableItemID - item has been gotten";
            Logger.traceError("IDFactoryUnit.getNextAvailableItemID()", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        int id = this.firstAvail;
        IDFactoryItem item = this.list[this.firstAvail];
        this.firstAvail = item.getNext();
        item.setNext(-2);
        this.incCount();
        return id;
    }

    public synchronized void releaseItemID(int id) {
        IDFactoryItem item = this.list[id];
        if (item.getNext() != -2) {
            String messageWithId = "ID019110: IDFactoryUnit::releaseItemID - item has already been disposed";
            Logger.traceError("IDFactoryUnit.releaseItemID(int)", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        item.setMessage(null);
        item.setNext(this.firstAvail);
        this.decCount();
        this.firstAvail = id;
    }

    protected void incCount() {
        if (this.count == this.list.length) {
            String messageWithId = "ID019115: Count overflow";
            Logger.traceDebug("IDFactoryUnit.incCount()", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        ++this.count;
    }

    protected void decCount() {
        if (this.count == 0) {
            String messageWithId = "ID019116: Count is zero already";
            Logger.traceDebug("IDFactoryUnit.decCount()", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        --this.count;
    }

    protected int getCount() {
        return this.count;
    }

    protected int getID() {
        return this.ID;
    }

    protected IDFactoryUnit getNextUnit() {
        return this.nextUnit;
    }

    protected void setNextUnit(IDFactoryUnit unit) {
        this.nextUnit = unit;
    }

    public void notifyItems(int dispatcherId, int clientId) {
        int i = 0;
        while (i < this.list.length) {
            IDFactoryItem iDFactoryItem = this.list[i];
            synchronized (iDFactoryItem) {
                if (this.list[i].check(dispatcherId, clientId)) {
                    this.list[i].setMessage(null);
                    this.list[i].notify();
                }
            }
            ++i;
        }
        if (this.nextUnit != null) {
            this.nextUnit.notifyItems(dispatcherId, clientId);
        }
    }

    protected void refreshList() {
        if (this.firstAvail == -1) {
            return;
        }
        this.firstAvail = -1;
        int i = this.list.length - 1;
        while (i >= 0) {
            if (this.list[i].getNext() != -2) {
                if (this.firstAvail != -1) {
                    this.list[i].setNext(this.firstAvail);
                } else {
                    this.list[i].setNext(-1);
                }
                this.firstAvail = i;
            }
            --i;
        }
    }

    protected IDFactoryUnit resize(IDFactoryUnit old, int newSize) {
        return null;
    }

    public void printAvail() {
        if (this.getFirstAvail() == -1) {
            return;
        }
        int c = 0;
        int id = this.getFirstAvail();
        IDFactoryItem item = this.get(id);
        while (++c <= 200 && (id = item.getNext()) >= 0) {
            item = this.get(id);
        }
    }
}

