/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.interceptors;

import com.sap.engine.services.iiop.internal.interceptors.PICurrentImpl;
import java.util.HashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.InvalidSlot;

public class SlotTable {
    private HashMap slots = null;
    private ORB orb;
    private PICurrentImpl piCurrent = null;

    public SlotTable(ORB orb, PICurrentImpl piCurrent) {
        this.orb = orb;
        this.piCurrent = piCurrent;
        this.slots = new HashMap();
    }

    public SlotTable(ORB orb, PICurrentImpl piCurrent, HashMap slots) {
        this.orb = orb;
        this.piCurrent = piCurrent;
        this.slots = (HashMap)slots.clone();
    }

    public SlotTable copy() {
        return new SlotTable(this.orb, this.piCurrent, this.slots);
    }

    public Any get_slot(int slotID) throws InvalidSlot {
        if (slotID >= 0 && slotID < this.piCurrent.getSlotsCount()) {
            Integer key = new Integer(slotID);
            Any any = (Any)this.slots.get(key);
            if (any == null) {
                any = this.orb.create_any();
                this.slots.put(key, any);
            }
            return any;
        }
        throw new InvalidSlot("Invalid slot ID: " + slotID);
    }

    public void set_slot(int slotID, Any any) throws InvalidSlot {
        if (slotID < 0 || slotID >= this.piCurrent.getSlotsCount()) {
            throw new InvalidSlot("Invalid slot ID: " + slotID);
        }
        this.slots.put(new Integer(slotID), any);
    }

    protected PICurrentImpl getPICurrent() {
        return this.piCurrent;
    }

    protected void setPICurrent(PICurrentImpl pic) {
        this.piCurrent = pic;
    }

    protected void setORB(ORB orb) {
        this.orb = orb;
    }

    protected ORB getORB() {
        return this.orb;
    }
}

