/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.interceptors;

import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.iiop.internal.interceptors.SlotTable;
import com.sap.engine.services.iiop.internal.interceptors.SlotTableKey;
import com.sap.engine.services.iiop.server.CorbaServiceFrame;
import java.util.WeakHashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public class PICurrentImpl
extends LocalObject
implements Current {
    private static final String SLOT_TABLE_KEY = "slot_table";
    private com.sap.engine.services.iiop.CORBA.ORB orb = null;
    private int slotCounter = 0;
    private WeakHashMap slotTables = new WeakHashMap();

    public PICurrentImpl(com.sap.engine.services.iiop.CORBA.ORB orb) {
        this.orb = orb;
    }

    public void set_slot(int slotID, Any any) throws InvalidSlot {
        if (!this.orb.isInitialized()) {
            throw new BAD_INV_ORDER(10, CompletionStatus.COMPLETED_MAYBE);
        }
        SlotTable table = this.getThreadSlotTable();
        table.set_slot(slotID, any);
    }

    public Any get_slot(int slotID) throws InvalidSlot {
        if (this.orb.isInitialized()) {
            SlotTable table = this.getThreadSlotTable();
            return table.get_slot(slotID);
        }
        throw new BAD_INV_ORDER(10, CompletionStatus.COMPLETED_MAYBE);
    }

    public synchronized int allocateSlotId() {
        return this.slotCounter++;
    }

    public int getSlotsCount() {
        return this.slotCounter;
    }

    public SlotTable getThreadSlotTable() {
        SlotTable threadSlotTable = null;
        SlotTableKey threadSlotTableKey = null;
        try {
            if (this.orb.isServerORB()) {
                threadSlotTableKey = (SlotTableKey)CorbaServiceFrame.getThreadSystem().getThreadContext().getContextObject(SLOT_TABLE_KEY);
            } else {
                threadSlotTableKey = (SlotTableKey)ClientFactory.getThreadContextFactory().getThreadContext().getContextObject(SLOT_TABLE_KEY);
                if (threadSlotTableKey == null) {
                    threadSlotTableKey = new SlotTableKey();
                    ClientFactory.getThreadContextFactory().getThreadContext().setContextObject(SLOT_TABLE_KEY, threadSlotTableKey);
                }
            }
            threadSlotTable = (SlotTable)this.slotTables.get(threadSlotTableKey);
            if (threadSlotTable == null) {
                threadSlotTable = new SlotTable((ORB)this.orb, this);
                this.slotTables.put(threadSlotTableKey, threadSlotTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return threadSlotTable;
    }

    public void finalize() {
        if (this.orb.isServerORB()) {
            CorbaServiceFrame.getThreadSystem().getThreadContext().unregisterContextObject(SLOT_TABLE_KEY);
        }
    }

    static {
        if (System.getProperty("org.omg.CORBA.ORBSingletonClass", "").equals("com.sap.engine.system.ORBSingletonProxy")) {
            try {
                SlotTableKey key = new SlotTableKey();
                ThreadSystem ts = CorbaServiceFrame.getThreadSystem();
                ts.registerContextObject(SLOT_TABLE_KEY, key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

