/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.interceptors;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorsStorage {
    static final int CLIENT_INTERCEPTOR_TYPE = 0;
    static final int SERVER_INTERCEPTOR_TYPE = 1;
    static final int IOR_INTERCEPTOR_TYPE = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{class$org$omg$PortableInterceptor$ClientRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ClientRequestInterceptor = InterceptorsStorage.class$("org.omg.PortableInterceptor.ClientRequestInterceptor")) : class$org$omg$PortableInterceptor$ClientRequestInterceptor, class$org$omg$PortableInterceptor$ServerRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ServerRequestInterceptor = InterceptorsStorage.class$("org.omg.PortableInterceptor.ServerRequestInterceptor")) : class$org$omg$PortableInterceptor$ServerRequestInterceptor, class$org$omg$PortableInterceptor$IORInterceptor == null ? (class$org$omg$PortableInterceptor$IORInterceptor = InterceptorsStorage.class$("org.omg.PortableInterceptor.IORInterceptor")) : class$org$omg$PortableInterceptor$IORInterceptor};
    private static Interceptor[][] interceptors = new Interceptor[3][];
    private static WeakHashMap local_interceptors = new WeakHashMap();
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ClientRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ServerRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$IORInterceptor;

    public static void register_client_interceptor(Interceptor interceptor) throws DuplicateName {
        InterceptorsStorage.register_interceptor(interceptor, 0);
    }

    public static void register_server_interceptor(Interceptor interceptor) throws DuplicateName {
        InterceptorsStorage.register_interceptor(interceptor, 1);
    }

    public static void register_ior_interceptor(Interceptor interceptor) throws DuplicateName {
        InterceptorsStorage.register_interceptor(interceptor, 2);
    }

    public static Interceptor[] getClientInterceptors() {
        return interceptors[0];
    }

    public static Interceptor[] getServerInterceptors() {
        return interceptors[1];
    }

    public static Interceptor[] getIORInterceptors() {
        return interceptors[2];
    }

    public static Interceptor[] getClientInterceptors(ORB orb) {
        return InterceptorsStorage.get_local_interceptors(orb)[0];
    }

    public static Interceptor[] getServerInterceptors(ORB orb) {
        return InterceptorsStorage.get_local_interceptors(orb)[1];
    }

    public static Interceptor[] getIORInterceptors(ORB orb) {
        return InterceptorsStorage.get_local_interceptors(orb)[2];
    }

    public static void destroyAll() {
        int i = 0;
        while (i < interceptors.length) {
            int j = 0;
            while (j < interceptors[i].length) {
                interceptors[i][j].destroy();
                ++j;
            }
            ++i;
        }
        Collection coll = ((AbstractMap)local_interceptors).values();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            Interceptor[][] buff = (Interceptor[][])iterator.next();
            int i2 = 0;
            while (i2 < interceptors.length) {
                int j = 0;
                while (j < buff[i2].length) {
                    buff[i2][j].destroy();
                    ++j;
                }
                ++i2;
            }
        }
    }

    public static void register_client_interceptor(ORB orb, Interceptor interceptor) throws DuplicateName {
        Interceptor[][] buff = InterceptorsStorage.get_local_interceptors(orb);
        buff[0] = InterceptorsStorage.register_interceptor(interceptor, buff[0], 0);
        local_interceptors.put(orb, buff);
    }

    public static void register_server_interceptor(ORB orb, Interceptor interceptor) throws DuplicateName {
        Interceptor[][] buff = InterceptorsStorage.get_local_interceptors(orb);
        buff[1] = InterceptorsStorage.register_interceptor(interceptor, buff[1], 1);
        local_interceptors.put(orb, buff);
    }

    public static void register_ior_interceptor(ORB orb, Interceptor interceptor) throws DuplicateName {
        Interceptor[][] buff = InterceptorsStorage.get_local_interceptors(orb);
        buff[2] = InterceptorsStorage.register_interceptor(interceptor, buff[2], 2);
        local_interceptors.put(orb, buff);
    }

    private static Interceptor[][] get_local_interceptors(ORB orb) {
        Interceptor[][] buff = (Interceptor[][])local_interceptors.get(orb);
        if (buff == null) {
            buff = new Interceptor[][]{new ClientRequestInterceptor[0], new ServerRequestInterceptor[0], new IORInterceptor[0]};
        }
        return buff;
    }

    private static void register_interceptor(Interceptor interceptor, int type) throws DuplicateName {
        InterceptorsStorage.interceptors[type] = InterceptorsStorage.register_interceptor(interceptor, interceptors[type], type);
    }

    private static Interceptor[] register_interceptor(Interceptor interceptor, Interceptor[] alias_interceptors, int type) throws DuplicateName {
        String interceptorName = interceptor.name();
        boolean anonymous = interceptorName.equals("");
        boolean foundDuplicate = false;
        if (!anonymous) {
            int i = 0;
            while (i < alias_interceptors.length) {
                if (alias_interceptors[i].name().equals(interceptorName)) {
                    foundDuplicate = true;
                    break;
                }
                ++i;
            }
        }
        if (!foundDuplicate) {
            Class classType = classTypes[type];
            Interceptor[] replacementArray = (Interceptor[])Array.newInstance(classType, alias_interceptors.length + 1);
            int index = 0;
            while (index < alias_interceptors.length && alias_interceptors[index].name().compareTo(interceptorName) < 0) {
                replacementArray[index] = alias_interceptors[index];
                ++index;
            }
            replacementArray[index++] = interceptor;
            while (index < replacementArray.length) {
                replacementArray[index] = alias_interceptors[index - 1];
                ++index;
            }
            return replacementArray;
        }
        throw new DuplicateName(interceptorName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int type = 0;
        while (type < 3) {
            Class classType = classTypes[type];
            InterceptorsStorage.interceptors[type] = (Interceptor[])Array.newInstance(classType, 0);
            ++type;
        }
    }
}

