/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.giop;

import com.sap.engine.services.iiop.CORBA.GIOPMessageConstants;
import com.sap.engine.services.iiop.internal.giop.ClientReply;
import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.internal.giop.IncomingRequest;
import com.sap.engine.services.iiop.internal.giop.TaggedProfile;
import com.sap.engine.services.iiop.logging.Logger;
import java.util.Arrays;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.ObjectImpl;

public class IncomingRequest_1_2
extends IncomingRequest {
    protected byte[] object_key = null;

    protected IncomingRequest_1_2(byte[] binaryData) {
        super(binaryData);
        this.set_minor_version(2);
    }

    public byte[] object_id() {
        return this.object_key;
    }

    protected void readGIOPHeader() {
        this.versionMajor = this.data[4];
        this.versionMinor = this.data[5];
        int order = this.data[6] & 1;
        this.littleEndian = order != 0;
        int fragment = this.data[6] & 2;
        this.isFragmented = fragment != 0;
        this.reset(12);
    }

    protected void readMessageHeader() {
        this.request_id = this.read_long();
        this.response = this.unaligned_read_octet() == 3;
        this.unaligned_read_octet();
        this.unaligned_read_octet();
        this.unaligned_read_octet();
        short addressinDisposition = this.read_short();
        switch (addressinDisposition) {
            case 0: {
                int s = this.read_long();
                this.object_key = new byte[s];
                this.read_octet_array(this.object_key, 0, this.object_key.length);
                break;
            }
            case 1: {
                this.read_long();
                int size = this.unaligned_read_long();
                this.setPos(this.getPos() + size);
                break;
            }
            case 2: {
                this.read_string();
                int sizeTagged = this.read_long();
                TaggedProfile[] tp = new TaggedProfile[sizeTagged];
                int j = 0;
                while (j < sizeTagged) {
                    int id = this.read_long();
                    byte[] buf = new byte[this.unaligned_read_long()];
                    this.read_octet_array(buf, 0, buf.length);
                    tp[j] = new TaggedProfile(id, buf);
                    ++j;
                }
                break;
            }
            default: {
                int s = this.read_long();
                this.object_key = new byte[s];
                this.read_octet_array(this.object_key, 0, this.object_key.length);
            }
        }
        this.operation = this.read_string();
        if (Arrays.equals(this.object_key, GIOPMessageConstants.NAME_SERVICE_BYTES)) {
            this.targetHolder = ConnectionParser.orb.getNamingServant();
        } else {
            this.targetHolder = ConnectionParser.orb.getServant(this.object_key);
            this.in_target = (ObjectImpl)ConnectionParser.orb.getObject(this.object_key);
        }
        this.requestContexts = this.readServiceContexts();
        try {
            this.align(8);
        }
        catch (MARSHAL marshal) {
            Logger.traceDebug("IncomingRequest_1_2.readMessageHeader()", Logger.exceptionTrace(marshal));
            return;
        }
    }

    protected ClientReply createLocalServerReply() {
        ClientReply_1_2 rep = new ClientReply_1_2();
        rep.set_minor_version(this.minorVersion);
        return rep;
    }

    public class ClientReply_1_2
    extends ClientReply {
        protected ClientReply_1_2() {
            this.versionMajor = 1;
            this.versionMinor = (byte)2;
            this.target = IncomingRequest_1_2.this.targetHolder == null ? null : (ObjectImpl)IncomingRequest_1_2.this.targetHolder.getObject();
            this.ocsChooser = IncomingRequest_1_2.this.icsChooser;
            this.set_minor_version(2);
        }

        protected void writeGIOPHeader() {
            this.data[0] = 71;
            this.data[1] = 73;
            this.data[2] = 79;
            this.data[3] = 80;
            this.data[4] = this.versionMajor;
            this.data[5] = this.versionMinor;
            this.data[6] = this.littleEndian ? (byte)1 : 0;
            this.data[7] = 1;
            int size = this.index;
            this.index = 8;
            this.write_long(size - 12);
            this.index = size;
        }

        protected void writeExceptionMessageHeader(byte type) {
            this.write_long(IncomingRequest_1_2.this.request_id);
            this.write_long(type);
            this.writeServiceContexts(this.replyContexts);
            this.align(8);
        }

        protected void writeMessageHeader() {
            this.writeExceptionMessageHeader((byte)0);
        }
    }
}

