/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.giop;

import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.internal.giop.IncomingMessage;
import com.sap.engine.services.iiop.internal.giop.NoReplyMessage;
import com.sap.engine.services.iiop.internal.giop.OutgoingMessage;
import com.sap.engine.services.iiop.internal.util.IDFactoryItem;
import com.sap.engine.services.iiop.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;

public abstract class IncomingReply
extends IncomingMessage {
    protected int request_id;
    protected int status;
    public ServiceContext[] replyContexts;
    protected ORB ownORB;

    protected IncomingReply(byte[] binaryData) {
        super(binaryData);
    }

    protected void process() {
        this.readMessageHeader();
        try {
            IDFactoryItem item = ConnectionParser.orb.getIDFactory().get(this.request_id);
            item.setMessage(this);
            IDFactoryItem iDFactoryItem = item;
            synchronized (iDFactoryItem) {
                item.notify();
            }
        }
        catch (Exception e) {
            Logger.traceError("IncommingReply.process()", Logger.exceptionTrace(e));
        }
    }

    public int getRequestId() {
        return this.request_id;
    }

    public int getStatus() {
        return this.status;
    }

    public OutgoingMessage getServerReply() {
        return NoReplyMessage._this;
    }

    public int request_id() {
        return this.request_id;
    }

    public byte[] object_id() {
        return null;
    }

    public String operation() {
        return null;
    }

    public boolean response_expected() {
        return false;
    }
}

