/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.TSIdentificationImpl;
import com.sap.engine.services.iiop.CORBA.interceptors.ORBInitInfoImpl;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.internal.ClientORB;
import com.sap.engine.services.iiop.internal.NameServiceHolder;
import com.sap.engine.services.iiop.internal.util.IDFactory;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.CorbaServiceFrame;
import com.sap.engine.services.iiop.system.CommunicationLayer;
import com.sap.engine.services.jndi.cosnaming.NamingContextExtImpl;
import java.util.Properties;
import javax.jts.TransactionService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.TSIdentification;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableInterceptor.ORBInitializer;

public class ORB
extends ClientORB {
    public ORB() {
        super(null);
        Logger.traceDebug("ORB.ORB()", "InQMy ORB, multiple server threads.");
        if (ClientORB.idFac == null) {
            ClientORB.idFac = new IDFactory();
        }
    }

    protected void set_parameters(String[] args, Properties props) {
        props = props == null ? CorbaServiceFrame.getDefaultProperties() : this.cutProperties(props);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(com.sap.engine.services.iiop.CORBA.ORB.initialArguments[0])) {
                    try {
                        this.initialPort = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException e) {
                        this.initialPort = 900;
                    }
                } else if (args[i].equals(com.sap.engine.services.iiop.CORBA.ORB.initialArguments[1])) {
                    this.initialHost = args[++i];
                } else {
                    Logger.logError("Invalid startup parameter: " + args[i]);
                }
                ++i;
            }
        }
        if (props != null) {
            String s1 = props.getProperty("org.omg.CORBA.ORBInitialPort");
            if (s1 != null) {
                try {
                    this.initialPort = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberformatexception) {
                    this.initialPort = 900;
                }
            }
            if ((s1 = props.getProperty("org.omg.CORBA.ORBInitialHost")) != null) {
                this.initialHost = s1;
            }
            s1 = props.getProperty("GIOPVersionMinor", "1");
            this.versionMinor = Byte.parseByte(s1);
        }
        this.isInitialized = false;
        ORBInitializer[] orbInitializers = this.registerORBInitializers(props);
        if (orbInitializers != null) {
            ORBInitInfoImpl orbInitInfo = new ORBInitInfoImpl((org.omg.CORBA.ORB)this, args, ClientORB.orbId, ClientORB.codecFactory, false);
            this.preInitORBInitializers(orbInitInfo, orbInitializers);
            this.postInitORBInitializers(orbInitInfo, orbInitializers);
        }
        this.isInitialized = true;
    }

    public void set_(String[] args, Properties props) {
        try {
            InitialContext ctx = new InitialContext();
            TransactionService ts = (TransactionService)ctx.lookup("TransactionService");
            TSIdentificationImpl tsIdentification = new TSIdentificationImpl();
            ts.identifyORB((org.omg.CORBA.ORB)this, (TSIdentification)tsIdentification, new Properties());
        }
        catch (NamingException nex) {
            Logger.traceError("ORB.set_(String[], Properties)", Logger.exceptionTrace(nex));
        }
        String cn = props.getProperty("CommunicationLayerClass");
        ClientORB.communicationLayer = CommunicationLayer.init(cn, this);
        if (props.getProperty("IDFactoryUnitSize") != null && props.getProperty("IDFactoryMaxUnits") != null) {
            int newUnitSize = Integer.parseInt(props.getProperty("IDFactoryUnitSize"));
            int newMaxUnits = Integer.parseInt(props.getProperty("IDFactoryMaxUnits"));
            ClientORB.idFac.resize(newUnitSize, newMaxUnits);
        }
        this.isInitialized = false;
        ORBInitializer[] orbInitializers = this.registerORBInitializers(SystemProperties.getProperties());
        if (orbInitializers != null) {
            ORBInitInfoImpl orbInitInfo = new ORBInitInfoImpl((org.omg.CORBA.ORB)this, args, ClientORB.orbId, ClientORB.codecFactory, true);
            this.preInitORBInitializers(orbInitInfo, orbInitializers);
            this.postInitORBInitializers(orbInitInfo, orbInitializers);
        }
        this.isInitialized = true;
    }

    public IDFactory getIDFactory() {
        return ClientORB.idFac;
    }

    public void connect(Object obj) {
        ObjectImpl oi = (ObjectImpl)obj;
        try {
            DelegateImpl di = (DelegateImpl)oi._get_delegate();
            if (di.isConnected()) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] objkey = this.getObjectKey(CorbaServiceFrame.getClusterId());
        String[] ids = oi._ids();
        try {
            String host = "localhost";
            int port = 3333;
            try {
                String url = ClientORB.communicationLayer.getURL()[0];
                int idx = url.indexOf("@") + 1;
                int idy = url.indexOf(":", idx);
                if (idy < 0) {
                    host = url.substring(idx);
                } else {
                    host = url.substring(idx, idy);
                    port = Integer.parseInt(url.substring(idy + 1));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (Logger.beWarning()) {
                    Logger.traceWarning("ORB.connect(org.omg.CORBA.Object)", Logger.exceptionTrace(e));
                }
                Logger.logWarning("IIOP Service is not started on dispatcher !");
            }
            catch (Exception e) {
                Logger.traceError("ORB.connect(org.omg.CORBA.Object)", Logger.exceptionTrace(e));
            }
            IOR ior = new IOR((org.omg.CORBA.ORB)this, ids[0], host, port, objkey);
            if (this.versionMinor != 1) {
                ior.getProfile().setVersion((byte)1, this.versionMinor);
            }
            DelegateImpl d = new DelegateImpl(this, ior);
            oi._set_delegate((Delegate)d);
            ClientORB.table.put(objkey, obj);
            d.setConnected(true);
        }
        catch (NumberFormatException e) {
            Logger.traceError("ORB.connect(org.omg.CORBA.Object)", Logger.exceptionTrace(e));
        }
        Logger.traceDebug("ORB.connect(org.omg.CORBA.Object)", "Connection of the servant object to the ORB passed successfully");
    }

    public boolean isServerORB() {
        return true;
    }

    protected void initCosNaming() {
        if (ClientORB.cosNaming == null) {
            ClientORB.cosNaming = new NamingContextExtImpl();
            ClientORB.namingServant = new NameServiceHolder((InvokeHandler)ClientORB.cosNaming);
            this.connect((Object)ClientORB.cosNaming);
        }
    }

    public void shutdown(boolean com) {
        super.shutdown(com);
    }
}

