/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.dispatcher.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.iiop.dispatcher.CorbaSessionProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DumpStreamsCommand
implements Command {
    private CorbaSessionProcessor processor;

    public DumpStreamsCommand(CorbaSessionProcessor processor) {
        this.processor = processor;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 0 || params[0].equalsIgnoreCase("-true")) {
            this.processor.setDumpStreams(true);
        } else if (params[0].equalsIgnoreCase("-false")) {
            this.processor.setDumpStreams(false);
        } else {
            pw.println(this.getHelpMessage());
            return;
        }
    }

    public String getHelpMessage() {
        return "Dumps in log file content of iiop requests and replays..\nUsage: TRACEIIOP  [-true | -false] \nParameters:\n   [-true | -false] - \"true\" to start dumping of content of iiop requests and replays, \"flase\" to switch off dumping.\n   If there is no parameter, it's similar situation like parameter \"-true\"";
    }

    public String getName() {
        return "TRACEIIOP";
    }

    public String getGroup() {
        return "IIOP";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

