/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.dispatcher;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationConnection;
import com.sap.engine.frame.cluster.session.ClientConnection;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.cluster.session.ConnectionMonitor;
import com.sap.engine.frame.cluster.session.Data;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.iiop.dispatcher.CORBAConnMetaData;
import com.sap.engine.services.iiop.dispatcher.CorbaServiceFrame;
import com.sap.engine.services.iiop.dispatcher.GIOPConstants;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

public class CorbaSessionProcessor
implements CommunicationSessionProcessor,
GIOPConstants {
    public static final byte[] INIT_REQUEST_OPERATION = "INIT".getBytes();
    public static final byte[] NAME_SERVICE_OPERATION = "NameService".getBytes();
    private static final boolean NEW_SESSION = false;
    private static final boolean END_SESSION = true;
    private int initialCtxPort = 0;
    protected Hashtable initialCtx = new Hashtable();
    private boolean dumpStreams = false;

    public CorbaSessionProcessor(int initialCtxPort) {
        this.initialCtxPort = initialCtxPort;
    }

    public void setDumpStreams(boolean dumpStreams) {
        this.dumpStreams = dumpStreams;
    }

    public void parseRequest(Connection c, ApplicationConnection app, ClientConnection client) {
        CORBAConnMetaData info = (CORBAConnMetaData)c.getPrivateData();
        if (info.newSession) {
            this.parseMessageHeader(c);
            try {
                Data data;
                if (this.dumpStreams) {
                    data = c.getRequestData();
                    Logger.logInfo("\r\nINCOMMING : \r\n" + CorbaSessionProcessor.toString(data.getBytes(), 0, data.getLength() + data.getOffset()));
                } else if (Logger.beDebug()) {
                    data = c.getRequestData();
                    Logger.traceDebug("CorbaSessionProcessor.parseRequest(Connection, ApplicationConnection, ClientConnection)", "\r\nINCOMMING : \r\n" + CorbaSessionProcessor.toString(data.getBytes(), 0, data.getLength() + data.getOffset()));
                }
                if (info.isFragmented) {
                    try {
                        app.sendInQueue(c, 30000L);
                    }
                    catch (Exception e) {
                        Logger.traceError("CorbaSessionProcessor.parseRequest(Connection, ApplicationConnection, ClientConnection)", Logger.exceptionTrace(e));
                    }
                    info.isFragmented = false;
                } else if (info.msgType == 1) {
                    app.sendInQueue(c, 0L);
                } else {
                    app.send(c);
                }
                info.newSession = false;
            }
            catch (Exception ex) {
                c.setDestinationId(CorbaServiceFrame.getLessBusyElement());
                try {
                    if (info.isFragmented) {
                        app.sendInQueue(c, 30000L);
                    } else if (info.msgType == 1) {
                        app.sendInQueue(c, 0L);
                    } else {
                        app.send(c);
                    }
                }
                catch (ClusterException e) {
                    Logger.traceError("CorbaSessionProcessor.parseRequest(Connection, ApplicationConnection, ClientConnection)", Logger.exceptionTrace(ex));
                    Logger.logError("Connection problem... " + Logger.exceptionTrace(ex));
                    c.closeConnection();
                }
                info.newSession = false;
            }
            c.setPackSize(12);
        } else {
            this.parseGIOPHeader(c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void parseReply(Connection c, ApplicationConnection app, ClientConnection client) {
        Data data;
        while ((data = c.getReplyData()) != null) {
            byte[] dumpBytes;
            void var5_5;
            byte[] toSend = var5_5.getBytes();
            if (this.dumpStreams) {
                dumpBytes = new byte[var5_5.getLength()];
                System.arraycopy(var5_5.getBytes(), var5_5.getOffset(), dumpBytes, 0, dumpBytes.length);
                Logger.logInfo("\r\nOUTGOING : \r\n" + CorbaSessionProcessor.toString(dumpBytes, 0, dumpBytes.length));
            } else if (Logger.beDebug()) {
                dumpBytes = new byte[var5_5.getLength()];
                System.arraycopy(var5_5.getBytes(), var5_5.getOffset(), dumpBytes, 0, dumpBytes.length);
                Logger.traceDebug("CorbaSessionProcessor.parseReply(Connection, ApplicationConnection, ClientConnection)", "\r\nOUTGOING : \r\n" + CorbaSessionProcessor.toString(dumpBytes, 0, dumpBytes.length));
            }
            client.send(c, toSend, var5_5.getOffset(), var5_5.getLength());
            if (c.getDestinationId() != -1) continue;
            c.setDestinationId(CorbaServiceFrame.connIDHolder.get(c.getConnectionId()));
            c.startClientRequestReader();
            CorbaServiceFrame.connIDHolder.remove(c.getConnectionId());
        }
    }

    public void initialize(Connection c, ConnectionMonitor monitor) {
        Socket socket = monitor.getSocket();
        int port = socket.getLocalPort();
        if (port == this.initialCtxPort) {
            try {
                InputStream in = monitor.getInputStream();
                int b = in.read();
                if (b == -1) {
                    throw new IOException("");
                }
                int count = 0;
                byte[] body = new byte[b];
                while (count != b) {
                    int read = in.read(body, count, b - count);
                    if (read == -1) {
                        in.close();
                        throw new IOException("");
                    }
                    count += read;
                }
                int lessBusy = CorbaServiceFrame.getLessBusyElement();
                if (lessBusy == -1) {
                    c.closeConnection();
                } else {
                    byte[] ior = (byte[])this.initialCtx.get(lessBusy + ":" + Convert.byteArrToUString(body));
                    OutputStream out = monitor.getOutputStream();
                    out.write(ior);
                    c.closeConnection();
                }
            }
            catch (Exception ex) {
                Logger.traceError("CorbaSessionProcessor.initialize(Connection, ConnectionMonitor)", Logger.exceptionTrace(ex));
                Logger.logError("Connection can't initialize... " + Logger.exceptionTrace(ex));
                try {
                    socket.close();
                }
                catch (IOException e) {
                    c.closeConnection();
                }
            }
        }
        if (CorbaServiceFrame.connIDHolder.contains(c.getConnectionId()) && CorbaServiceFrame.connIDHolder.get(c.getConnectionId()) != 0) {
            c.stopClientRequestReader();
        }
        CORBAConnMetaData info = new CORBAConnMetaData();
        info.newSession = false;
        c.setPrivateData(info);
        c.setPackSize(12);
    }

    public void fail(Connection c, ConnectionMonitor monitor) {
        Enumeration keys = CorbaServiceFrame.connections.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (((Integer)CorbaServiceFrame.connections.get(key)).intValue() != c.getConnectionId()) continue;
            this.notifyCluster(key, c.getConnectionId());
            CorbaServiceFrame.connections.remove(key);
            break;
        }
    }

    private void notifyCluster(String key, int connectionId) {
        byte[] msg = new byte[4];
        Convert.writeIntToByteArr(msg, 0, connectionId);
        int destinationId = new Integer(key.substring(0, key.indexOf(":")));
        try {
            CorbaServiceFrame.msgContext.send(destinationId, 55, msg, 0, msg.length);
        }
        catch (ClusterException cex) {
            Logger.logWarning("May be " + destinationId + " cluster node isn't informed for a failed connection. Original exception : \n" + Logger.exceptionTrace((Throwable)((Object)cex)));
            return;
        }
    }

    private void parseGIOPHeader(Connection c) {
        Data data = c.getRequestData();
        byte[] msg = data.getBytes();
        int offset = data.getOffset();
        int i = 0;
        i = 0;
        while (i < 4) {
            if (msg[offset + i] != GIOPConstants.MAGIC[i]) {
                // empty if block
            }
            ++i;
        }
        if (msg[offset + i++] < 1) {
            // empty if block
        }
        byte minorVersion = msg[offset + i++];
        byte endian = msg[offset + i++];
        if (minorVersion != 0) {
            endian = (byte)(endian & 1);
        }
        ++i;
        int msgSize = 0;
        if (endian == 0) {
            msgSize = msg[offset + i++] << 24 & 0xFF000000;
            msgSize |= msg[offset + i++] << 16 & 0xFF0000;
            msgSize |= msg[offset + i++] << 8 & 0xFF00;
            msgSize |= msg[offset + i++] & 0xFF;
        } else {
            msgSize = msg[offset + i++] & 0xFF;
            msgSize |= msg[offset + i++] << 8 & 0xFF00;
            msgSize |= msg[offset + i++] << 16 & 0xFF0000;
            msgSize |= msg[offset + i++] << 24 & 0xFF000000;
        }
        CORBAConnMetaData info = (CORBAConnMetaData)c.getPrivateData();
        info.newSession = true;
        c.setPackSize(msgSize);
    }

    private void parseMessageHeader(Connection c) {
        Data data = c.getRequestData();
        byte[] message = data.getBytes();
        CORBAConnMetaData meta = (CORBAConnMetaData)c.getPrivateData();
        meta.isFragmented = (message[6] & 2) != 0;
        meta.msgType = message[7];
        block0 : switch (meta.msgType) {
            case 0: {
                switch (message[5]) {
                    case 0: {
                        this.parseRequestMessage_1_0(c);
                        break;
                    }
                    case 1: {
                        this.parseRequestMessage_1_1(c);
                        break;
                    }
                    case 2: {
                        this.parseRequestMessage_1_2(c);
                    }
                }
                break;
            }
            case 1: {
                switch (message[5]) {
                    case 0: {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                switch (message[5]) {
                    case 0: {
                        this.parseLocateRequestMessage_1_0(c);
                        break;
                    }
                    case 1: {
                        this.parseLocateRequestMessage_1_0(c);
                        break;
                    }
                    case 2: {
                        this.parseLocateRequestMessage_1_2(c);
                    }
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                c.closeConnection();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                meta = (CORBAConnMetaData)c.getPrivateData();
                meta.isFragmented = true;
                break;
            }
            default: {
                c.closeConnection();
            }
        }
    }

    public boolean memoryWarning(Connection cc, ApplicationConnection application, ClientConnection client, boolean forced) {
        return false;
    }

    private void parseRequestMessage_1_0(Connection connection) {
        int afterServiceContext;
        byte[] msg = connection.getRequestData().getBytes();
        int keyPosition = 12;
        keyPosition = afterServiceContext = this.getEndPositionOfServiceContext(msg, 12);
        keyPosition = this.align(keyPosition, 4);
        keyPosition += 4;
        this.analyseKey(connection, msg, ++keyPosition);
    }

    private void parseRequestMessage_1_1(Connection connection) {
        int afterServiceContext;
        byte[] msg = connection.getRequestData().getBytes();
        int keyPosition = 12;
        keyPosition = afterServiceContext = this.getEndPositionOfServiceContext(msg, 12);
        keyPosition = this.align(keyPosition, 4);
        keyPosition += 4;
        ++keyPosition;
        this.analyseKey(connection, msg, keyPosition += 3);
    }

    private void parseRequestMessage_1_2(Connection connection) {
        byte[] msg = connection.getRequestData().getBytes();
        int keyPosition = 12;
        keyPosition = this.align(keyPosition, 4);
        keyPosition += 4;
        ++keyPosition;
        keyPosition += 3;
        keyPosition = this.align(keyPosition, 4);
        int addressinDisposition = this.read_long(msg, keyPosition, msg[6]);
        keyPosition += 4;
        switch (addressinDisposition) {
            case 0: {
                this.analyseKey(connection, msg, keyPosition);
                break;
            }
            case 1: {
                System.out.println(" SENDED Profile");
                break;
            }
            case 2: {
                System.out.println(" SENDED Reference");
                break;
            }
            default: {
                this.analyseKey(connection, msg, keyPosition);
            }
        }
    }

    private void parseLocateRequestMessage_1_0(Connection connection) {
        byte[] msg = connection.getRequestData().getBytes();
        int keyPosition = 12;
        keyPosition = this.align(keyPosition, 4);
        this.analyseKey(connection, msg, keyPosition += 4);
    }

    private void parseLocateRequestMessage_1_2(Connection connection) {
        byte[] msg = connection.getRequestData().getBytes();
        int keyPosition = 12;
        keyPosition = this.align(keyPosition, 4);
        int addressinDisposition = this.read_long(msg, keyPosition += 4, msg[6]);
        keyPosition += 4;
        switch (addressinDisposition) {
            case 0: {
                this.analyseKey(connection, msg, keyPosition);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.analyseKey(connection, msg, keyPosition);
            }
        }
    }

    private int read_long(byte[] data, int offset, byte endian) {
        int b1;
        int b2;
        int b3;
        int b4;
        int index = this.align(offset, 4);
        if ((endian & 1) == 1) {
            b4 = data[index++] << 0 & 0xFF;
            b3 = data[index++] << 8 & 0xFF00;
            b2 = data[index++] << 16 & 0xFF0000;
            b1 = data[index++] << 24 & 0xFF000000;
        } else {
            b1 = data[index++] << 24 & 0xFF000000;
            b2 = data[index++] << 16 & 0xFF0000;
            b3 = data[index++] << 8 & 0xFF00;
            b4 = data[index++] << 0 & 0xFF;
        }
        return b1 | b2 | b3 | b4;
    }

    private int align(int offset, int i) {
        int cnt = i + (offset - 1) & ~(i - 1);
        return cnt;
    }

    private void analyseKey(Connection connection, byte[] msg, int keyPosition) {
        byte endian = msg[6];
        if (msg[5] != 0) {
            endian = (byte)(endian & 1);
        }
        int key_length = this.read_long(msg, keyPosition, endian);
        keyPosition = this.align(keyPosition, 4);
        keyPosition += 4;
        if (NAME_SERVICE_OPERATION.length != key_length && key_length != INIT_REQUEST_OPERATION.length) {
            connection.setDestinationId(this.read_long(msg, keyPosition, (byte)1));
            return;
        }
        int pos = keyPosition;
        int c = 0;
        while (c < key_length) {
            switch (key_length) {
                case 11: {
                    if (msg[pos] == NAME_SERVICE_OPERATION[c]) break;
                    connection.setDestinationId(this.read_long(msg, pos, (byte)1));
                    return;
                }
                case 4: {
                    if (msg[pos] == INIT_REQUEST_OPERATION[c]) break;
                    connection.setDestinationId(this.read_long(msg, pos, (byte)1));
                    return;
                }
            }
            ++c;
            ++pos;
        }
        int lessBusy = CorbaServiceFrame.getLessBusyElement();
        connection.setDestinationId(lessBusy);
    }

    private int getEndPositionOfServiceContext(byte[] msg, int off) {
        byte endian = msg[6];
        if (msg[5] != 0) {
            endian = (byte)(endian & 1);
        }
        off = this.align(off, 4);
        int serviceContextLength = this.read_long(msg, off, endian);
        off += 4;
        int jump = 0;
        int size = 0;
        int j = 0;
        while (j < serviceContextLength) {
            jump = this.align(off, 4);
            size = this.read_long(msg, jump + 4, endian);
            off = 8 + jump + size;
            ++j;
        }
        return off;
    }

    public static String toString(byte[] bytes, int begin, int length) {
        String hex = "0123456789ABCDEF";
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        length = Math.min(length, bytes.length);
        int end = begin + length;
        int c = begin;
        while (c < end) {
            int count = 16;
            StringBuffer text = new StringBuffer();
            int j = c;
            while (--count >= 0 && j < end) {
                int charAsInt = bytes[j] & 0xFF;
                sb.append(" " + hex.charAt(charAsInt >> 4) + hex.charAt(charAsInt & 0xF));
                int ch = charAsInt > 31 ? (int)charAsInt : 46;
                text.append((char)ch);
                ++j;
            }
            while (--count >= -2) {
                sb.append("   ");
            }
            sb.append((Object)text);
            if (c < end - 16) {
                sb.append("   >> ");
                sb.append(c);
                sb.append("\r\n");
            }
            c += 16;
        }
        return sb.toString();
    }
}

