/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.sapprovider;

import com.sap.engine.interfaces.csiv2.SSLSocketProvider;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.SessionManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;

public class SAPSSLProvider
implements SSLSocketProvider {
    private boolean initialized = false;
    private SSLServerContext sslClientContext = null;
    private static CipherSuite[] cipherSuites = null;

    private void init() {
        KeyAndCert credentials = null;
        try {
            cipherSuites = new CipherSuiteList(4).toArray();
            Properties prop = new Properties();
            ((Hashtable)prop).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ((Hashtable)prop).put("appclient", "true");
            KeyStore ks = KeyStoreProvider.getKeyStore("DEFAULT", prop);
            if (ks != null) {
                PrivateKey key = (PrivateKey)ks.getKey("appclient-ssl-credential", new char[0]);
                Certificate[] cert = ks.getCertificateChain("appclient-ssl-credential");
                credentials = new KeyAndCert((X509Certificate[])cert, key);
            }
        }
        catch (Exception ex) {
            Logger.logInfo("SAPSSLProvider can't get credentials, caused by : " + ex.toString());
            Logger.traceWarning("SAPSSLProvider.init()", Logger.exceptionTrace(ex));
        }
        this.sslClientContext = new SSLServerContext();
        if (credentials != null) {
            this.sslClientContext.addClientCredentials(credentials);
            this.sslClientContext.addServerCredentials(credentials);
            this.sslClientContext.setSessionManager((SessionManager)new JSSESessionManager());
            this.sslClientContext.setChainVerifier(null);
            this.sslClientContext.setEnabledCipherSuites(cipherSuites);
            this.sslClientContext.updateCipherSuites();
        }
    }

    public Socket getSSLClientSocket(String host, int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        SSLSocket sslsocket = new SSLSocket(new Socket(host, port), (SSLContext)this.sslClientContext, host, port);
        sslsocket.setDebugStream((OutputStream)System.out);
        sslsocket.startHandshake();
        return sslsocket;
    }

    public ServerSocket getSSLServerSocket(int port) throws IOException {
        return null;
    }
}

