/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.sapprovider;

import com.sap.engine.interfaces.csiv2.SSLSocketProvider;
import com.sap.engine.services.iiop.logging.Logger;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLServerSocket;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.SessionManager;
import iaik.x509.X509Certificate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.PrivateKey;

public class IAIKSSLSocketProvider
implements SSLSocketProvider {
    public static boolean debug = false;
    private boolean initialized = false;
    private SSLServerContext sslClientContext = null;
    private static CipherSuite[] cipherSuites = null;
    private String pkcs12_fname;
    private String password;

    public IAIKSSLSocketProvider() {
    }

    public IAIKSSLSocketProvider(String pkcs12_fname, String password) {
        this.pkcs12_fname = pkcs12_fname;
        this.password = password;
    }

    public Socket getSSLClientSocket(String host, int port) throws IOException {
        if (!this.initialized) {
            cipherSuites = new CipherSuiteList(4).toArray();
            this.sslClientContext = new SSLServerContext();
            this.sslClientContext.setSessionManager((SessionManager)new JSSESessionManager());
            this.sslClientContext.setChainVerifier(null);
            this.sslClientContext.setEnabledCipherSuites(cipherSuites);
            this.initialized = true;
        }
        SSLSocket sslsocket = new SSLSocket(new Socket(host, port), (SSLContext)this.sslClientContext, host, port);
        if (debug) {
            sslsocket.setDebugStream((OutputStream)System.out);
        }
        sslsocket.startHandshake();
        return sslsocket;
    }

    public ServerSocket getSSLServerSocket(int port) throws IOException {
        try {
            PKCS12 pkcs12 = new PKCS12((InputStream)new FileInputStream(this.pkcs12_fname));
            pkcs12.decrypt(this.password.toCharArray());
            PrivateKey pk = pkcs12.getKeyBag().getPrivateKey();
            CertificateBag[] certs = pkcs12.getCertificateBags();
            X509Certificate cert = certs[0].getCertificate();
            KeyAndCert credentials = new KeyAndCert(new java.security.cert.X509Certificate[]{cert}, pk);
            CipherSuite[] cipherSuites = new CipherSuiteList(4).toArray();
            SSLServerContext sslContext = new SSLServerContext();
            sslContext.addClientCredentials(credentials);
            sslContext.addServerCredentials(credentials);
            sslContext.setSessionManager((SessionManager)new JSSESessionManager());
            sslContext.setChainVerifier(null);
            sslContext.setEnabledCipherSuites(cipherSuites);
            sslContext.updateCipherSuites();
            if (debug) {
                sslContext.setDebugStream((OutputStream)System.out);
            }
            SSLServerSocket ss = new SSLServerSocket(port, sslContext);
            return ss;
        }
        catch (Exception e) {
            Logger.logError("Exception while opening SSL server socket, caused by : \n" + Logger.exceptionTrace(e));
            return null;
        }
    }
}

